/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.sqlcache;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.openjpa.kernel.QueryStatistics;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.jdbc.sqlcache.Person;

public class TestMultithreadedReparameterization
extends TestCase {
    private static String RESOURCE = "META-INF/persistence.xml";
    private static String UNIT_NAME = "PreparedQuery";
    protected static OpenJPAEntityManagerFactory emf;

    public void setUp() throws Exception {
        super.setUp();
        if (emf == null) {
            Properties config = new Properties();
            config.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true,SchemaAction='drop,add')");
            config.put("openjpa.Log", "SQL=WARN");
            config.put("openjpa.jdbc.QuerySQLCache", "true(EnableStatistics=true)");
            config.put("openjpa.ConnectionFactoryProperties", "PrintParameters=true");
            emf = OpenJPAPersistence.createEntityManagerFactory((String)UNIT_NAME, (String)RESOURCE, (Map)config);
        }
    }

    public void testReparameterizationUnderHeavyLoad() throws Exception {
        long baseId = System.currentTimeMillis();
        OpenJPAEntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        int nThreads = 80;
        for (int i = 0; i < nThreads; ++i) {
            Person p = new Person();
            p.setId(baseId + (long)i);
            p.setFirstName("First" + i);
            p.setLastName("Last" + i);
            p.setAge((short)(20 + i));
            em.persist((Object)p);
        }
        em.getTransaction().commit();
        String jpql = "select p from Person p where p.id=:id and p.firstName=:first and p.lastName=:last and p.age=:age";
        int nRepeats = 20;
        Thread[] threads = new Thread[nThreads];
        for (int i = 0; i < nThreads; ++i) {
            Object[] args = new Object[]{"id", baseId + (long)i, "first", "First" + i, "last", "Last" + i, "age", (short)(20 + i)};
            QueryThread thread = new QueryThread((EntityManager)emf.createEntityManager(), jpql, args, nRepeats);
            threads[i] = new Thread(thread);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        QueryStatistics stats = emf.getConfiguration().getQuerySQLCacheInstance().getStatistics();
        TestMultithreadedReparameterization.assertEquals((float)(nThreads * nRepeats), (float)stats.getExecutionCount(), (float)stats.getExecutionCount((Object)jpql));
        TestMultithreadedReparameterization.assertEquals((float)(nThreads * nRepeats - 1), (float)stats.getExecutionCount(), (float)stats.getHitCount((Object)jpql));
    }

    public static class QueryThread
    implements Runnable {
        public final EntityManager em;
        public final String jpql;
        public final Object[] args;
        public final int nTimes;

        public QueryThread(EntityManager em, String jpql, Object[] args, int r) {
            this.em = em;
            this.jpql = jpql;
            this.args = args;
            this.nTimes = r;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < this.nTimes; ++i) {
                    TypedQuery q = this.em.createQuery(this.jpql, Person.class);
                    for (int j = 0; j < this.args.length; j += 2) {
                        q.setParameter(this.args[j].toString(), this.args[j + 1]);
                    }
                    List result = q.getResultList();
                    Assert.assertEquals((String)(Thread.currentThread() + " failed"), (int)1, (int)result.size());
                    Person p = (Person)result.get(0);
                    Assert.assertEquals((Object)this.args[1], (Object)p.getId());
                    Assert.assertEquals((Object)this.args[3], (Object)p.getFirstName());
                    Assert.assertEquals((Object)this.args[5], (Object)p.getLastName());
                    Assert.assertEquals((Object)this.args[7], (Object)p.getAge());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.fail();
            }
        }
    }
}

