/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.sqlcache.discrim;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.FinderCache;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.sqlcache.discrim.AbstractExtValue;
import org.apache.openjpa.persistence.jdbc.sqlcache.discrim.ComposedPK;
import org.apache.openjpa.persistence.jdbc.sqlcache.discrim.ExtValue1;
import org.apache.openjpa.persistence.jdbc.sqlcache.discrim.UserData;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestFinderCacheWithNulls
extends SingleEMFTestCase {
    private FetchConfiguration fetchCfg;
    private FinderCache fndrCache;
    private ClassMapping clsMapping_UserData;
    private ClassMapping clsMapping_AbstractExtValue;

    @Override
    public void setUp() throws Exception {
        super.setUp(AbstractExtValue.class, ComposedPK.class, ExtValue1.class, UserData.class);
    }

    public void test() {
        this.init();
        this.initData();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TestFinderCacheWithNulls.assertNull((Object)this.fndrCache.get((Object)this.clsMapping_UserData, this.fetchCfg));
        UserData usrData = (UserData)em.find(UserData.class, (Object)new ComposedPK(Short.valueOf("2"), null));
        TestFinderCacheWithNulls.assertNull((Object)usrData);
        TestFinderCacheWithNulls.assertNull((Object)this.fndrCache.get((Object)this.clsMapping_UserData, this.fetchCfg));
        em.clear();
        usrData = (UserData)em.find(UserData.class, (Object)new ComposedPK(Short.valueOf("2"), 3));
        TestFinderCacheWithNulls.assertNotNull((Object)usrData);
        TestFinderCacheWithNulls.assertNull((Object)this.fndrCache.get((Object)this.clsMapping_UserData, this.fetchCfg));
        em.clear();
        ExtValue1 ev1 = (ExtValue1)em.find(ExtValue1.class, (Object)"A");
        TestFinderCacheWithNulls.assertNotNull((Object)ev1);
        TestFinderCacheWithNulls.assertNotNull((Object)this.fndrCache.get((Object)this.clsMapping_AbstractExtValue, this.fetchCfg));
        em.clear();
        this.fndrCache.invalidate((Object)this.clsMapping_AbstractExtValue);
        TestFinderCacheWithNulls.assertNull((Object)this.fndrCache.get((Object)this.clsMapping_AbstractExtValue, this.fetchCfg));
        AbstractExtValue aev = (AbstractExtValue)em.find(AbstractExtValue.class, (Object)"A");
        TestFinderCacheWithNulls.assertNotNull((Object)aev);
        TestFinderCacheWithNulls.assertNotNull((Object)this.fndrCache.get((Object)this.clsMapping_AbstractExtValue, this.fetchCfg));
        em.close();
    }

    public void init() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        JDBCConfiguration conf = (JDBCConfiguration)this.emf.getConfiguration();
        this.clsMapping_UserData = conf.getMappingRepositoryInstance().getMapping(UserData.class, null, true);
        this.clsMapping_AbstractExtValue = conf.getMappingRepositoryInstance().getMapping(AbstractExtValue.class, null, true);
        this.fetchCfg = ((EntityManagerImpl)em).getBroker().getFetchConfiguration();
        this.fndrCache = ((JDBCConfiguration)this.emf.getConfiguration()).getFinderCacheInstance();
        em.close();
    }

    public void initData() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        ExtValue1 extValue1 = new ExtValue1();
        extValue1.setCode("A");
        em.getTransaction().begin();
        em.persist((Object)extValue1);
        em.flush();
        ComposedPK pK = new ComposedPK((short)2, 3);
        UserData userData = new UserData();
        userData.setPk(pK);
        userData.setExtValue(extValue1);
        em.persist((Object)userData);
        em.getTransaction().commit();
        em.close();
    }
}

