/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.update;

import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.update.Child;
import org.apache.openjpa.persistence.jdbc.update.Parent;
import org.apache.openjpa.persistence.test.CombinatorialPersistenceTestCase;

public class TestParentChild
extends CombinatorialPersistenceTestCase {
    private static String Key_UpdateManager = "openjpa.jdbc.UpdateManager";
    private static String Key_SchemaFactory = "openjpa.jdbc.SchemaFactory";
    private static String Key_MappingDefaults = "openjpa.jdbc.MappingDefaults";
    private static String Key_PersistOrder = "persist-order";
    private static String[] Option_MappingDefaults = new String[]{"ForeignKeyDeleteAction=restrict, JoinForeignKeyDeleteAction=restrict", "ForeignKeyDeleteAction=none, JoinForeignKeyDeleteAction=none"};
    private static String[] Option_SchemaFactory = new String[]{"native(ForeignKeys=false)", "native(ForeignKeys=true)"};
    private static String[] Option_UpdateManager = new String[]{"operation-order", "constraint"};

    @Override
    public void setUp() {
        TestParentChild.getHelper().addOption(Key_MappingDefaults, Option_MappingDefaults);
        TestParentChild.getHelper().addOption(Key_SchemaFactory, Option_SchemaFactory);
        TestParentChild.getHelper().addOption(Key_UpdateManager, Option_UpdateManager);
        TestParentChild.getHelper().addOption(Key_PersistOrder, (Object[])PersistOrder.values(), true);
        this.sql.clear();
        super.setUp(DROP_TABLES, Parent.class, Child.class);
    }

    public void testInsert() {
        Parent parent = this.createData(this.getPersistOrder(), 3);
        this.validateData(parent.getId(), 3);
        this.assertLogicalOrPhysicalForeignKey();
        this.assertPhysicalForeignKeyCreation();
    }

    Parent createData(PersistOrder order, int nChild) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Parent parent = new Parent();
        parent.setName("parent");
        for (int i = 1; i <= nChild; ++i) {
            parent.newChild("Child-" + i);
        }
        switch (order) {
            case IMPLICIT_CASCADE: {
                em.persist((Object)parent);
                break;
            }
            case CHILD_THEN_PARENT: {
                for (Child child : parent.getChildren()) {
                    em.persist((Object)child);
                }
                em.persist((Object)parent);
                break;
            }
            case PARENT_THEN_CHILD: {
                em.persist((Object)parent);
                for (Child child : parent.getChildren()) {
                    em.persist((Object)child);
                }
                break;
            }
            default: {
                throw new RuntimeException("Bad order " + (Object)((Object)order));
            }
        }
        em.getTransaction().commit();
        em.clear();
        return parent;
    }

    void validateData(Object pid, int childCount) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Parent parent = (Parent)em.find(Parent.class, pid);
        TestParentChild.assertNotNull((Object)parent);
        TestParentChild.assertEquals((int)childCount, (int)parent.getChildren().size());
        em.getTransaction().rollback();
    }

    void assertPhysicalForeignKeyCreation() {
        String regex = "ALTER TABLE .* ADD FOREIGN KEY \\(PARENT_ID\\) REFERENCES Parent \\(id\\)(\\sDEFERRABLE)?";
        if (this.getMappingDefaults().contains("restrict")) {
            this.assertSQL(regex);
        } else {
            this.assertNotSQL(regex);
        }
    }

    void assertPostInsertUpdate() {
        if (this.getPersistOrder().equals((Object)PersistOrder.CHILD_THEN_PARENT) && this.getMappingDefaults().contains("restrict")) {
            this.assertSQL("UPDATE .* SET PARENT_ID .* WHERE .*");
        }
    }

    void assertLogicalOrPhysicalForeignKey() {
        ForeignKey fk = this.getChildParentForeignKey();
        boolean physicalKeyExists = this.getMappingDefaults().contains("restrict");
        boolean keyRead = this.getSchemaFactory().contains("ForeignKeys=true");
        if (physicalKeyExists && keyRead) {
            TestParentChild.assertFalse((boolean)fk.isLogical());
        } else if (keyRead) {
            TestParentChild.assertTrue((boolean)fk.isLogical());
        }
    }

    ForeignKey getChildParentForeignKey() {
        MetaDataRepository repos = this.emf.getConfiguration().getMetaDataRepositoryInstance();
        ClassMetaData child = repos.getCachedMetaData(Child.class);
        FieldMapping parent = (FieldMapping)child.getField("parent");
        return parent.getForeignKey();
    }

    PersistOrder getPersistOrder() {
        return (PersistOrder)((Object)TestParentChild.getHelper().getOption(Key_PersistOrder));
    }

    String getMappingDefaults() {
        return TestParentChild.getHelper().getOptionAsString(Key_MappingDefaults);
    }

    String getSchemaFactory() {
        return TestParentChild.getHelper().getOptionAsString(Key_SchemaFactory);
    }

    static {
        TestParentChild.getHelper().addOption(Key_MappingDefaults, Option_MappingDefaults);
        TestParentChild.getHelper().addOption(Key_SchemaFactory, Option_SchemaFactory);
        TestParentChild.getHelper().addOption(Key_UpdateManager, Option_UpdateManager);
        TestParentChild.getHelper().addOption(Key_PersistOrder, (Object[])PersistOrder.values(), true);
    }

    private static enum PersistOrder {
        IMPLICIT_CASCADE,
        CHILD_THEN_PARENT,
        PARENT_THEN_CHILD;

    }
}

