/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.version;

import java.util.List;
import javax.persistence.EntityTransaction;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.version.model.IntVersion;
import org.apache.openjpa.persistence.jdbc.version.model.ShortVersion;
import org.apache.openjpa.persistence.jdbc.version.model.TimestampVersion;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestVersionColumn
extends SQLListenerTestCase {
    @Override
    public void setUp() {
        super.setUp(IntVersion.class, TimestampVersion.class, ShortVersion.class);
    }

    public void testNullIntegerVersion() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        em.persist((Object)new IntVersion());
        em.persist((Object)new IntVersion());
        tran.commit();
        tran.begin();
        em.createNativeQuery("UPDATE IntVersion set version = NULL").executeUpdate();
        tran.commit();
        em.clear();
        this.resetSQL();
        List results = em.createQuery("SELECT i from IntVersion i", IntVersion.class).getResultList();
        TestVersionColumn.assertNotNull((String)"No results found", (Object)results);
        TestVersionColumn.assertFalse((String)"No results found", (boolean)results.isEmpty());
        for (IntVersion iv : results) {
            TestVersionColumn.assertEquals((String)("Version should be initialized to 0, was: " + iv.getVersion()), (int)0, (int)iv.getVersion());
            em.find(IntVersion.class, (Object)iv.getId());
        }
        TestVersionColumn.assertEquals((String)("Unexpected number of SQL statements: " + this.getSQLCount()), (int)1, (int)this.getSQLCount());
        em.close();
    }

    public void testNullTimestampVersion() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        em.persist((Object)new TimestampVersion());
        em.persist((Object)new TimestampVersion());
        tran.commit();
        tran.begin();
        em.createNativeQuery("UPDATE TimestampVersion set version = NULL").executeUpdate();
        tran.commit();
        em.clear();
        this.resetSQL();
        List results = em.createQuery("SELECT i from TimestampVersion i", TimestampVersion.class).getResultList();
        TestVersionColumn.assertNotNull((String)"No results found", (Object)results);
        TestVersionColumn.assertFalse((String)"No results found", (boolean)results.isEmpty());
        for (TimestampVersion iv : results) {
            TestVersionColumn.assertEquals((String)("Version should be initialized to null, was: " + iv.getVersion()), null, (Object)iv.getVersion());
            em.find(TimestampVersion.class, (Object)iv.getId());
        }
        TestVersionColumn.assertEquals((String)("Unexpected number of SQL statements: " + this.getSQLCount()), (int)1, (int)this.getSQLCount());
        em.close();
    }

    public void testNullShortVersion() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        em.persist((Object)new ShortVersion());
        em.persist((Object)new ShortVersion());
        tran.commit();
        tran.begin();
        em.createNativeQuery("UPDATE ShortVersion set version = NULL").executeUpdate();
        tran.commit();
        em.clear();
        this.resetSQL();
        List results = em.createQuery("SELECT i from ShortVersion i", ShortVersion.class).getResultList();
        TestVersionColumn.assertNotNull((String)"No results found", (Object)results);
        TestVersionColumn.assertFalse((String)"No results found", (boolean)results.isEmpty());
        for (ShortVersion iv : results) {
            TestVersionColumn.assertEquals((String)("Version should be initialized to 0, was" + iv.getVersion()), (int)0, (int)iv.getVersion());
            em.find(ShortVersion.class, (Object)iv.getId());
        }
        TestVersionColumn.assertEquals((String)("Unexpected number of SQL statements: " + this.getSQLCount()), (int)1, (int)this.getSQLCount());
        em.close();
    }
}

