/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jpql.clauses;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.common.apps.RuntimeTest2;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;

public class TestEJBDeleteUpdateImpl
extends AbstractTestCase {
    public TestEJBDeleteUpdateImpl() {
    }

    public TestEJBDeleteUpdateImpl(String name) {
        super(name, "jpqlclausescactusapp");
    }

    public void setUp() {
        this.deleteAll(RuntimeTest1.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        RuntimeTest1 runt1 = new RuntimeTest1(1);
        runt1.setStringField("runt1");
        runt1.setSelfOneOne(new RuntimeTest1(2));
        RuntimeTest2 runt2 = new RuntimeTest2(3);
        runt2.setStringField("runt2");
        em.persist((Object)runt1);
        em.persist((Object)runt2);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testUpdate1() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        RuntimeTest1 ret = (RuntimeTest1)em.find(RuntimeTest1.class, (Object)1);
        TestEJBDeleteUpdateImpl.assertNotNull((Object)ret);
        TestEJBDeleteUpdateImpl.assertEquals((String)"runt1", (String)ret.getStringField());
        TestEJBDeleteUpdateImpl.assertNotNull((Object)ret.getSelfOneOne());
        String ejbqlUpdate = "UPDATE RuntimeTest1 x SET x.stringField = :strngfld WHERE x.stringField = :stdfield";
        int updatedEntities = em.createQuery(ejbqlUpdate).setParameter("strngfld", (Object)"runner13").setParameter("stdfield", (Object)"runt1").executeUpdate();
        TestEJBDeleteUpdateImpl.assertEquals((int)1, (int)updatedEntities);
        this.endTx((EntityManager)em);
        RuntimeTest1 ret2 = (RuntimeTest1)em.find(RuntimeTest1.class, (Object)1);
        em.refresh((Object)ret2);
        TestEJBDeleteUpdateImpl.assertNotNull((Object)ret2);
        TestEJBDeleteUpdateImpl.assertEquals((String)"runner13", (String)ret2.getStringField());
        em.close();
    }

    public void testUpdate2() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        RuntimeTest1 run = (RuntimeTest1)em.find(RuntimeTest1.class, (Object)1);
        TestEJBDeleteUpdateImpl.assertNotNull((Object)run);
        TestEJBDeleteUpdateImpl.assertEquals((String)"runt1", (String)run.getStringField());
        TestEJBDeleteUpdateImpl.assertNotNull((Object)run.getSelfOneOne());
        String ejbqlUpdate = "UPDATE RuntimeTest1 x SET x.stringField = :strngfld WHERE x.stringField = :field AND x.selfOneOne IS NOT NULL";
        int upEntities = em.createQuery(ejbqlUpdate).setParameter("strngfld", (Object)"upd").setParameter("field", (Object)"runt1").executeUpdate();
        TestEJBDeleteUpdateImpl.assertEquals((int)1, (int)upEntities);
        RuntimeTest1 inst = (RuntimeTest1)em.find(RuntimeTest1.class, (Object)1);
        em.refresh((Object)inst);
        TestEJBDeleteUpdateImpl.assertNotNull((Object)inst);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testDelete1() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        RuntimeTest1 run = (RuntimeTest1)em.find(RuntimeTest1.class, (Object)1);
        TestEJBDeleteUpdateImpl.assertNotNull((Object)run);
        TestEJBDeleteUpdateImpl.assertEquals((String)"runt1", (String)run.getStringField());
        TestEJBDeleteUpdateImpl.assertNotNull((Object)run.getSelfOneOne());
        String ejbdelUpdate = "DELETE FROM RuntimeTest1 s WHERE s.stringField = :strngfld";
        int delEntity = em.createQuery(ejbdelUpdate).setParameter("strngfld", (Object)"runt1").executeUpdate();
        TestEJBDeleteUpdateImpl.assertEquals((int)1, (int)delEntity);
        RuntimeTest1 del = (RuntimeTest1)em.find(RuntimeTest1.class, (Object)1);
        TestEJBDeleteUpdateImpl.assertNull((Object)del);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testDelete2() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        RuntimeTest1 run = (RuntimeTest1)em.find(RuntimeTest1.class, (Object)1);
        TestEJBDeleteUpdateImpl.assertNotNull((Object)run);
        TestEJBDeleteUpdateImpl.assertEquals((String)"runt1", (String)run.getStringField());
        TestEJBDeleteUpdateImpl.assertNotNull((Object)run.getSelfOneOne());
        String ejbdelUpdate = "DELETE FROM RuntimeTest1 r WHERE r.stringField = ?1";
        Query query = em.createQuery(ejbdelUpdate);
        query.setParameter(1, (Object)"runt1");
        int ok = query.executeUpdate();
        TestEJBDeleteUpdateImpl.assertEquals((int)1, (int)ok);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }
}

