/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jpql.clauses;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.common.apps.RuntimeTest2;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;

public class TestEJBPolymorphicQuery
extends AbstractTestCase {
    public TestEJBPolymorphicQuery(String name) {
        super(name, "jpqlclausescactusapp");
    }

    public void setUp() {
        int i;
        this.deleteAll(RuntimeTest1.class);
        this.deleteAll(RuntimeTest2.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        int run1 = 10;
        int run2 = 15;
        for (i = 0; i < run1; ++i) {
            RuntimeTest1 rt = new RuntimeTest1(i);
            rt.setStringField("foo " + i);
            em.persist((Object)rt);
        }
        for (i = 10; i < run2; ++i) {
            em.persist((Object)new RuntimeTest2(i));
        }
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testPolymorphicSelect() {
        OpenJPAEntityManager em = this.currentEntityManager();
        List l = em.createQuery("Select object(o) from RuntimeTest1 o").getResultList();
        TestEJBPolymorphicQuery.assertNotNull((Object)l);
        TestEJBPolymorphicQuery.assertEquals((int)15, (int)l.size());
        this.endEm((EntityManager)em);
    }

    public void testPolymorphicDelete() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        int l = em.createQuery("Delete from RuntimeTest1").executeUpdate();
        TestEJBPolymorphicQuery.assertNotNull((Object)l);
        TestEJBPolymorphicQuery.assertEquals((int)15, (int)l);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }
}

