/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jpql.expressions;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SybaseDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.common.apps.Address;
import org.apache.openjpa.persistence.common.apps.CompUser;
import org.apache.openjpa.persistence.common.apps.FemaleUser;
import org.apache.openjpa.persistence.common.apps.MaleUser;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;

public class TestJPQLScalarExpressions
extends AbstractTestCase {
    private int userid1;
    private int userid2;
    private int userid3;
    private int userid4;
    private int userid5;
    private int userid6;
    private String expectedShannonName = "Shannon ";

    public TestJPQLScalarExpressions(String name) {
        super(name, "jpqlclausescactusapp");
    }

    public void setUp() {
        this.deleteAll(CompUser.class);
        OpenJPAEntityManagerSPI em = (OpenJPAEntityManagerSPI)this.currentEntityManager();
        this.startTx((EntityManager)em);
        Address[] add = new Address[]{new Address("43 Sansome", "SF", "United-Kingdom", "94104"), new Address("24 Mink", "ANTIOCH", "USA", "94513"), new Address("23 Ogbete", "CoalCamp", "NIGERIA", "00000"), new Address("10 Wilshire", "Worcester", "CANADA", "80080"), new Address("23 Bellflower", "Ogui", null, "02000"), new Address("22 Montgomery", "SF", null, "50054")};
        CompUser user1 = this.createUser("Seetha", "MAC", add[0], 36, true);
        CompUser user2 = this.createUser("Shannon ", "PC", add[1], 36, false);
        CompUser user3 = this.createUser("Ugo", "PC", add[2], 19, true);
        CompUser user4 = this.createUser("Jacob", "LINUX", add[3], 10, true);
        CompUser user5 = this.createUser("Famzy", "UNIX", add[4], 29, false);
        CompUser user6 = this.createUser("Shade", "UNIX", add[5], 23, false);
        em.persist((Object)user1);
        this.userid1 = user1.getUserid();
        em.persist((Object)user2);
        this.userid2 = user2.getUserid();
        em.persist((Object)user3);
        this.userid3 = user3.getUserid();
        em.persist((Object)user4);
        this.userid4 = user4.getUserid();
        em.persist((Object)user5);
        this.userid5 = user5.getUserid();
        em.persist((Object)user6);
        this.userid6 = user6.getUserid();
        DBDictionary dict = ((JDBCConfiguration)em.getConfiguration()).getDBDictionaryInstance();
        if (dict instanceof SybaseDictionary) {
            this.expectedShannonName = "Shannon";
        }
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testAggregateResultVariable() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String[] querys = new String[]{"SELECT c.name, AVG(c.age) as age, a.city FROM CompUser c left join c.address a  group by c.name, a.city order by age desc, c.name", "SELECT c.name as name, SUM(c.age) as sage FROM CompUser c group by c.name order by sage desc, name", "SELECT c.name, AVG(c.age) as age FROM CompUser c group by c.name order by age desc, c.name"};
        for (int i = 0; i < querys.length; ++i) {
            Query query = em.createQuery(querys[i]);
            query.setFirstResult(1);
            query.setMaxResults(4);
            List rs = query.getResultList();
            Object val = ((Object[])rs.get(0))[1];
            if (val instanceof Integer) {
                TestJPQLScalarExpressions.assertTrue(((Integer)val > 0 ? 1 : 0) != 0);
                continue;
            }
            if (!(val instanceof Long)) continue;
            TestJPQLScalarExpressions.assertTrue(((Long)val > 0L ? 1 : 0) != 0);
        }
    }

    public void testMathAndAggregate() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String[] query = new String[]{"SELECT SUM(c.age) as age FROM CompUser c", "SELECT SUM(c.age) + SUM(c.userid) FROM CompUser c", "SELECT SUM(c.age) * SUM(c.userid) FROM CompUser c", "SELECT SUM(c.age) - MIN(c.userid) + MAX(c.userid) FROM CompUser c"};
        for (int i = 0; i < query.length; ++i) {
            List rs = em.createQuery(query[i]).getResultList();
            TestJPQLScalarExpressions.assertTrue(((Long)rs.get(0) > 0L ? 1 : 0) != 0);
        }
        String[] query2 = new String[]{"SELECT SUM(c.age) + SUM(c.userid), MIN(c.age) + MAX(c.age) FROM CompUser c", "SELECT SUM(c.age) * SUM(c.userid), AVG(c.age) FROM CompUser c", "SELECT SUM(c.age) - MIN(c.userid) + MAX(c.userid), AVG(c.age)/10 FROM CompUser c"};
        for (int i = 0; i < query2.length; ++i) {
            List rs = em.createQuery(query2[i]).getResultList();
            TestJPQLScalarExpressions.assertNotNull((Object)((Object[])rs.get(0))[1]);
        }
        this.endEm((EntityManager)em);
    }

    public void testCoalesceExpressions() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        String query = "SELECT e.name, COALESCE (e.address.country, 'Unknown') FROM CompUser e ORDER BY e.name DESC";
        List rs = em.createQuery(query).getResultList();
        Object[] result = (Object[])rs.get(rs.size() - 1);
        TestJPQLScalarExpressions.assertEquals((String)"the name is not famzy", (Object)"Famzy", (Object)result[0]);
        TestJPQLScalarExpressions.assertEquals((Object)"Unknown", (Object)result[1]);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testNullIfExpressions() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        String query = "SELECT e.name, NULLIF (e.address.country, 'USA') FROM CompUser e ORDER BY e.name DESC";
        List rs = em.createQuery(query).getResultList();
        Object[] result = (Object[])rs.get(1);
        TestJPQLScalarExpressions.assertEquals((String)"the name is not shannon ", (Object)this.expectedShannonName, (Object)result[0]);
        TestJPQLScalarExpressions.assertNull((String)"is not null", (Object)result[1]);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testSimpleCaseExpressions() {
        OpenJPAEntityManager em = this.currentEntityManager();
        CompUser user = (CompUser)em.find(CompUser.class, (Object)this.userid1);
        TestJPQLScalarExpressions.assertNotNull((String)"user is null", (Object)user);
        TestJPQLScalarExpressions.assertEquals((String)"the name is not seetha", (String)"Seetha", (String)user.getName());
        String query = "SELECT e.name, e.age+1 as cage, CASE e.address.country WHEN 'USA' THEN 'us'  ELSE 'non-us'  END as d2, e.address.country  FROM CompUser e ORDER BY cage, d2 DESC";
        List rs = em.createQuery(query).getResultList();
        Object[] result = (Object[])rs.get(rs.size() - 1);
        TestJPQLScalarExpressions.assertEquals((String)"the name is not seetha", (Object)"Seetha", (Object)result[0]);
        String query2 = "SELECT e.name, e.age+1 as cage, CASE e.address.country WHEN 'USA' THEN 'United-States'  ELSE e.address.country  END as d2, e.address.country  FROM CompUser e ORDER BY cage, d2 DESC";
        List rs2 = em.createQuery(query2).getResultList();
        Object[] result2 = (Object[])rs2.get(rs2.size() - 1);
        TestJPQLScalarExpressions.assertEquals((String)"the name is not seetha", (Object)"Seetha", (Object)result2[0]);
        String query3 = "SELECT e.name,  CASE TYPE(e) WHEN FemaleUser THEN 'Female'  ELSE 'Male'  END as result FROM CompUser e WHERE e.name like 'S%'  ORDER BY e.name DESC";
        List rs3 = em.createQuery(query3).getResultList();
        Object[] result3 = (Object[])rs3.get(0);
        TestJPQLScalarExpressions.assertEquals((String)"the result is not female", (Object)"Female", (Object)result3[1]);
        TestJPQLScalarExpressions.assertEquals((String)"the name is not shannon", (Object)this.expectedShannonName, (Object)result3[0]);
        result3 = (Object[])rs3.get(2);
        TestJPQLScalarExpressions.assertEquals((String)"the result is not male", (Object)"Male", (Object)result3[1]);
        TestJPQLScalarExpressions.assertEquals((String)"the name is not seetha", (Object)"Seetha", (Object)result3[0]);
        query = "SELECT e.name, CASE e.address.country WHEN 'USA' THEN true  ELSE false  END as b, e.address.country  FROM CompUser e order by b";
        rs = em.createQuery(query).getResultList();
        result = (Object[])rs.get(rs.size() - 1);
        if (result[1] instanceof String) {
            TestJPQLScalarExpressions.assertEquals((Object)result[1], (Object)"true");
        } else {
            TestJPQLScalarExpressions.assertEquals((Object)result[1], (Object)1);
        }
        this.startTx((EntityManager)em);
        String update = "update CompUser c set c.creditRating =  CASE c.age WHEN 35 THEN org.apache.openjpa.persistence.common.apps.CompUser$CreditRating.POOR WHEN 11 THEN org.apache.openjpa.persistence.common.apps.CompUser$CreditRating.GOOD ELSE org.apache.openjpa.persistence.common.apps.CompUser$CreditRating.EXCELLENT END ";
        int updateCount = em.createQuery(update).executeUpdate();
        TestJPQLScalarExpressions.assertEquals((String)"the result is not 6", (int)6, (int)updateCount);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testGeneralCaseExpressions() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        CompUser user = (CompUser)em.find(CompUser.class, (Object)this.userid1);
        TestJPQLScalarExpressions.assertNotNull((String)"user is null", (Object)user);
        TestJPQLScalarExpressions.assertEquals((String)"the name is not seetha", (String)"Seetha", (String)user.getName());
        String query = "SELECT e.name, e.age,  CASE WHEN e.age > 30 THEN e.age - 1  WHEN e.age < 15 THEN e.age + 1  ELSE e.age + 0  END AS cage  FROM CompUser e ORDER BY cage";
        List rs = em.createQuery(query).getResultList();
        String update = "UPDATE CompUser e SET e.age = CASE WHEN e.age > 30 THEN e.age - 1 WHEN e.age < 15 THEN e.age + 1 ELSE e.age + 0 END";
        int result = em.createQuery(update).executeUpdate();
        TestJPQLScalarExpressions.assertEquals((String)"the result is not 6", (int)6, (int)result);
        String query2 = "SELECT e.name, e.age+1 as cage, CASE WHEN e.address.country = 'USA'  THEN 'United-States'  ELSE 'Non United-States'  END as d2, e.address.country  FROM CompUser e ORDER BY cage, d2 DESC";
        List rs2 = em.createQuery(query2).getResultList();
        Object[] result2 = (Object[])rs2.get(rs2.size() - 1);
        TestJPQLScalarExpressions.assertEquals((String)"the name is not seetha", (Object)"Seetha", (Object)result2[0]);
        TestJPQLScalarExpressions.assertEquals((String)"the country is not 'Non United-States'", (Object)"Non United-States", (Object)result2[2]);
        String query3 = " select e.name, CASE WHEN e.age = 11 THEN org.apache.openjpa.persistence.common.apps.CompUser$CreditRating.POOR WHEN e.age = 35 THEN org.apache.openjpa.persistence.common.apps.CompUser$CreditRating.GOOD ELSE org.apache.openjpa.persistence.common.apps.CompUser$CreditRating.EXCELLENT END FROM CompUser e ORDER BY e.age";
        List rs3 = em.createQuery(query3).getResultList();
        Object[] result3 = (Object[])rs3.get(0);
        TestJPQLScalarExpressions.assertEquals((String)"the name is not Jacob", (Object)"Jacob", (Object)result3[0]);
        TestJPQLScalarExpressions.assertEquals((String)"the credit rating is not 'POOR'", (Object)"POOR", (Object)result3[1]);
        String update2 = "update CompUser c set c.creditRating =  CASE WHEN c.name ='Jacob' THEN org.apache.openjpa.persistence.common.apps.CompUser$CreditRating.POOR WHEN c.name = 'Ugo' THEN org.apache.openjpa.persistence.common.apps.CompUser$CreditRating.GOOD  ELSE org.apache.openjpa.persistence.common.apps.CompUser$CreditRating.EXCELLENT  END ";
        int updateCount = em.createQuery(update2).executeUpdate();
        TestJPQLScalarExpressions.assertEquals((String)"the result is not 6", (int)6, (int)updateCount);
        String update3 = "update CompUser c set c.creditRating =  CASE WHEN c.age > 30 THEN org.apache.openjpa.persistence.common.apps.CompUser$CreditRating.POOR WHEN c.age < 15 THEN org.apache.openjpa.persistence.common.apps.CompUser$CreditRating.GOOD  ELSE org.apache.openjpa.persistence.common.apps.CompUser$CreditRating.EXCELLENT  END ";
        updateCount = em.createQuery(update3).executeUpdate();
        TestJPQLScalarExpressions.assertEquals((String)"the result is not 6", (int)6, (int)updateCount);
        String query4 = "select e.name, e.creditRating from CompUser e where e.creditRating = (select CASE WHEN e1.age = 11 THEN org.apache.openjpa.persistence.common.apps.CompUser$CreditRating.POOR WHEN e1.age = 35 THEN org.apache.openjpa.persistence.common.apps.CompUser$CreditRating.GOOD ELSE org.apache.openjpa.persistence.common.apps.CompUser$CreditRating.EXCELLENT END from CompUser e1 where e.userid = e1.userid) ORDER BY e.age";
        List rs4 = em.createQuery(query4).getResultList();
        Object[] result4 = (Object[])rs4.get(0);
        TestJPQLScalarExpressions.assertEquals((String)"the name is not Ugo", (Object)"Ugo", (Object)result4[0]);
        TestJPQLScalarExpressions.assertEquals((String)"the credit rating is not 'EXCELLENT'", (String)"EXCELLENT", (String)((CompUser.CreditRating)((Object)result4[1])).name());
        String update4 = "update CompUser c set c.creditRating =  CASE c.age WHEN 35 THEN org.apache.openjpa.persistence.common.apps.CompUser$CreditRating.POOR WHEN 11 THEN org.apache.openjpa.persistence.common.apps.CompUser$CreditRating.GOOD  ELSE org.apache.openjpa.persistence.common.apps.CompUser$CreditRating.EXCELLENT  END ";
        result = em.createQuery(update4).executeUpdate();
        TestJPQLScalarExpressions.assertEquals((String)"the result is not 6", (int)6, (int)result);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testMathFuncOrderByAlias() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT e.age * 2 as cAge FROM CompUser e ORDER BY cAge";
        List result = em.createQuery(query).getResultList();
        TestJPQLScalarExpressions.assertNotNull((Object)result);
        TestJPQLScalarExpressions.assertEquals((int)6, (int)result.size());
        this.endEm((EntityManager)em);
    }

    public CompUser createUser(String name, String cName, Address add, int age, boolean isMale) {
        CompUser user = null;
        if (isMale) {
            user = new MaleUser();
            user.setName(name);
            user.setComputerName(cName);
            user.setAddress(add);
            user.setAge(age);
        } else {
            user = new FemaleUser();
            user.setName(name);
            user.setComputerName(cName);
            user.setAddress(add);
            user.setAge(age);
        }
        return user;
    }
}

