/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jpql.functions;

import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.common.apps.Address;
import org.apache.openjpa.persistence.common.apps.CompUser;
import org.apache.openjpa.persistence.common.apps.FemaleUser;
import org.apache.openjpa.persistence.common.apps.MaleUser;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestSetParameter
extends SingleEMFTestCase {
    private int userid;
    private static String ORIGINAL_NAME = "Shannon";
    private static int ORIGINAL_AGE = 62;
    private static String UPDATED_NAME = "Obama";
    private static int UPDATED_AGE = 29;

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, CompUser.class, MaleUser.class, FemaleUser.class, Address.class);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        CompUser user = this.createUser(ORIGINAL_NAME, "PC", ORIGINAL_AGE, false);
        em.persist((Object)user);
        em.getTransaction().commit();
        this.userid = user.getUserid();
        em.close();
    }

    public void testSetPositionalParameter() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        String query = "UPDATE CompUser e set e.name= ?1, e.age = ?2 WHERE e.userid = ?3";
        int count = em.createQuery(query).setParameter(1, (Object)UPDATED_NAME).setParameter(2, (Object)UPDATED_AGE).setParameter(3, (Object)this.userid).executeUpdate();
        em.getTransaction().commit();
        TestSetParameter.assertEquals((int)1, (int)count);
        em.close();
        this.verifyUpdate();
    }

    public void testSetPositionalParameterInNonIntutiveOrder() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        String query = "UPDATE CompUser e set e.name= ?2, e.age = ?1 WHERE e.userid = ?3";
        int count = em.createQuery(query).setParameter(2, (Object)UPDATED_NAME).setParameter(1, (Object)UPDATED_AGE).setParameter(3, (Object)this.userid).executeUpdate();
        em.getTransaction().commit();
        TestSetParameter.assertEquals((int)1, (int)count);
        em.close();
        this.verifyUpdate();
    }

    public void testSetNamedParameter() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        String query = "UPDATE CompUser e set e.name= :name, e.age = :age WHERE e.userid = :id";
        int count = em.createQuery(query).setParameter("name", (Object)UPDATED_NAME).setParameter("age", (Object)UPDATED_AGE).setParameter("id", (Object)this.userid).executeUpdate();
        em.getTransaction().commit();
        TestSetParameter.assertEquals((int)1, (int)count);
        em.close();
        this.verifyUpdate();
    }

    public void testNativeSQL() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        int count = em.createNativeQuery("INSERT INTO Address (id, city, country, streetAd, zipcode) VALUES (?,?,?,?,?)").setParameter(1, (Object)(System.currentTimeMillis() % 10000L)).setParameter(2, (Object)"Some City").setParameter(3, (Object)"Some Country").setParameter(4, (Object)"Some Street").setParameter(5, (Object)String.valueOf(System.currentTimeMillis() % 10000L)).executeUpdate();
        em.getTransaction().commit();
        TestSetParameter.assertEquals((int)1, (int)count);
    }

    public void testMissingFirstPositionalParameter() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "UPDATE CompUser e set e.name= ?2, e.age = ?4 WHERE e.userid = ?3";
        try {
            em.createQuery(query);
            TestSetParameter.fail((String)"Did not get UserException with invalid JPQL query");
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
        em.close();
    }

    public void testMixedParameterTypesParameter() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "UPDATE CompUser e set e.name= :name, e.age = ?1 WHERE e.userid = ?3";
        try {
            em.createQuery(query);
            TestSetParameter.fail((String)"Did not get UserException with invalid JPQL query");
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
        em.close();
    }

    public CompUser createUser(String name, String cName, int age, boolean isMale) {
        CompUser user = null;
        Address addr = new Address("43 Sansome", "SF", "United-Kingdom", "94104");
        if (isMale) {
            user = new MaleUser();
            user.setName(name);
            user.setComputerName(cName);
            user.setAge(age);
        } else {
            user = new FemaleUser();
            user.setName(name);
            user.setComputerName(cName);
            user.setAge(age);
        }
        user.setAddress(addr);
        return user;
    }

    void verifyUpdate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        CompUser user = (CompUser)em.find(CompUser.class, (Object)this.userid);
        TestSetParameter.assertEquals((String)UPDATED_NAME, (String)user.getName());
        TestSetParameter.assertEquals((int)UPDATED_AGE, (int)user.getAge());
    }
}

