/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jpql.joins.leftfetch;

import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jpql.joins.leftfetch.DepartmentTest;
import org.apache.openjpa.persistence.jpql.joins.leftfetch.PersonTest;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestJoinLeftFetch
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(DROP_TABLES, DepartmentTest.class, PersonTest.class);
        this.createTestData();
    }

    public void testReadDepartmentsWithLeftJoinFetch() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String qStrDIST = "SELECT DISTINCT dept FROM DepartmentTest dept LEFT JOIN FETCH dept.persons";
        Query query = em.createQuery(qStrDIST);
        List depts = query.getResultList();
        this.verifySize(depts);
        em.close();
    }

    public void verifySize(List<DepartmentTest> depts) {
        for (DepartmentTest department : depts) {
            if (department.getPrimaryKey().equals("001")) {
                TestJoinLeftFetch.assertEquals((String)"Size should be 3", (int)3, (int)department.getPersons().size());
            }
            if (!department.getPrimaryKey().equals("002")) continue;
            TestJoinLeftFetch.assertEquals((String)"Size should be 2", (int)2, (int)department.getPersons().size());
        }
    }

    public void testReadDepartmentsWithFetchPlan() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAQuery query = OpenJPAPersistence.cast((Query)em.createQuery(" SELECT dept FROM  DepartmentTest dept "));
        query.getFetchPlan().addField(DepartmentTest.class, "persons");
        this.verifySize(query.getResultList());
        em.close();
    }

    public void testReadDepartmentsWithLeftJoinFetchAndOrderBy() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query query = em.createQuery(" SELECT dept FROM  DepartmentTest dept  LEFT JOIN FETCH dept.persons ORDER BY dept.primaryKey");
        this.verifySize(query.getResultList());
        em.close();
    }

    public void createTestData() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        DepartmentTest dt1 = new DepartmentTest();
        dt1.setPrimaryKey("001");
        dt1.setName("Dept001");
        em.persist((Object)dt1);
        DepartmentTest dt2 = new DepartmentTest();
        dt2.setPrimaryKey("002");
        dt2.setName("Dept002");
        em.persist((Object)dt2);
        PersonTest pt = new PersonTest();
        pt.setPrimaryKey("1");
        pt.setName("John");
        pt.setDepartmentTest(dt1);
        em.persist((Object)pt);
        em.flush();
        pt = new PersonTest();
        pt.setPrimaryKey("2");
        pt.setName("Mark");
        pt.setDepartmentTest(dt1);
        em.persist((Object)pt);
        em.flush();
        pt = new PersonTest();
        pt.setPrimaryKey("3");
        pt.setName("Stuart");
        pt.setDepartmentTest(dt2);
        em.persist((Object)pt);
        em.flush();
        pt = new PersonTest();
        pt.setPrimaryKey("4");
        pt.setName("Jim");
        pt.setDepartmentTest(dt1);
        em.persist((Object)pt);
        em.flush();
        pt = new PersonTest();
        pt.setPrimaryKey("5");
        pt.setName("Fred");
        pt.setDepartmentTest(dt2);
        em.persist((Object)pt);
        em.flush();
        em.getTransaction().commit();
        em.close();
    }
}

