/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jpql.literals;

import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.PostgresDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.simple.AllFieldTypes;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestLiteralInSQL
extends SQLListenerTestCase {
    @Override
    public void setUp() {
        this.setUp(AllFieldTypes.class, "openjpa.jdbc.QuerySQLCache", "false");
    }

    public void testTrueInSQL() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em = this.emf.createEntityManager();
        DBDictionary dict = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
        if (dict instanceof PostgresDictionary) {
            this.setTestsDisabled(true);
            return;
        }
        this.resetSQL();
        Query q = em.createQuery("SELECT f FROM AllFieldTypes f WHERE f.booleanField=true");
        q.setHint("openjpa.hint.UseLiteralInSQL", (Object)"false");
        q.getResultList();
        this.assertContainsSQL("booleanField = ?");
        this.resetSQL();
        q = em.createQuery("SELECT f FROM AllFieldTypes f WHERE f.booleanField=true");
        q.setHint("openjpa.hint.UseLiteralInSQL", (Object)"true");
        q.getResultList();
        this.assertContainsSQL("booleanField = 1");
    }
}

