/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jpql.version;

import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jpql.version.Author;
import org.apache.openjpa.persistence.jpql.version.Document;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestJoinVersionField
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES, Author.class, Document.class);
        this.createTestData();
    }

    public void testGetDocuments() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String str = "SELECT doc FROM Document doc JOIN doc.author auth";
        TypedQuery query = em.createQuery(str, Document.class);
        List documentList = query.getResultList();
        for (Document doc : documentList) {
            TestJoinVersionField.assertEquals((String)"Author version field should have a value of 1.", (int)1, (int)doc.getAuthor().getVersion());
        }
        em.close();
    }

    public void testGetDocumentsByExplicitAttributeSelection() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String str = "SELECT doc.id, auth.id, auth.version FROM Document doc JOIN doc.author auth";
        Query query = em.createQuery(str);
        List objectList = query.getResultList();
        for (Object[] objects : objectList) {
            TestJoinVersionField.assertEquals((String)"Author version field should have a value of 1.", (Object)1, (Object)objects[2]);
        }
    }

    public void createTestData() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Author author = new Author();
        author.setId(10);
        em.persist((Object)author);
        Document document = new Document();
        document.setId(2);
        document.setAuthor(author);
        em.persist((Object)document);
        em.getTransaction().commit();
        em.close();
    }
}

