/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jpql.version.type;

import java.sql.Timestamp;
import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jpql.version.type.BaseEntity;
import org.apache.openjpa.persistence.jpql.version.type.ChildVersionEntity;
import org.apache.openjpa.persistence.jpql.version.type.LongVersionEntity;
import org.apache.openjpa.persistence.jpql.version.type.PrimativeLongVersionEntity;
import org.apache.openjpa.persistence.jpql.version.type.PrimativeShortVersionEntity;
import org.apache.openjpa.persistence.jpql.version.type.ShortVersionEntity;
import org.apache.openjpa.persistence.jpql.version.type.TimestampVersionEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestVersionFieldType
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES, LongVersionEntity.class, ShortVersionEntity.class, PrimativeLongVersionEntity.class, PrimativeShortVersionEntity.class, TimestampVersionEntity.class, BaseEntity.class, ChildVersionEntity.class);
        this.createTestData();
    }

    public void testProjectionVersionReturnType() {
        this.verifyType(LongVersionEntity.class, Long.class);
        this.verifyType(ShortVersionEntity.class, Short.class);
        this.verifyType(PrimativeShortVersionEntity.class, Short.class);
        this.verifyType(PrimativeLongVersionEntity.class, Long.class);
        this.verifyType(ChildVersionEntity.class, Long.class);
        this.verifyType(TimestampVersionEntity.class, Timestamp.class);
    }

    public void verifyType(Class<?> cls, Class<?> expectedClsType) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String str = "SELECT o.id, o.version FROM " + cls.getName() + " o";
        Query query = em.createQuery(str);
        List objectList = query.getResultList();
        for (Object[] objects : objectList) {
            TestVersionFieldType.assertNotNull((String)"Version should not be null.", (Object)objects[1]);
            TestVersionFieldType.assertTrue((String)("Type should be " + expectedClsType.getName() + ".  But it is " + objects[1].getClass()), (objects[1].getClass() == expectedClsType ? 1 : 0) != 0);
        }
        em.close();
    }

    public void createTestData() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        LongVersionEntity lve = new LongVersionEntity();
        lve.setId(9);
        em.persist((Object)lve);
        ShortVersionEntity sve = new ShortVersionEntity();
        sve.setId(9);
        em.persist((Object)sve);
        PrimativeShortVersionEntity psve = new PrimativeShortVersionEntity();
        psve.setId(9);
        em.persist((Object)psve);
        PrimativeLongVersionEntity plve = new PrimativeLongVersionEntity();
        plve.setId(9);
        em.persist((Object)plve);
        TimestampVersionEntity tve = new TimestampVersionEntity();
        tve.setId(9);
        em.persist((Object)tve);
        ChildVersionEntity ave = new ChildVersionEntity();
        ave.setId(9);
        em.persist((Object)ave);
        em.getTransaction().commit();
        em.close();
    }
}

