/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.lang.reflect.Array;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import javax.persistence.EntityManager;
import junit.framework.AssertionFailedError;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.ArraysTest;

public class TestArrayValues2
extends BaseKernelTest {
    private static double DOUBLE_PRECISION = 0.01;
    public static float FLOAT_PRECISION = 0.01f;

    public void testStringArray() throws Exception {
        int max = (int)(Math.random() * 20.0) + 5;
        String[] array = new String[max];
        for (int i = 0; i < max; ++i) {
            array[i] = TestArrayValues2.randomString();
        }
        this.saveArray(array, false, false);
    }

    public void testLongArray() throws Exception {
        int max = (int)(Math.random() * 20.0) + 5;
        Long[] array = new Long[max];
        for (int i = 0; i < max; ++i) {
            array[i] = TestArrayValues2.randomLong();
        }
        try {
            this.saveArray(array, false, false);
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public void testLongPrimitiveArray() throws Exception {
        int max = (int)(Math.random() * 20.0) + 5;
        long[] array = new long[max];
        for (int i = 0; i < max; ++i) {
            array[i] = TestArrayValues2.randomLong();
        }
        try {
            this.saveArray(array, true, false);
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public void testShortArray() throws Exception {
        int max = (int)(Math.random() * 20.0) + 5;
        Short[] array = new Short[max];
        for (int i = 0; i < max; ++i) {
            array[i] = TestArrayValues2.randomShort();
        }
        this.saveArray(array, false, false);
    }

    public void testShortPrimitiveArray() throws Exception {
        int max = (int)(Math.random() * 20.0) + 5;
        short[] array = new short[max];
        for (int i = 0; i < max; ++i) {
            array[i] = TestArrayValues2.randomShort();
        }
        this.saveArray(array, true, false);
    }

    public void testIntArray() throws Exception {
        int max = (int)(Math.random() * 20.0) + 5;
        Integer[] array = new Integer[max];
        for (int i = 0; i < max; ++i) {
            array[i] = TestArrayValues2.randomInt();
        }
        this.saveArray(array, false, false);
    }

    public void testIntPrimitiveArray() throws Exception {
        int max = (int)(Math.random() * 20.0) + 5;
        int[] array = new int[max];
        for (int i = 0; i < max; ++i) {
            array[i] = TestArrayValues2.randomInt();
        }
        this.saveArray(array, true, false);
    }

    public void testBooleanArray() throws Exception {
        int max = (int)(Math.random() * 20.0) + 5;
        Boolean[] array = new Boolean[max];
        for (int i = 0; i < max; ++i) {
            array[i] = TestArrayValues2.randomBoolean();
        }
        this.saveArray(array, false, false);
    }

    public void testCharacterArray() throws Exception {
        int max = (int)(Math.random() * 20.0) + 5;
        Character[] array = new Character[max];
        array[0] = new Character('\u0001');
        for (int i = 1; i < max; ++i) {
            array[i] = TestArrayValues2.randomChar();
        }
        this.saveArray(array, false, false);
    }

    public void testCharacterPrimitiveArray() throws Exception {
        int max = (int)(Math.random() * 20.0) + 5;
        char[] array = new char[max];
        array[0] = '\u0001';
        for (int i = 1; i < max; ++i) {
            array[i] = TestArrayValues2.randomChar().charValue();
        }
        this.saveArray(array, true, false);
    }

    public void testCharacterPrimitiveClobArray() throws Exception {
        int max = (int)(Math.random() * 20.0) + 5;
        char[] array = new char[max];
        array[0] = '\u0001';
        for (int i = 1; i < max; ++i) {
            array[i] = TestArrayValues2.randomChar().charValue();
        }
        this.saveArray(array, true, true);
    }

    public void testBooleanPrimitiveArray() throws Exception {
        int max = (int)(Math.random() * 20.0) + 5;
        boolean[] array = new boolean[max];
        for (int i = 0; i < max; ++i) {
            array[i] = TestArrayValues2.randomBoolean();
        }
        this.saveArray(array, true, false);
    }

    public void testFloatArray() throws Exception {
        int max = (int)(Math.random() * 20.0) + 5;
        Float[] array = new Float[max];
        for (int i = 0; i < max; ++i) {
            array[i] = TestArrayValues2.randomFloat();
        }
        this.saveArray(array, false, false);
    }

    public void testFloatPrimitiveArray() throws Exception {
        int max = (int)(Math.random() * 20.0) + 5;
        float[] array = new float[max];
        for (int i = 0; i < max; ++i) {
            array[i] = TestArrayValues2.randomFloat().floatValue();
        }
        this.saveArray(array, true, false);
    }

    public void testDoubleArray() throws Exception {
        int max = (int)(Math.random() * 20.0) + 5;
        Double[] array = new Double[max];
        for (int i = 0; i < max; ++i) {
            array[i] = TestArrayValues2.randomDouble();
        }
        this.saveArray(array, false, false);
    }

    public void testDoublePrimitiveArray() throws Exception {
        int max = (int)(Math.random() * 20.0) + 5;
        double[] array = new double[max];
        for (int i = 0; i < max; ++i) {
            array[i] = TestArrayValues2.randomDouble();
        }
        this.saveArray(array, true, false);
    }

    public void testDateArray() throws Exception {
        int max = (int)(Math.random() * 20.0) + 5;
        Date[] array = new Date[max];
        for (int i = 0; i < max; ++i) {
            array[i] = TestArrayValues2.randomDate();
        }
        this.saveArray(array, false, false);
    }

    private void saveArray(Object array, boolean primitive, boolean lob) throws Exception {
        try {
            this.saveArrayInternal(array, primitive, lob);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error error) {
            throw error;
        }
    }

    private void saveArrayInternal(Object vals, boolean primitive, boolean lob) throws Exception {
        Object[] array = primitive ? this.convertPrimitiveArray(vals) : (Object[])vals;
        Arrays.sort(array, new TestArraySorter());
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        ArraysTest test = new ArraysTest();
        pm.persist((Object)test);
        int testID = test.getId();
        this.setGetTestArray(test, vals, primitive, lob, true);
        this.endTx((EntityManager)pm);
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        ArraysTest retrievedObject = (ArraysTest)pm.find(ArraysTest.class, (Object)testID);
        Object retrievedVals = this.setGetTestArray(retrievedObject, vals, primitive, lob, false);
        Object[] retrievedArray = primitive ? this.convertPrimitiveArray(retrievedVals) : (Object[])retrievedVals;
        TestArrayValues2.assertNotNull((Object)retrievedArray);
        TestArrayValues2.assertTrue((array.length != 0 ? 1 : 0) != 0);
        TestArrayValues2.assertEquals((int)array.length, (int)retrievedArray.length);
        TestArrayValues2.assertNotNull((Object)array[0]);
        TestArrayValues2.assertNotNull((Object)retrievedArray[0]);
        TestArrayValues2.assertEquals(array[0].getClass(), retrievedArray[0].getClass());
        Arrays.sort(retrievedArray, new TestArraySorter());
        for (int i = 0; i < array.length; ++i) {
            this.assertClassAndValueEquals(array[i], retrievedArray[i]);
        }
        pm.remove((Object)retrievedObject);
        this.endTx((EntityManager)pm);
    }

    private Object[] convertPrimitiveArray(Object array) throws Exception {
        int length = Array.getLength(array);
        Class<?> type = Array.get(array, 0).getClass();
        Object[] copy = (Object[])Array.newInstance(type, length);
        for (int i = 0; i < length; ++i) {
            copy[i] = Array.get(array, i);
        }
        return copy;
    }

    private void assertClassAndValueEquals(Object o1, Object o2) {
        TestArrayValues2.assertTrue((String)"First object was null", (o1 != null ? 1 : 0) != 0);
        TestArrayValues2.assertTrue((String)"Second object was null", (o2 != null ? 1 : 0) != 0);
        TestArrayValues2.assertTrue((String)("Types did not match (class1=" + o1.getClass().getName() + ", class2=" + o2.getClass().getName() + ")"), (boolean)o1.getClass().isAssignableFrom(o2.getClass()));
        if (o1 instanceof Double) {
            TestArrayValues2.assertEquals((double)((Double)o1), (double)((Double)o2), (double)DOUBLE_PRECISION);
        } else if (o1 instanceof Float) {
            TestArrayValues2.assertEquals((float)((Float)o1).floatValue(), (float)((Float)o2).floatValue(), (float)FLOAT_PRECISION);
        } else {
            TestArrayValues2.assertEquals((String)("Object did not match (class1=" + o1.getClass().getName() + ", class2=" + o2.getClass().getName() + ")"), (Object)o1, (Object)o2);
        }
    }

    private Object setGetTestArray(ArraysTest test, Object array, boolean primitive, boolean lob, boolean doSet) throws Exception {
        if (array == null) {
            return null;
        }
        Object first = Array.get(array, 0);
        if (first instanceof Date) {
            if (doSet) {
                test.setDate((Date[])array);
            }
            return test.getDate();
        }
        if (first instanceof String) {
            if (doSet) {
                test.setString((String[])array);
            }
            return test.getString();
        }
        if (first instanceof Character) {
            if (doSet && !primitive) {
                test.setCharacter((Character[])array);
            } else if (doSet && !lob) {
                test.setCharacterP((char[])array);
            } else if (doSet) {
                test.setCharacterPClob((char[])array);
            } else {
                if (!primitive) {
                    return test.getCharacter();
                }
                if (!lob) {
                    return test.getCharacterP();
                }
                return test.getCharacterPClob();
            }
            return null;
        }
        if (first instanceof Double) {
            if (doSet && !primitive) {
                test.setDouble((Double[])array);
            } else if (doSet) {
                test.setDoubleP((double[])array);
            } else {
                if (!primitive) {
                    return test.getDouble();
                }
                return test.getDoubleP();
            }
            return null;
        }
        if (first instanceof Byte) {
            if (doSet && !primitive) {
                test.setByte((Byte[])array);
            } else if (doSet) {
                test.setByteP((byte[])array);
            } else {
                if (!primitive) {
                    return test.getByte();
                }
                return test.getByteP();
            }
            return null;
        }
        if (first instanceof Float) {
            if (doSet && !primitive) {
                test.setFloat((Float[])array);
            } else if (doSet) {
                test.setFloatP((float[])array);
            } else {
                if (!primitive) {
                    return test.getFloat();
                }
                return test.getFloatP();
            }
            return null;
        }
        if (first instanceof Long) {
            if (doSet && !primitive) {
                test.setLong((Long[])array);
            } else if (doSet) {
                test.setLongP((long[])array);
            } else {
                if (!primitive) {
                    return test.getLong();
                }
                return test.getLongP();
            }
            return null;
        }
        if (first instanceof Integer) {
            if (doSet && !primitive) {
                test.setInt((Integer[])array);
            } else if (doSet) {
                test.setIntP((int[])array);
            } else {
                if (!primitive) {
                    return test.getInt();
                }
                return test.getIntP();
            }
            return null;
        }
        if (first instanceof Short) {
            if (doSet && !primitive) {
                test.setShort((Short[])array);
            } else if (doSet) {
                test.setShortP((short[])array);
            } else {
                if (!primitive) {
                    return test.getShort();
                }
                return test.getShortP();
            }
            return null;
        }
        if (first instanceof Boolean) {
            if (doSet && !primitive) {
                test.setBoolean((Boolean[])array);
            } else if (doSet) {
                test.setBooleanP((boolean[])array);
            } else {
                if (!primitive) {
                    return test.getBoolean();
                }
                return test.getBooleanP();
            }
            return null;
        }
        if (first instanceof ArraysTest) {
            if (doSet) {
                test.setArraysTest((ArraysTest[])array);
            }
            return test.getArraysTest();
        }
        TestArrayValues2.fail((String)"Unknown array type");
        return null;
    }

    private static class TestArraySorter
    implements Comparator {
        private Collator collator = Collator.getInstance();

        private TestArraySorter() {
        }

        public int compare(Object o1, Object o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            if (o1 instanceof Number) {
                return ((Number)o1).doubleValue() > ((Number)o2).doubleValue() ? 1 : -1;
            }
            if (o1 instanceof Date) {
                return ((Date)o1).before((Date)o2) ? 1 : -1;
            }
            if (o1 instanceof ArraysTest) {
                return ((ArraysTest)o1).compareTo(o2);
            }
            return this.collator.compare(o1.toString(), o2.toString());
        }
    }
}

