/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.math.BigDecimal;
import javax.persistence.EntityManager;
import junit.framework.AssertionFailedError;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.AllFieldTypesTest;

public class TestBigDecimals
extends BaseKernelTest {
    public TestBigDecimals() {
    }

    public TestBigDecimals(String name) {
        super(name);
    }

    public void testBigDecimalDataIntegrity() throws Exception {
        try {
            BigDecimal bd = new BigDecimal(Math.random() * 1.0E7 + "");
            bd = bd.setScale(100);
            for (int i = 0; i < 50; ++i) {
                bd = bd.movePointLeft(1);
                this.bigDecimalTest(bd);
            }
        }
        catch (AssertionFailedError e) {
            this.bug(3, e, "Precision loss for BigDecimals");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bigDecimalTest(BigDecimal bd) {
        OpenJPAEntityManager pm2;
        block8: {
            OpenJPAEntityManager pm = null;
            pm2 = null;
            try {
                pm = this.getPM();
                this.startTx((EntityManager)pm);
                AllFieldTypesTest aftt = new AllFieldTypesTest();
                aftt.setTestBigDecimal(bd);
                pm.persist((Object)aftt);
                this.endTx((EntityManager)pm);
                Object id = pm.getObjectId((Object)aftt);
                pm.evict((Object)aftt);
                pm2 = this.getPM();
                this.startTx((EntityManager)pm);
                AllFieldTypesTest aftt2 = (AllFieldTypesTest)pm2.getObjectId(id);
                TestBigDecimals.assertTrue((String)"identitcal field values", (bd != aftt2.getTestBigDecimal() ? 1 : 0) != 0);
                TestBigDecimals.assertEquals((Object)bd, (Object)aftt2.getTestBigDecimal().setScale(bd.scale()));
                TestBigDecimals.assertEquals((Object)bd, (Object)aftt2.getTestBigDecimal());
                this.rollbackTx((EntityManager)pm);
                if (pm == null) break block8;
            }
            catch (Throwable afe) {
                try {
                    this.bug(3, afe, "floating point precision loss");
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (pm != null) {
                        this.endEm((EntityManager)pm);
                    }
                    if (pm2 != null) {
                        this.endEm((EntityManager)pm2);
                    }
                }
            }
            this.endEm((EntityManager)pm);
        }
        if (pm2 != null) {
            this.endEm((EntityManager)pm2);
        }
    }
}

