/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;

public class TestCheckConsistency
extends BaseKernelTest {
    private Object _oid = null;

    public TestCheckConsistency(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp(RuntimeTest1.class);
        RuntimeTest1 pc = new RuntimeTest1();
        pc.setIntField(1);
        pc.setIntField1(1);
        this._oid = this.persist(pc);
    }

    public void testConsistentDatastoreTransaction() {
        OpenJPAEntityManager pm = this.getPM();
        pm.setOptimistic(false);
        pm.validateChanges();
        this.startTx((EntityManager)pm);
        RuntimeTest1 pc = (RuntimeTest1)pm.find(RuntimeTest1.class, this._oid);
        pc.setIntField1(100);
        RuntimeTest1 npc = new RuntimeTest1();
        npc.setIntField(2);
        npc.setIntField1(2);
        pm.persist((Object)npc);
        pm.validateChanges();
        TestCheckConsistency.assertEquals((int)100, (int)pc.getIntField1());
        TestCheckConsistency.assertTrue((boolean)pm.isPersistent((Object)npc));
        pc.setIntField1(200);
        npc.setIntField1(300);
        this.endTx((EntityManager)pm);
        TestCheckConsistency.assertEquals((int)200, (int)pc.getIntField1());
        TestCheckConsistency.assertTrue((boolean)pm.isPersistent((Object)npc));
        TestCheckConsistency.assertEquals((int)300, (int)npc.getIntField1());
        this.endEm((EntityManager)pm);
    }

    public void testConsistentDatastoreTransactionWithRollback() {
        OpenJPAEntityManager pm = this.getPM();
        pm.setOptimistic(false);
        pm.validateChanges();
        this.startTx((EntityManager)pm);
        RuntimeTest1 pc = (RuntimeTest1)pm.find(RuntimeTest1.class, this._oid);
        pc.setIntField1(100);
        RuntimeTest1 npc = new RuntimeTest1();
        pm.persist((Object)npc);
        Object noid = pm.getObjectId((Object)npc);
        pm.validateChanges();
        TestCheckConsistency.assertEquals((int)100, (int)pc.getIntField1());
        TestCheckConsistency.assertTrue((boolean)pm.isPersistent((Object)npc));
        pc.setIntField1(200);
        npc.setIntField1(300);
        this.rollbackTx((EntityManager)pm);
        TestCheckConsistency.assertEquals((int)1, (int)pc.getIntField1());
        TestCheckConsistency.assertFalse((boolean)pm.isPersistent((Object)npc));
        TestCheckConsistency.assertEquals((int)0, (int)npc.getIntField1());
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        try {
            RuntimeTest1 temp = (RuntimeTest1)pm.find(RuntimeTest1.class, noid);
            TestCheckConsistency.fail((String)("Object should not exist." + temp.getIntField() + "::" + temp.getIntField1()));
        }
        catch (Exception jonfe) {
            // empty catch block
        }
        this.endEm((EntityManager)pm);
    }

    public void testConsistentOptimisticTransaction() {
        OpenJPAEntityManager pm = this.getPM();
        pm.setOptimistic(true);
        pm.validateChanges();
        this.startTx((EntityManager)pm);
        boolean hasConn = this.hasConnection(pm);
        RuntimeTest1 pc = (RuntimeTest1)pm.find(RuntimeTest1.class, this._oid);
        pc.setIntField1(100);
        RuntimeTest1 npc = new RuntimeTest1();
        npc.setIntField(2);
        npc.setIntField1(2);
        pm.persist((Object)npc);
        pm.validateChanges();
        if (!hasConn) {
            TestCheckConsistency.assertFalse((boolean)this.hasConnection(pm));
        }
        TestCheckConsistency.assertEquals((int)100, (int)pc.getIntField1());
        TestCheckConsistency.assertTrue((boolean)pm.isPersistent((Object)npc));
        pc.setIntField1(200);
        npc.setIntField1(300);
        this.endTx((EntityManager)pm);
        TestCheckConsistency.assertEquals((int)200, (int)pc.getIntField1());
        TestCheckConsistency.assertTrue((boolean)pm.isPersistent((Object)npc));
        TestCheckConsistency.assertEquals((int)300, (int)npc.getIntField1());
        this.endEm((EntityManager)pm);
    }

    private boolean hasConnection(OpenJPAEntityManager pm) {
        return JPAFacadeHelper.toBroker((EntityManager)pm).hasConnection();
    }

    public void testConsistentOptimisticTransactionWithRollback() {
        OpenJPAEntityManager pm = this.getPM();
        pm.setOptimistic(true);
        pm.validateChanges();
        this.startTx((EntityManager)pm);
        boolean hasConn = this.hasConnection(pm);
        RuntimeTest1 pc = (RuntimeTest1)pm.find(RuntimeTest1.class, this._oid);
        pc.setIntField1(100);
        RuntimeTest1 npc = new RuntimeTest1();
        pm.persist((Object)npc);
        Object noid = pm.getObjectId((Object)npc);
        pm.validateChanges();
        if (!hasConn) {
            TestCheckConsistency.assertFalse((boolean)this.hasConnection(pm));
        }
        TestCheckConsistency.assertEquals((int)100, (int)pc.getIntField1());
        TestCheckConsistency.assertTrue((boolean)pm.isPersistent((Object)npc));
        pc.setIntField1(200);
        npc.setIntField1(300);
        this.rollbackTx((EntityManager)pm);
        TestCheckConsistency.assertEquals((int)1, (int)pc.getIntField1());
        TestCheckConsistency.assertFalse((boolean)pm.isPersistent((Object)npc));
        TestCheckConsistency.assertEquals((int)0, (int)npc.getIntField1());
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        try {
            RuntimeTest1 temp = (RuntimeTest1)pm.find(RuntimeTest1.class, noid);
            TestCheckConsistency.fail((String)("Object should not exist." + temp.getIntField() + "::" + temp.getIntField1()));
        }
        catch (Exception jonfe) {
            // empty catch block
        }
    }
}

