/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.HashMap;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;

public class TestConnectionRetainMode
extends BaseKernelTest {
    public TestConnectionRetainMode() {
    }

    public TestConnectionRetainMode(String str) {
        super(str);
    }

    public void testOnDemand() throws Exception {
        this.doTest("on-demand");
    }

    public void testTransaction() throws Exception {
        this.doTest("transaction");
    }

    public void testPersistenceManager() throws Exception {
        this.doTest("persistence-manager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTest(String mode) throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.ConnectionRetainMode", mode);
        OpenJPAEntityManagerFactory factory = this.getEmf(props);
        OpenJPAEntityManager pm = factory.createEntityManager();
        Object initialConnection = pm.getConnection();
        try {
            this.checkPM(pm, initialConnection, mode);
            pm.setOptimistic(true);
            this.startTx((EntityManager)pm);
            Object optimisticConnection = pm.getConnection();
            this.checkPM(pm, initialConnection, mode);
            this.checkTransaction(pm, optimisticConnection, mode);
            this.rollbackTx((EntityManager)pm);
            this.checkPM(pm, initialConnection, mode);
            pm.setOptimistic(false);
            this.startTx((EntityManager)pm);
            Object pessimisticConnection = pm.getConnection();
            this.checkPM(pm, initialConnection, mode);
            this.checkTransaction(pm, pessimisticConnection, mode);
            this.rollbackTx((EntityManager)pm);
            this.checkPM(pm, initialConnection, mode);
        }
        finally {
            this.rollbackTx((EntityManager)pm);
            this.endEm((EntityManager)pm);
        }
    }

    private void checkPM(OpenJPAEntityManager pm, Object c, String mode) throws Exception {
        if ("persistence-manager".equals(mode)) {
            TestConnectionRetainMode.assertEquals((Object)c, (Object)pm.getConnection());
        }
    }

    private void checkTransaction(OpenJPAEntityManager pm, Object c, String mode) throws Exception {
        if (!"on-demand".equals(mode) || !pm.getOptimistic()) {
            TestConnectionRetainMode.assertEquals((Object)c, (Object)pm.getConnection());
        }
    }
}

