/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.Collection;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.kernel.common.apps.FetchA;
import org.apache.openjpa.persistence.kernel.common.apps.FetchB;
import org.apache.openjpa.persistence.kernel.common.apps.FetchBase;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDynamicFetchPlan
extends SingleEMFTestCase {
    private static final String JPQL = "select a from FetchA a";

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, FetchBase.class, FetchA.class, FetchB.class);
        this.createData();
    }

    public void createData() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        FetchA a1 = new FetchA();
        a1.setText("a1");
        FetchB b1 = new FetchB();
        b1.setText("b1");
        a1.setB(b1);
        em.persist((Object)a1);
        em.persist((Object)b1);
        em.getTransaction().commit();
    }

    public void testFetchBySubClassFieldB() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        fp.setExtendedPathLookup(true);
        fp.clearFetchGroups().removeFetchGroup("default");
        fp.clearFields();
        fp.addField(FetchA.class, "b");
        fp.addField(FetchB.class, "text");
        FetchA a = (FetchA)em.createQuery(JPQL).getSingleResult();
        em.close();
        FetchB b = a.getB();
        TestDynamicFetchPlan.assertNotNull((Object)b);
        TestDynamicFetchPlan.assertNull((Object)a.getText());
        TestDynamicFetchPlan.assertEquals((String)"b1", (String)b.getText());
    }

    public void testFetchBySubClassFieldA() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        fp.setExtendedPathLookup(true);
        fp.clearFetchGroups().removeFetchGroup("default");
        fp.clearFields();
        fp.addField(FetchA.class, "b");
        fp.addField(FetchA.class, "text");
        FetchA a = (FetchA)em.createQuery(JPQL).getSingleResult();
        em.close();
        FetchB b = a.getB();
        TestDynamicFetchPlan.assertNotNull((Object)b);
        TestDynamicFetchPlan.assertEquals((String)"a1", (String)a.getText());
        TestDynamicFetchPlan.assertNull((Object)b.getText());
    }

    public void testFetchBySuperClassField() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        fp.setExtendedPathLookup(true);
        fp.clearFetchGroups().removeFetchGroup("default");
        fp.clearFields();
        fp.addField(FetchA.class, "b");
        fp.addField(FetchBase.class, "text");
        FetchA a = (FetchA)em.createQuery(JPQL).getSingleResult();
        em.close();
        FetchB b = a.getB();
        TestDynamicFetchPlan.assertNotNull((Object)b);
        TestDynamicFetchPlan.assertEquals((String)"a1", (String)a.getText());
        TestDynamicFetchPlan.assertEquals((String)"b1", (String)b.getText());
    }

    public void testFetchBySubClassFieldNameB() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        fp.setExtendedPathLookup(true);
        fp.clearFetchGroups().removeFetchGroup("default");
        fp.clearFields();
        fp.addField(FetchA.class.getName() + ".b");
        fp.addField(FetchB.class.getName() + ".text");
        FetchA a = (FetchA)em.createQuery(JPQL).getSingleResult();
        em.close();
        FetchB b = a.getB();
        TestDynamicFetchPlan.assertNotNull((Object)b);
        TestDynamicFetchPlan.assertNull((Object)a.getText());
        TestDynamicFetchPlan.assertEquals((String)"b1", (String)b.getText());
    }

    public void testFetchBySubClassFieldNameA() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        fp.setExtendedPathLookup(true);
        fp.clearFetchGroups().removeFetchGroup("default");
        fp.clearFields();
        fp.addField(FetchA.class.getName() + ".b");
        fp.addField(FetchA.class.getName() + ".text");
        FetchA a = (FetchA)em.createQuery(JPQL).getSingleResult();
        em.close();
        FetchB b = a.getB();
        TestDynamicFetchPlan.assertNotNull((Object)b);
        TestDynamicFetchPlan.assertEquals((String)"a1", (String)a.getText());
        TestDynamicFetchPlan.assertNull((Object)b.getText());
    }

    public void testFetchBySuperClassFieldName() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        fp.setExtendedPathLookup(true);
        fp.clearFetchGroups().removeFetchGroup("default");
        fp.clearFields();
        fp.addField(FetchA.class.getName() + ".b");
        fp.addField(FetchBase.class.getName() + ".text");
        FetchA a = (FetchA)em.createQuery(JPQL).getSingleResult();
        em.close();
        FetchB b = a.getB();
        TestDynamicFetchPlan.assertNotNull((Object)b);
        TestDynamicFetchPlan.assertEquals((String)"a1", (String)a.getText());
        TestDynamicFetchPlan.assertEquals((String)"b1", (String)b.getText());
    }

    public void testClearFetchPlan() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        Collection fetchGroups = fp.getFetchGroups();
        TestDynamicFetchPlan.assertNotNull((Object)fetchGroups);
        TestDynamicFetchPlan.assertTrue((boolean)fetchGroups.contains("default"));
        fp.clearFetchGroups();
        Collection fetchGroupsAfterClear = fp.getFetchGroups();
        TestDynamicFetchPlan.assertNotNull((Object)fetchGroupsAfterClear);
        TestDynamicFetchPlan.assertTrue((boolean)fetchGroupsAfterClear.contains("default"));
        fp.removeFetchGroup("default");
        Collection fetchGroupsAfterRemove = fp.getFetchGroups();
        TestDynamicFetchPlan.assertNotNull((Object)fetchGroupsAfterClear);
        TestDynamicFetchPlan.assertTrue((boolean)fetchGroupsAfterClear.isEmpty());
    }
}

