/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.kernel.common.apps.InstanceCallbacksTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;

public class TestEJBIncrementalFlushes
extends AbstractTestCase {
    public TestEJBIncrementalFlushes(String name) {
        super(name, "kernelcactusapp");
    }

    public void setUp() {
        this.deleteAll(RuntimeTest1.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testFlushNoChange() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        InstanceCallbacksTest a = new InstanceCallbacksTest("foo", 10);
        em.persist((Object)a);
        em.flush();
        this.endTx((EntityManager)em);
        TestEJBIncrementalFlushes.assertEquals((int)10, (int)a.getIntField());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptimisticLockGivesCorrectError() {
        OpenJPAEntityManager pm1 = this.currentEntityManager();
        OpenJPAEntityManager pm2 = this.currentEntityManager();
        RuntimeTest1 a1 = new RuntimeTest1("foo", 10);
        this.startTx((EntityManager)pm1);
        pm1.persist((Object)a1);
        this.endTx((EntityManager)pm1);
        RuntimeTest1 a2 = (RuntimeTest1)pm2.find(RuntimeTest1.class, (Object)10);
        this.startTx((EntityManager)pm2);
        a2.setStringField("foobar");
        this.startTx((EntityManager)pm2);
        this.startTx((EntityManager)pm1);
        a1.setStringField("foobarbaz");
        try {
            this.endTx((EntityManager)pm1);
        }
        catch (Exception ole) {
        }
        finally {
            if (pm1.getTransaction().isActive()) {
                pm1.getTransaction().rollback();
            }
            this.endEm((EntityManager)pm1);
            this.endEm((EntityManager)pm2);
        }
    }
}

