/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;

public class TestEJBLobs
extends AbstractTestCase {
    private EntityManager _pm = null;
    private Inner _inner = null;

    public TestEJBLobs(String name) {
        super(name, "kernelcactusapp");
    }

    public void setUp() throws Exception {
        super.setUp(Inner.class, Inner2.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        Inner inner = new Inner();
        inner.setString("string");
        inner.setClob("clobField");
        inner.setEBlob("eblob");
        Inner2 inner2 = new Inner2();
        Inner2.pcSetstring(inner2, "inner2");
        inner.setBlob(inner2);
        this._pm = this.currentEntityManager();
        this.startTx(this._pm);
        this._pm.persist((Object)inner);
        try {
            this.endTx(this._pm);
        }
        catch (Exception jdoe) {
            System.out.println("An exception was thrown while persisting the entity : \n" + this.getStackTrace(jdoe));
        }
        this.endEm(this._pm);
        this._pm = this.currentEntityManager();
        this._inner = (Inner)this._pm.find(Inner.class, (Object)"string");
    }

    public void testOtherFields() {
        TestEJBLobs.assertEquals((String)"string", (String)this._inner.getString());
    }

    public void testClob() {
        TestEJBLobs.assertEquals((String)"clobField", (String)this._inner.getClob());
    }

    public void testBlob() {
        TestEJBLobs.assertNotNull((Object)this._inner.getBlob());
        TestEJBLobs.assertEquals((String)"inner2", (String)Inner2.pcGetstring(this._inner.getBlob()));
    }

    public void testSetNull() {
        this.startTx(this._pm);
        this._inner.setClob(null);
        this._inner.setBlob(null);
        this.endTx(this._pm);
        TestEJBLobs.assertEquals(null, (Object)this._inner.getBlob());
        TestEJBLobs.assertEquals(null, (String)this._inner.getClob());
    }

    public void testDelete() {
        this.deleteAll(Inner.class);
    }

    public void testUpdate() {
        this.startTx(this._pm);
        this._inner.setClob("newvalue");
        Inner2 inner2 = new Inner2();
        Inner2.pcSetstring(inner2, "newinner2");
        this._inner.setBlob(inner2);
        this.endTx(this._pm);
        TestEJBLobs.assertEquals((String)"newvalue", (String)this._inner.getClob());
        TestEJBLobs.assertEquals((String)"newinner2", (String)Inner2.pcGetstring(this._inner.getBlob()));
    }

    @Entity
    @Table(name="Inner2")
    public static class Inner2
    implements Serializable,
    PersistenceCapable {
        @Id
        public String string = null;
        private static int pcInheritedFieldCount;
        private static String[] pcFieldNames;
        private static Class[] pcFieldTypes;
        private static byte[] pcFieldFlags;
        private static Class pcPCSuperclass;
        protected transient StateManager pcStateManager;
        static /* synthetic */ Class class$Ljava$lang$String;
        static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner2;
        private transient Object pcDetachedState;
        private static final long serialVersionUID;

        public String getString() {
            return Inner2.pcGetstring(this);
        }

        public void setString(String string) {
            Inner2.pcSetstring(this, string);
        }

        public int pcGetEnhancementContractVersion() {
            return 1674154;
        }

        static {
            serialVersionUID = -5462777242733923827L;
            pcFieldNames = new String[]{"string"};
            Class[] classArray = new Class[1];
            Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Inner2.class$("java.lang.String"));
            classArray[0] = clazz;
            pcFieldTypes = classArray;
            pcFieldFlags = new byte[]{26};
            Class clazz2 = class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner2 != null ? class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner2 : (class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner2 = Inner2.class$("org.apache.openjpa.persistence.kernel.TestEJBLobs$Inner2"));
            PCRegistry.register((Class)clazz2, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"TestEJBLobs$Inner2", (PersistenceCapable)new Inner2());
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        protected void pcClearFields() {
            this.string = null;
        }

        public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
            Inner2 inner2 = new Inner2();
            if (bl) {
                inner2.pcClearFields();
            }
            inner2.pcStateManager = stateManager;
            inner2.pcCopyKeyFieldsFromObjectId(object);
            return inner2;
        }

        public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
            Inner2 inner2 = new Inner2();
            if (bl) {
                inner2.pcClearFields();
            }
            inner2.pcStateManager = stateManager;
            return inner2;
        }

        protected static int pcGetManagedFieldCount() {
            return 1;
        }

        public void pcReplaceField(int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.string = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcReplaceFields(int[] nArray) {
            int n = 0;
            while (n < nArray.length) {
                this.pcReplaceField(nArray[n]);
                ++n;
            }
        }

        public void pcProvideField(int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.string);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcProvideFields(int[] nArray) {
            int n = 0;
            while (n < nArray.length) {
                this.pcProvideField(nArray[n]);
                ++n;
            }
        }

        protected void pcCopyField(Inner2 inner2, int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.string = inner2.string;
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcCopyFields(Object object, int[] nArray) {
            Inner2 inner2 = (Inner2)object;
            if (inner2.pcStateManager != this.pcStateManager) {
                throw new IllegalArgumentException();
            }
            if (this.pcStateManager == null) {
                throw new IllegalStateException();
            }
            int n = 0;
            while (n < nArray.length) {
                this.pcCopyField(inner2, nArray[n]);
                ++n;
            }
        }

        public Object pcGetGenericContext() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.getGenericContext();
        }

        public Object pcFetchObjectId() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.fetchObjectId();
        }

        public boolean pcIsDeleted() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isDeleted();
        }

        public boolean pcIsDirty() {
            if (this.pcStateManager == null) {
                return false;
            }
            StateManager stateManager = this.pcStateManager;
            RedefinitionHelper.dirtyCheck((StateManager)stateManager);
            return stateManager.isDirty();
        }

        public boolean pcIsNew() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isNew();
        }

        public boolean pcIsPersistent() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isPersistent();
        }

        public boolean pcIsTransactional() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isTransactional();
        }

        public boolean pcSerializing() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.serializing();
        }

        public void pcDirty(String string) {
            if (this.pcStateManager == null) {
                return;
            }
            this.pcStateManager.dirty(string);
        }

        public StateManager pcGetStateManager() {
            return this.pcStateManager;
        }

        public Object pcGetVersion() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.getVersion();
        }

        public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
            if (this.pcStateManager != null) {
                this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
                return;
            }
            this.pcStateManager = stateManager;
        }

        public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
            throw new InternalException();
        }

        public void pcCopyKeyFieldsToObjectId(Object object) {
            throw new InternalException();
        }

        public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
            StringId stringId = (StringId)object;
            fieldConsumer.storeStringField(0 + pcInheritedFieldCount, stringId.getId());
        }

        public void pcCopyKeyFieldsFromObjectId(Object object) {
            StringId stringId = (StringId)object;
            this.string = stringId.getId();
        }

        public Object pcNewObjectIdInstance(Object object) {
            Class clazz = class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner2 != null ? class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner2 : (class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner2 = Inner2.class$("org.apache.openjpa.persistence.kernel.TestEJBLobs$Inner2"));
            return new StringId(clazz, (String)object);
        }

        public Object pcNewObjectIdInstance() {
            Class clazz = class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner2 != null ? class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner2 : (class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner2 = Inner2.class$("org.apache.openjpa.persistence.kernel.TestEJBLobs$Inner2"));
            return new StringId(clazz, this.string);
        }

        public static final String pcGetstring(Inner2 inner2) {
            if (inner2.pcStateManager == null) {
                return inner2.string;
            }
            int n = pcInheritedFieldCount + 0;
            inner2.pcStateManager.accessingField(n);
            return inner2.string;
        }

        public static final void pcSetstring(Inner2 inner2, String string) {
            if (inner2.pcStateManager == null) {
                inner2.string = string;
                return;
            }
            inner2.pcStateManager.settingStringField((PersistenceCapable)inner2, pcInheritedFieldCount + 0, inner2.string, string, 0);
        }

        public Boolean pcIsDetached() {
            if (this.pcStateManager != null) {
                if (this.pcStateManager.isDetached()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
                return Boolean.TRUE;
            }
            if (!this.pcisDetachedStateDefinitive()) {
                return null;
            }
            if (this.pcGetDetachedState() == null) {
                return Boolean.FALSE;
            }
            return null;
        }

        private boolean pcisDetachedStateDefinitive() {
            return false;
        }

        public Object pcGetDetachedState() {
            return this.pcDetachedState;
        }

        public void pcSetDetachedState(Object object) {
            this.pcDetachedState = object;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            boolean bl = this.pcSerializing();
            objectOutputStream.defaultWriteObject();
            if (bl) {
                this.pcSetDetachedState(null);
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
            objectInputStream.defaultReadObject();
        }
    }

    @Entity
    @Table(name="inntable")
    public static class Inner
    implements PersistenceCapable {
        @Id
        private String string = null;
        private String clobField = null;
        private Object eblob = null;
        @OneToOne(cascade={CascadeType.PERSIST, CascadeType.REMOVE})
        private Inner2 blobField = null;
        private static int pcInheritedFieldCount;
        private static String[] pcFieldNames;
        private static Class[] pcFieldTypes;
        private static byte[] pcFieldFlags;
        private static Class pcPCSuperclass;
        protected transient StateManager pcStateManager;
        static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner2;
        static /* synthetic */ Class class$Ljava$lang$String;
        static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner;
        private transient Object pcDetachedState;

        public String getString() {
            return Inner.pcGetstring(this);
        }

        public void setString(String val) {
            Inner.pcSetstring(this, val);
        }

        public String getClob() {
            return Inner.pcGetclobField(this);
        }

        public void setClob(String val) {
            Inner.pcSetclobField(this, val);
        }

        public String getEBlob() {
            return (String)this.eblob;
        }

        public void setEBlob(String val) {
            this.eblob = val;
        }

        public Inner2 getBlob() {
            return Inner.pcGetblobField(this);
        }

        public void setBlob(Inner2 val) {
            Inner.pcSetblobField(this, val);
        }

        public int pcGetEnhancementContractVersion() {
            return 1674154;
        }

        static {
            pcFieldNames = new String[]{"blobField", "clobField", "string"};
            Class[] classArray = new Class[3];
            Class clazz = class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner2 != null ? class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner2 : (class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner2 = Inner.class$("org.apache.openjpa.persistence.kernel.TestEJBLobs$Inner2"));
            classArray[0] = clazz;
            Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Inner.class$("java.lang.String"));
            classArray[1] = clazz2;
            classArray[2] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Inner.class$("java.lang.String"));
            pcFieldTypes = classArray;
            pcFieldFlags = new byte[]{26, 26, 26};
            Class clazz3 = class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner != null ? class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner : (class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner = Inner.class$("org.apache.openjpa.persistence.kernel.TestEJBLobs$Inner"));
            PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"TestEJBLobs$Inner", (PersistenceCapable)new Inner());
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        protected void pcClearFields() {
            this.blobField = null;
            this.clobField = null;
            this.string = null;
        }

        public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
            Inner inner = new Inner();
            if (bl) {
                inner.pcClearFields();
            }
            inner.pcStateManager = stateManager;
            inner.pcCopyKeyFieldsFromObjectId(object);
            return inner;
        }

        public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
            Inner inner = new Inner();
            if (bl) {
                inner.pcClearFields();
            }
            inner.pcStateManager = stateManager;
            return inner;
        }

        protected static int pcGetManagedFieldCount() {
            return 3;
        }

        public void pcReplaceField(int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.blobField = (Inner2)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                    return;
                }
                case 1: {
                    this.clobField = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                    return;
                }
                case 2: {
                    this.string = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcReplaceFields(int[] nArray) {
            int n = 0;
            while (n < nArray.length) {
                this.pcReplaceField(nArray[n]);
                ++n;
            }
        }

        public void pcProvideField(int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.blobField);
                    return;
                }
                case 1: {
                    this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.clobField);
                    return;
                }
                case 2: {
                    this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.string);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcProvideFields(int[] nArray) {
            int n = 0;
            while (n < nArray.length) {
                this.pcProvideField(nArray[n]);
                ++n;
            }
        }

        protected void pcCopyField(Inner inner, int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.blobField = inner.blobField;
                    return;
                }
                case 1: {
                    this.clobField = inner.clobField;
                    return;
                }
                case 2: {
                    this.string = inner.string;
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcCopyFields(Object object, int[] nArray) {
            Inner inner = (Inner)object;
            if (inner.pcStateManager != this.pcStateManager) {
                throw new IllegalArgumentException();
            }
            if (this.pcStateManager == null) {
                throw new IllegalStateException();
            }
            int n = 0;
            while (n < nArray.length) {
                this.pcCopyField(inner, nArray[n]);
                ++n;
            }
        }

        public Object pcGetGenericContext() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.getGenericContext();
        }

        public Object pcFetchObjectId() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.fetchObjectId();
        }

        public boolean pcIsDeleted() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isDeleted();
        }

        public boolean pcIsDirty() {
            if (this.pcStateManager == null) {
                return false;
            }
            StateManager stateManager = this.pcStateManager;
            RedefinitionHelper.dirtyCheck((StateManager)stateManager);
            return stateManager.isDirty();
        }

        public boolean pcIsNew() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isNew();
        }

        public boolean pcIsPersistent() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isPersistent();
        }

        public boolean pcIsTransactional() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isTransactional();
        }

        public boolean pcSerializing() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.serializing();
        }

        public void pcDirty(String string) {
            if (this.pcStateManager == null) {
                return;
            }
            this.pcStateManager.dirty(string);
        }

        public StateManager pcGetStateManager() {
            return this.pcStateManager;
        }

        public Object pcGetVersion() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.getVersion();
        }

        public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
            if (this.pcStateManager != null) {
                this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
                return;
            }
            this.pcStateManager = stateManager;
        }

        public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
            throw new InternalException();
        }

        public void pcCopyKeyFieldsToObjectId(Object object) {
            throw new InternalException();
        }

        public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
            StringId stringId = (StringId)object;
            fieldConsumer.storeStringField(2 + pcInheritedFieldCount, stringId.getId());
        }

        public void pcCopyKeyFieldsFromObjectId(Object object) {
            StringId stringId = (StringId)object;
            this.string = stringId.getId();
        }

        public Object pcNewObjectIdInstance(Object object) {
            Class clazz = class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner != null ? class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner : (class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner = Inner.class$("org.apache.openjpa.persistence.kernel.TestEJBLobs$Inner"));
            return new StringId(clazz, (String)object);
        }

        public Object pcNewObjectIdInstance() {
            Class clazz = class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner != null ? class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner : (class$Lorg$apache$openjpa$persistence$kernel$TestEJBLobs$Inner = Inner.class$("org.apache.openjpa.persistence.kernel.TestEJBLobs$Inner"));
            return new StringId(clazz, this.string);
        }

        private static final Inner2 pcGetblobField(Inner inner) {
            if (inner.pcStateManager == null) {
                return inner.blobField;
            }
            int n = pcInheritedFieldCount + 0;
            inner.pcStateManager.accessingField(n);
            return inner.blobField;
        }

        private static final void pcSetblobField(Inner inner, Inner2 inner2) {
            if (inner.pcStateManager == null) {
                inner.blobField = inner2;
                return;
            }
            inner.pcStateManager.settingObjectField((PersistenceCapable)inner, pcInheritedFieldCount + 0, (Object)inner.blobField, (Object)inner2, 0);
        }

        private static final String pcGetclobField(Inner inner) {
            if (inner.pcStateManager == null) {
                return inner.clobField;
            }
            int n = pcInheritedFieldCount + 1;
            inner.pcStateManager.accessingField(n);
            return inner.clobField;
        }

        private static final void pcSetclobField(Inner inner, String string) {
            if (inner.pcStateManager == null) {
                inner.clobField = string;
                return;
            }
            inner.pcStateManager.settingStringField((PersistenceCapable)inner, pcInheritedFieldCount + 1, inner.clobField, string, 0);
        }

        private static final String pcGetstring(Inner inner) {
            if (inner.pcStateManager == null) {
                return inner.string;
            }
            int n = pcInheritedFieldCount + 2;
            inner.pcStateManager.accessingField(n);
            return inner.string;
        }

        private static final void pcSetstring(Inner inner, String string) {
            if (inner.pcStateManager == null) {
                inner.string = string;
                return;
            }
            inner.pcStateManager.settingStringField((PersistenceCapable)inner, pcInheritedFieldCount + 2, inner.string, string, 0);
        }

        public Boolean pcIsDetached() {
            if (this.pcStateManager != null) {
                if (this.pcStateManager.isDetached()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
                return Boolean.TRUE;
            }
            if (!this.pcisDetachedStateDefinitive()) {
                return null;
            }
            return Boolean.FALSE;
        }

        private boolean pcisDetachedStateDefinitive() {
            return false;
        }

        public Object pcGetDetachedState() {
            return this.pcDetachedState;
        }

        public void pcSetDetachedState(Object object) {
            this.pcDetachedState = object;
        }
    }
}

