/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest2;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest3;

public class TestEJBLocales
extends AbstractTestCase {
    public TestEJBLocales(String name) {
        super(name, "kernelcactusapp");
    }

    public void setUp() throws Exception {
        super.setUp(RuntimeTest1.class, RuntimeTest2.class, RuntimeTest3.class);
    }

    public void testLocales() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        RuntimeTest1 t12 = new RuntimeTest1(1);
        t12.setLocaleField(new Locale(Locale.FRANCE.getCountry(), Locale.FRENCH.getLanguage()));
        pm.persist((Object)t12);
        pm.persist((Object)new RuntimeTest1(2));
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        List c = this.findAll(RuntimeTest1.class, (EntityManager)pm);
        TestEJBLocales.assertEquals((int)2, (int)c.size());
        boolean foundNull = false;
        boolean foundFrance = false;
        for (RuntimeTest1 t12 : c) {
            Locale locale = t12.getLocaleField();
            if (locale == null) {
                foundNull = true;
                continue;
            }
            if (!locale.getCountry().equals(Locale.FRANCE.getCountry()) || !locale.getLanguage().equals(Locale.FRANCE.getLanguage())) continue;
            foundFrance = true;
        }
        TestEJBLocales.assertTrue((boolean)foundNull);
        TestEJBLocales.assertTrue((boolean)foundFrance);
        this.endEm((EntityManager)pm);
    }

    public List findAll(Class c, EntityManager em) {
        List l = em.createQuery("Select object(o) from RuntimeTest1 o").getResultList();
        return l;
    }
}

