/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.kernel.common.apps.InverseA;
import org.apache.openjpa.persistence.kernel.common.apps.InverseB;

public class TestEJBManagedInverses
extends AbstractTestCase {
    public TestEJBManagedInverses(String name) {
        super(name, "kernelcactusapp");
    }

    public void setUp() throws Exception {
        super.setUp(InverseA.class, InverseB.class);
    }

    public void testOneOne() {
        this.oneOneTest(true);
    }

    public void testOneOneWithPreStore() {
        this.oneOneTest(false);
    }

    private void oneOneTest(boolean flush) {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        InverseA a = new InverseA();
        InverseA a2 = new InverseA();
        InverseA a3 = new InverseA();
        a.setOneOne(a2);
        a.setOneOneOwner(a2);
        pm.persist((Object)a);
        pm.persist((Object)a3);
        TestEJBManagedInverses.assertEquals((String)"a.getOneOne is not a2", (Object)a2, (Object)a.getOneOne());
        TestEJBManagedInverses.assertEquals((String)"a.getOneOneOwner is not a2", (Object)a2, (Object)a.getOneOneOwner());
        this.endTx((EntityManager)pm);
        this.startTx((EntityManager)pm);
        a2.setOneOne(a3);
        a2.setOneOneOwner(a3);
        TestEJBManagedInverses.assertEquals((Object)a3, (Object)a2.getOneOne());
        TestEJBManagedInverses.assertEquals((Object)a3, (Object)a2.getOneOneOwner());
        this.endTx((EntityManager)pm);
        TestEJBManagedInverses.assertEquals((Object)a3, (Object)a2.getOneOne());
        TestEJBManagedInverses.assertEquals((Object)a3, (Object)a2.getOneOneOwner());
        this.startTx((EntityManager)pm);
        a2.setOneOne(null);
        a2.setOneOneOwner(null);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }
}

