/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.Iterator;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.Extent;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest2;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest3;

public class TestExtents2
extends BaseKernelTest {
    private Object _oid1 = null;
    private Object _oid2 = null;
    private Object _oid3 = null;

    public TestExtents2(String name) {
        super(name);
    }

    public TestExtents2() {
    }

    public void setUp() throws Exception {
        super.setUp(RuntimeTest1.class, RuntimeTest2.class, RuntimeTest3.class);
        RuntimeTest1 test1 = new RuntimeTest1();
        test1.setIntField(1);
        RuntimeTest2 test2 = new RuntimeTest2();
        test2.setIntField(2);
        test2.setIntField2(2);
        RuntimeTest3 test3 = new RuntimeTest3();
        test3.setIntField(3);
        test3.setIntField3(3);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        pm.persist((Object)test1);
        pm.persist((Object)test2);
        pm.persist((Object)test3);
        this._oid1 = pm.getObjectId((Object)test1);
        this._oid2 = pm.getObjectId((Object)test2);
        this._oid3 = pm.getObjectId((Object)test3);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testProperties() {
        OpenJPAEntityManager pm = this.getPM();
        Extent ext = pm.createExtent(RuntimeTest2.class, false);
        TestExtents2.assertEquals((Object)pm, (Object)ext.getEntityManager());
        TestExtents2.assertEquals(RuntimeTest2.class, (Object)ext.getElementClass());
        TestExtents2.assertTrue((!ext.hasSubclasses() ? 1 : 0) != 0);
        ext = pm.createExtent(RuntimeTest1.class, true);
        TestExtents2.assertEquals((Object)pm, (Object)ext.getEntityManager());
        TestExtents2.assertEquals(RuntimeTest1.class, (Object)ext.getElementClass());
        TestExtents2.assertTrue((boolean)ext.hasSubclasses());
    }

    public void testNoSubclasses() {
        OpenJPAEntityManager pm = this.getPM();
        Extent ext = pm.createExtent(RuntimeTest1.class, false);
        Iterator itr = ext.iterator();
        TestExtents2.assertTrue((boolean)itr.hasNext());
        TestExtents2.assertEquals((Object)this._oid1, (Object)pm.getObjectId(itr.next()));
        TestExtents2.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        ext.closeAll();
    }

    public void testSubclasses() {
        OpenJPAEntityManager pm = this.getPM();
        Extent ext = pm.createExtent(RuntimeTest1.class, true);
        int test1Count = 0;
        int test2Count = 0;
        int test3Count = 0;
        Iterator itr = ext.iterator();
        while (itr.hasNext()) {
            Object next = pm.getObjectId(itr.next());
            if (this._oid1.equals(next)) {
                ++test1Count;
                continue;
            }
            if (this._oid2.equals(next)) {
                ++test2Count;
                continue;
            }
            if (!this._oid3.equals(next)) continue;
            ++test3Count;
        }
        ext.closeAll();
        TestExtents2.assertEquals((int)1, (int)test1Count);
        TestExtents2.assertEquals((int)1, (int)test2Count);
        TestExtents2.assertEquals((int)1, (int)test3Count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContainsNewlyPersisted() {
        RuntimeTest1 test1 = new RuntimeTest1();
        RuntimeTest2 test2 = new RuntimeTest2();
        OpenJPAEntityManager pm = this.getPM();
        pm.setIgnoreChanges(false);
        this.startTx((EntityManager)pm);
        try {
            pm.persist((Object)test1);
            pm.persist((Object)test2);
            Object newOid = pm.getObjectId((Object)test1);
            Extent ext = pm.createExtent(RuntimeTest1.class, false);
            boolean foundOid1 = false;
            boolean foundNew = false;
            Iterator itr = ext.iterator();
            while (itr.hasNext()) {
                Object next = pm.getObjectId(itr.next());
                if (this._oid1.equals(next)) {
                    foundOid1 = true;
                    continue;
                }
                if (newOid.equals(next)) {
                    foundNew = true;
                    continue;
                }
                TestExtents2.fail((String)"Bad object in extent.");
            }
            ext.closeAll();
            TestExtents2.assertTrue((boolean)foundOid1);
            TestExtents2.assertTrue((boolean)foundNew);
        }
        finally {
            this.rollbackTx((EntityManager)pm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotContainsNewlyDeleted() {
        OpenJPAEntityManager pm = this.getPM();
        pm.setIgnoreChanges(false);
        this.startTx((EntityManager)pm);
        try {
            RuntimeTest2 test2 = (RuntimeTest2)pm.find(RuntimeTest2.class, this._oid2);
            pm.remove((Object)test2);
            RuntimeTest1 test1 = new RuntimeTest1();
            pm.persist((Object)test1);
            pm.remove((Object)test1);
            Extent ext = pm.createExtent(RuntimeTest1.class, true);
            boolean foundOid1 = false;
            boolean foundOid3 = false;
            Iterator itr = ext.iterator();
            while (itr.hasNext()) {
                Object next = pm.getObjectId(itr.next());
                if (this._oid1.equals(next)) {
                    foundOid1 = true;
                    continue;
                }
                if (this._oid3.equals(next)) {
                    foundOid3 = true;
                    continue;
                }
                TestExtents2.fail((String)"Bad object in extent.");
            }
            ext.closeAll();
            TestExtents2.assertTrue((boolean)foundOid1);
            TestExtents2.assertTrue((boolean)foundOid3);
        }
        finally {
            this.rollbackTx((EntityManager)pm);
        }
    }
}

