/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.RestoreStateType;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest2;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest3;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.util.UserException;

public class TestInitialValueFetching
extends BaseKernelTest {
    public TestInitialValueFetching(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp(RuntimeTest1.class, RuntimeTest2.class, RuntimeTest3.class);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        RuntimeTest1 rt1 = new RuntimeTest1("TestInitialValueFetching", 10);
        pm.persist((Object)rt1);
        rt1.setDateField(new Date());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testInitialValueString() {
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        RuntimeTest1 rt1 = this.getObject(pm);
        OpenJPAStateManager sm = this.getStateManager(rt1, (EntityManager)pm);
        FieldMetaData fmd = sm.getMetaData().getField("stringField");
        TestInitialValueFetching.assertEquals((Object)"TestInitialValueFetching", (Object)sm.fetchInitialField(fmd.getIndex()));
        rt1.setStringField("TestInitialValueFetching-2");
        TestInitialValueFetching.assertEquals((Object)"TestInitialValueFetching", (Object)sm.fetchInitialField(fmd.getIndex()));
        this.endTx((EntityManager)pm);
        TestInitialValueFetching.assertEquals((Object)"TestInitialValueFetching-2", (Object)sm.fetchInitialField(fmd.getIndex()));
        this.endEm((EntityManager)pm);
    }

    public void testInitialValueInt() {
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        RuntimeTest1 rt1 = this.getObject(pm);
        OpenJPAStateManager sm = this.getStateManager(rt1, (EntityManager)pm);
        FieldMetaData fmd = sm.getMetaData().getField("intField1");
        TestInitialValueFetching.assertEquals((int)10, (int)((Integer)sm.fetchInitialField(fmd.getIndex())));
        rt1.setIntField1(11);
        TestInitialValueFetching.assertEquals((int)10, (int)((Integer)sm.fetchInitialField(fmd.getIndex())));
        this.endTx((EntityManager)pm);
        TestInitialValueFetching.assertEquals((int)11, (int)((Integer)sm.fetchInitialField(fmd.getIndex())));
        this.endEm((EntityManager)pm);
    }

    @AllowFailure
    public void testInitialValueMutableValueFailures() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.RestoreMutableValues", "false");
        OpenJPAEntityManagerFactory pmf = this.getEmf(props);
        OpenJPAEntityManager pm = pmf.createEntityManager();
        RuntimeTest1 rt1 = this.getObject(pm);
        rt1.getDateField();
        OpenJPAStateManager sm = this.getStateManager(rt1, (EntityManager)pm);
        FieldMetaData fmd = sm.getMetaData().getField("dateField");
        try {
            sm.fetchInitialField(fmd.getIndex());
            TestInitialValueFetching.fail((String)"should get an exception if RestoreMutableValues is false");
        }
        catch (UserException e) {
            // empty catch block
        }
        this.endEm((EntityManager)pm);
        pmf.close();
    }

    @AllowFailure
    public void testInitialValueDate() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.RestoreState", "all");
        OpenJPAEntityManagerFactory pmf = this.getEmf(props);
        OpenJPAEntityManager pm = pmf.createEntityManager();
        this.startTx((EntityManager)pm);
        RuntimeTest1 rt1 = this.getObject(pm);
        Date d = rt1.getDateField();
        OpenJPAStateManager sm = this.getStateManager(rt1, (EntityManager)pm);
        FieldMetaData fmd = sm.getMetaData().getField("dateField");
        TestInitialValueFetching.assertEquals((Object)d, (Object)sm.fetchInitialField(fmd.getIndex()));
        TestInitialValueFetching.assertTrue((String)"mutable object fails == test; should not", (d == sm.fetchInitialField(fmd.getIndex()) ? 1 : 0) != 0);
        Date d2 = new Date();
        rt1.setDateField(d2);
        TestInitialValueFetching.assertEquals((Object)d, (Object)sm.fetchInitialField(fmd.getIndex()));
        this.endTx((EntityManager)pm);
        TestInitialValueFetching.assertEquals((Object)d2, (Object)sm.fetchInitialField(fmd.getIndex()));
        TestInitialValueFetching.assertTrue((String)"mutable object passes == test; should not", (d2 != sm.fetchInitialField(fmd.getIndex()) ? 1 : 0) != 0);
        this.endEm((EntityManager)pm);
    }

    public void testInitialValueExceptions() {
        OpenJPAEntityManager pm = this.getPM();
        pm.setRestoreState(RestoreStateType.NONE);
        this.startTx((EntityManager)pm);
        RuntimeTest1 rt1 = this.getObject(pm);
        OpenJPAStateManager sm = this.getStateManager(rt1, (EntityManager)pm);
        FieldMetaData fmd = sm.getMetaData().getField("stringField");
        try {
            sm.fetchInitialField(fmd.getIndex());
            TestInitialValueFetching.fail((String)"exception should be thrown by KodoSM.fetchInitialField");
        }
        catch (UserException e) {
            // empty catch block
        }
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    private RuntimeTest1 getObject(OpenJPAEntityManager pm) {
        OpenJPAQuery q = pm.createQuery("SELECT o FROM RuntimeTest1 o WHERE o.stringField = 'TestInitialValueFetching'");
        List l = q.getResultList();
        return (RuntimeTest1)l.iterator().next();
    }
}

