/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import javax.persistence.EntityManager;
import junit.framework.AssertionFailedError;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.InstanceCallbacksTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;

public class TestInstanceCallbacks
extends BaseKernelTest {
    private static final int COMMIT = 0;
    private static final int FLUSH = 1;
    private static final int PRESTORE = 2;
    private OpenJPAEntityManager _pm = null;
    private InstanceCallbacksTest _callbacks = null;

    public TestInstanceCallbacks(String name) {
        super(name);
    }

    public TestInstanceCallbacks() {
    }

    public void setUp() throws Exception {
        this.deleteAll(InstanceCallbacksTest.class);
        this.deleteAll(RuntimeTest1.class);
        this._pm = this.getPM(true, true);
        this.startTx((EntityManager)this._pm);
        this._callbacks = new InstanceCallbacksTest();
        this._callbacks.setStringField("foo");
        this._pm.persist((Object)this._callbacks);
        Object id = this._pm.getObjectId((Object)this._callbacks);
        this.endTx((EntityManager)this._pm);
        this.endEm((EntityManager)this._pm);
        this._pm = this.getPM();
        this._callbacks = (InstanceCallbacksTest)this._pm.find(InstanceCallbacksTest.class, id);
    }

    @Override
    public void tearDown() throws Exception {
        this.rollbackTx((EntityManager)this._pm);
        this.endEm((EntityManager)this._pm);
        super.tearDown();
    }

    public void testPostLoad() {
        this._callbacks.getStringField();
        TestInstanceCallbacks.assertTrue((boolean)this._callbacks.postLoadCalled);
    }

    public void testPreStore() {
        this.preStoreTest(0);
    }

    public void testPreStoreWithFlush() {
        this.preStoreTest(1);
    }

    public void testPreStoreWithPreStore() {
        this.preStoreTest(2);
    }

    private void preStoreTest(int action) {
        this.assertNoCallbacksInvoked(this._callbacks);
        this.startTx((EntityManager)this._pm);
        this._callbacks.setStringField("bar");
        Object oid = this._pm.getObjectId((Object)this._callbacks);
        if (action == 0) {
            this._pm.flush();
            this.endTx((EntityManager)this._pm);
        } else if (action == 1) {
            this._pm.flush();
        } else if (action == 2) {
            this._pm.preFlush();
        }
        TestInstanceCallbacks.assertTrue((String)"prestore wasnt called", (boolean)this._callbacks.preStoreCalled);
        if (action != 0) {
            if (action != 1) {
                this._pm.flush();
            }
            this.endTx((EntityManager)this._pm);
        }
        OpenJPAEntityManager pm = this.getPM();
        InstanceCallbacksTest callbacks = (InstanceCallbacksTest)pm.find(InstanceCallbacksTest.class, oid);
        this.assertNoCallbacksInvoked(callbacks);
        TestInstanceCallbacks.assertEquals((String)"getonetoone strng is not jdoprestore", (String)"jdoPreStore", (String)callbacks.getOneOne().getStringField());
        this.endEm((EntityManager)pm);
    }

    public void testPreDelete() {
        this.assertNoCallbacksInvoked(this._callbacks);
        this.startTx((EntityManager)this._pm);
        this._pm.remove((Object)this._callbacks);
        TestInstanceCallbacks.assertTrue((boolean)this._callbacks.preDeleteCalled);
        this.endTx((EntityManager)this._pm);
    }

    public void testPreDeleteRecursion() {
        this.assertNoCallbacksInvoked(this._callbacks);
        this.startTx((EntityManager)this._pm);
        this._callbacks.preDeleteCycle = 0;
        this._pm.remove((Object)this._callbacks);
        TestInstanceCallbacks.assertEquals((int)1, (int)this._callbacks.preDeleteCycle);
        this.endTx((EntityManager)this._pm);
    }

    public void testSetRelatedReferenceInPreStore() {
        TestInstanceCallbacks.assertNull((Object)this._callbacks.getRelId());
        InstanceCallbacksTest callbacks2 = new InstanceCallbacksTest();
        callbacks2.setRelId(this._pm.getObjectId((Object)this._callbacks));
        this.startTx((EntityManager)this._pm);
        this._pm.persist((Object)callbacks2);
        this._pm.flush();
        this.endTx((EntityManager)this._pm);
        TestInstanceCallbacks.assertEquals((int)8888, (int)this._callbacks.getIntField());
        try {
            TestInstanceCallbacks.assertEquals((Object)callbacks2, (Object)this._callbacks.getRel());
        }
        catch (AssertionFailedError afe) {
            this.bug(1162, afe, "Setting a related object reference in preStore fails");
        }
    }

    public void testFlushCausesFlush() {
        this.causeFlushTest(1);
    }

    public void testPreStoreCausesFlush() {
        this.causeFlushTest(2);
    }

    private void causeFlushTest(int action) {
        this.startTx((EntityManager)this._pm);
        this._callbacks.setStringField("sss");
        this._callbacks.flushInPreStore = true;
        try {
            if (action == 1) {
                this._pm.flush();
            } else {
                this._pm.preFlush();
            }
            this.bug(1139, "Recursive flush allowed because exception swallowed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rollbackTx((EntityManager)this._pm);
    }

    private void assertNoCallbacksInvoked(InstanceCallbacksTest pc) {
        OpenJPAEntityManager pm = this.currentEntityManager();
        TestInstanceCallbacks.assertFalse((String)("Expected preDelete to not have been called for object ID " + pm.getObjectId((Object)pc)), (boolean)pc.preDeleteCalled);
        TestInstanceCallbacks.assertFalse((String)("Expected preClear to not have been called for object ID " + pm.getObjectId((Object)pc)), (boolean)pc.preClearCalled);
        TestInstanceCallbacks.assertFalse((String)("Expected preStore to not have been called for object ID " + pm.getObjectId((Object)pc)), (boolean)pc.preStoreCalled);
    }
}

