/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.LockGroupPC;
import org.apache.openjpa.persistence.kernel.common.apps.LockGroupPC2;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;

public class TestOptimisticLockGroups
extends BaseKernelTest {
    private Object oid;

    public TestOptimisticLockGroups() {
    }

    public TestOptimisticLockGroups(String name) {
        super(name);
    }

    public void setUp() {
        this.deleteAll(LockGroupPC.class);
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        LockGroupPC o = new LockGroupPC();
        pm.persist((Object)o);
        this.endTx((EntityManager)pm);
        this.oid = pm.getObjectId((Object)o);
        this.endEm((EntityManager)pm);
    }

    public void testDefaultLockGroupFailure1() {
        OpenJPAEntityManager pm1 = this.getPM(false, false);
        this.startTx((EntityManager)pm1);
        LockGroupPC pc1 = (LockGroupPC)pm1.find(LockGroupPC.class, this.oid);
        pc1.setDefaultLockGroupStringField("pm1 value");
        OpenJPAEntityManager pm2 = this.getPM(false, false);
        this.startTx((EntityManager)pm2);
        LockGroupPC pc2 = (LockGroupPC)pm2.find(LockGroupPC.class, this.oid);
        pc2.setDefaultLockGroupStringField("pm2 value");
        this.endTx((EntityManager)pm1);
        this.endEm((EntityManager)pm1);
        try {
            this.endTx((EntityManager)pm2);
            TestOptimisticLockGroups.fail((String)"should not be able to commit change to same value");
        }
        catch (Exception e) {
            TestOptimisticLockGroups.assertEquals((Object)pc2, (Object)this.getFailedObject(e));
        }
        this.endEm((EntityManager)pm2);
    }

    public void testDefaultLockGroupFailure2() {
        OpenJPAEntityManager pm1 = this.getPM(false, false);
        this.startTx((EntityManager)pm1);
        LockGroupPC pc1 = (LockGroupPC)pm1.find(LockGroupPC.class, this.oid);
        pc1.setDefaultLockGroupStringField("pm1 value");
        OpenJPAEntityManager pm2 = this.getPM(false, false);
        this.startTx((EntityManager)pm2);
        LockGroupPC pc2 = (LockGroupPC)pm2.find(LockGroupPC.class, this.oid);
        pc2.setExplicitDefaultLockGroupIntField(2);
        this.endTx((EntityManager)pm1);
        this.endEm((EntityManager)pm1);
        try {
            this.endTx((EntityManager)pm2);
            TestOptimisticLockGroups.fail((String)"should not be able to commit change to same value");
        }
        catch (Exception e) {
            TestOptimisticLockGroups.assertEquals((Object)pc2, (Object)this.getFailedObject(e));
        }
        this.endEm((EntityManager)pm2);
    }

    public void testNonDefaultLockGroupFailure1() {
        OpenJPAEntityManager pm1 = this.getPM(false, false);
        this.startTx((EntityManager)pm1);
        LockGroupPC pc1 = (LockGroupPC)pm1.find(LockGroupPC.class, this.oid);
        pc1.setLockGroup0IntField(1);
        OpenJPAEntityManager pm2 = this.getPM(false, false);
        this.startTx((EntityManager)pm2);
        LockGroupPC pc2 = (LockGroupPC)pm2.find(LockGroupPC.class, this.oid);
        pc2.setLockGroup0IntField(2);
        this.endTx((EntityManager)pm1);
        this.endEm((EntityManager)pm1);
        try {
            this.endTx((EntityManager)pm2);
            TestOptimisticLockGroups.fail((String)"should not be able to commit change to same value");
        }
        catch (Exception e) {
            TestOptimisticLockGroups.assertEquals((Object)pc2, (Object)this.getFailedObject(e));
        }
        this.endEm((EntityManager)pm2);
    }

    public void testNonDefaultLockGroupFailure2() {
        OpenJPAEntityManager pm1 = this.getPM(false, false);
        this.startTx((EntityManager)pm1);
        LockGroupPC pc1 = (LockGroupPC)pm1.find(LockGroupPC.class, this.oid);
        pc1.setLockGroup0IntField(1);
        OpenJPAEntityManager pm2 = this.getPM(false, false);
        this.startTx((EntityManager)pm2);
        LockGroupPC pc2 = (LockGroupPC)pm2.find(LockGroupPC.class, this.oid);
        pc2.setLockGroup0StringField("pm2");
        this.endTx((EntityManager)pm1);
        this.endEm((EntityManager)pm1);
        try {
            this.endTx((EntityManager)pm2);
            TestOptimisticLockGroups.fail((String)"should not be able to commit change to same value");
        }
        catch (Exception e) {
            TestOptimisticLockGroups.assertEquals((Object)pc2, (Object)this.getFailedObject(e));
        }
        this.endEm((EntityManager)pm2);
    }

    public void testMultipleLockGroupSuccess1() {
        OpenJPAEntityManager pm1 = this.getPM(false, false);
        this.startTx((EntityManager)pm1);
        LockGroupPC pc1 = (LockGroupPC)pm1.find(LockGroupPC.class, this.oid);
        pc1.setDefaultLockGroupStringField("pm1 value");
        pc1.setExplicitDefaultLockGroupIntField(1);
        OpenJPAEntityManager pm2 = this.getPM(false, false);
        this.startTx((EntityManager)pm2);
        LockGroupPC pc2 = (LockGroupPC)pm2.find(LockGroupPC.class, this.oid);
        pc2.setLockGroup0IntField(2);
        OpenJPAEntityManager pm3 = this.getPM(false, false);
        this.startTx((EntityManager)pm3);
        LockGroupPC pc3 = (LockGroupPC)pm3.find(LockGroupPC.class, this.oid);
        pc3.setLockGroup1RelationField(new RuntimeTest1());
        this.endTx((EntityManager)pm1);
        this.endEm((EntityManager)pm1);
        this.endTx((EntityManager)pm2);
        this.endEm((EntityManager)pm2);
        this.endTx((EntityManager)pm3);
        this.endEm((EntityManager)pm3);
    }

    public void testMultipleLockGroupSuccess2() {
        OpenJPAEntityManager pm1 = this.getPM(false, false);
        this.startTx((EntityManager)pm1);
        LockGroupPC pc1 = (LockGroupPC)pm1.find(LockGroupPC.class, this.oid);
        pc1.setDefaultLockGroupStringField("pm1 value");
        pc1.setLockGroup0IntField(1);
        OpenJPAEntityManager pm2 = this.getPM(false, false);
        this.startTx((EntityManager)pm2);
        LockGroupPC pc2 = (LockGroupPC)pm2.find(LockGroupPC.class, this.oid);
        pc2.setLockGroup1RelationField(new RuntimeTest1());
        this.endTx((EntityManager)pm2);
        this.endEm((EntityManager)pm2);
        this.endTx((EntityManager)pm1);
        this.endEm((EntityManager)pm1);
    }

    public void testAttachDetachSuccess() throws Exception {
        OpenJPAEntityManager pm1 = this.getPM(false, false);
        LockGroupPC pc1 = (LockGroupPC)pm1.find(LockGroupPC.class, this.oid);
        Object detached = pm1.detachCopy((Object)pc1);
        this.startTx((EntityManager)pm1);
        pc1.setLockGroup0IntField(1);
        pc1.setUnlockedStringField("pm1 changed value");
        this.endTx((EntityManager)pm1);
        this.endEm((EntityManager)pm1);
        LockGroupPC clone = (LockGroupPC)detached;
        clone.setLockGroup1IntField(2);
        clone.setUnlockedStringField("pm2 value");
        OpenJPAEntityManager pm2 = this.getPM(false, false);
        this.startTx((EntityManager)pm2);
        pm2.merge((Object)clone);
        this.endTx((EntityManager)pm2);
        this.endEm((EntityManager)pm2);
    }

    public void testAttachDetachFailure() throws Exception {
        OpenJPAEntityManager pm1 = this.getPM(false, false);
        LockGroupPC pc1 = (LockGroupPC)pm1.find(LockGroupPC.class, this.oid);
        Object detached = pm1.detachCopy((Object)pc1);
        this.startTx((EntityManager)pm1);
        pc1.setLockGroup0IntField(1);
        this.endTx((EntityManager)pm1);
        this.endEm((EntityManager)pm1);
        LockGroupPC clone = (LockGroupPC)detached;
        clone.setLockGroup0IntField(2);
        OpenJPAEntityManager pm2 = this.getPM(false, false);
        this.startTx((EntityManager)pm2);
        boolean failed = false;
        try {
            pm2.merge((Object)clone);
        }
        catch (Exception e) {
            failed = true;
        }
        if (failed) {
            this.rollbackTx((EntityManager)pm2);
        } else {
            try {
                this.endTx((EntityManager)pm2);
                TestOptimisticLockGroups.fail((String)"Allowed conflicting changes");
            }
            catch (Exception jve) {
                // empty catch block
            }
        }
    }

    public void testLockGroupNone() {
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.deleteAll(LockGroupPC2.class, (EntityManager)pm);
        this.startTx((EntityManager)pm);
        LockGroupPC2 pc = new LockGroupPC2();
        pc.setName("pc");
        pm.persist((Object)pc);
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)pc);
        this.endEm((EntityManager)pm);
        pm = this.getPM(false, false);
        pc = (LockGroupPC2)pm.find(LockGroupPC2.class, oid);
        this.startTx((EntityManager)pm);
        pc.getList().add("foo");
        OpenJPAEntityManager pm2 = this.getPM(false, false);
        LockGroupPC2 pc2 = (LockGroupPC2)pm2.find(LockGroupPC2.class, oid);
        this.startTx((EntityManager)pm2);
        pc2.getList().add("bar");
        this.endTx((EntityManager)pm2);
        this.endEm((EntityManager)pm2);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM(false, false);
        pc = (LockGroupPC2)pm.find(LockGroupPC2.class, oid);
        TestOptimisticLockGroups.assertEquals((int)2, (int)pc.getList().size());
        this.endEm((EntityManager)pm);
    }

    private Object getFailedObject(Exception e) {
        return null;
    }
}

