/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.DelegatingBrokerFactory;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest2;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest4;
import org.apache.openjpa.util.Id;

public class TestPersistenceManager
extends BaseKernelTest {
    private int _id = 0;
    private int _id2 = 0;

    public TestPersistenceManager(String name) {
        super(name);
    }

    public TestPersistenceManager() {
    }

    public void setUp() throws Exception {
        this.deleteAll(RuntimeTest1.class);
        this.deleteAll(RuntimeTest2.class);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        RuntimeTest1 a = new RuntimeTest1("STRING", 10);
        RuntimeTest2 b = new RuntimeTest2("STRING2", 11);
        pm.persist((Object)a);
        pm.persist((Object)b);
        this._id = a.getIntField();
        this._id2 = b.getIntField();
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testSetup() {
    }

    public void testClosed() {
        OpenJPAEntityManager pm = this.getPM();
        this.endEm((EntityManager)pm);
        try {
            pm.isOpen();
        }
        catch (RuntimeException re) {
            TestPersistenceManager.fail((String)"isClosed");
        }
        try {
            pm.find(RuntimeTest1.class, (Object)this._id);
            TestPersistenceManager.fail((String)"find");
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        try {
            pm.persist((Object)new RuntimeTest1(20));
            TestPersistenceManager.fail((String)"setUserObject");
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        try {
            pm.setNontransactionalRead(true);
            TestPersistenceManager.fail((String)"setNontransactionalRead");
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        try {
            this.endEm((EntityManager)pm);
            this.bug(65, null, "multiple close should not be allowed");
            TestPersistenceManager.fail((String)"multiple close should not be allowed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMultipleCloseThreaded() throws Throwable {
        final OpenJPAEntityManager pm = this.getPM();
        final ArrayList result = new ArrayList();
        this.startTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        new Thread(){

            @Override
            public void run() {
                try {
                    TestPersistenceManager.this.endEm((EntityManager)pm);
                    result.add(new Integer(0));
                }
                catch (Exception jdoe) {
                    result.add(jdoe);
                }
                catch (Throwable t) {
                    result.add(t);
                }
            }
        }.start();
        while (result.size() == 0) {
            Thread.currentThread();
            Thread.yield();
        }
        Object ret = result.get(0);
        if (ret instanceof Exception) {
            return;
        }
        if (ret instanceof Throwable) {
            throw (Throwable)ret;
        }
        this.bug(65, null, "multiple close in different threads should not be allowed");
    }

    public void testIllegalState() {
        OpenJPAEntityManager pm = this.getPM();
        RuntimeTest1 a = new RuntimeTest1("foo", 14);
        RuntimeTest1 a2 = (RuntimeTest1)pm.find(RuntimeTest1.class, (Object)this._id);
        try {
            pm.persist((Object)a);
            TestPersistenceManager.fail((String)"persist");
        }
        catch (Exception ise) {
            // empty catch block
        }
        try {
            pm.isTransactional((Object)a2);
            TestPersistenceManager.fail((String)"makeTransactional");
        }
        catch (Exception ise) {
            // empty catch block
        }
        try {
            pm.remove((Object)a2);
            TestPersistenceManager.fail((String)"deletePersistent");
        }
        catch (Exception ise) {
            // empty catch block
        }
        this.endEm((EntityManager)pm);
    }

    public void testOpenJPAEntityManagerFactorySerializable() throws Exception {
        OpenJPAEntityManagerFactory pmf = this.getEmf();
        TestPersistenceManager.assertNotNull((String)"OpenJPAEntityManagerFactory is null.", (Object)pmf);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(pmf);
        OpenJPAEntityManagerFactory pmf2 = (OpenJPAEntityManagerFactory)new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        TestPersistenceManager.assertNotNull((String)"Deserialized OpenJPAEntityManagerFactory is null.", (Object)pmf2);
        OpenJPAEntityManager pm = pmf2.createEntityManager();
        this.startTx((EntityManager)pm);
        Iterator i = pm.createExtent(RuntimeTest1.class, true).iterator();
        while (i.hasNext()) {
            i.next();
        }
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    private static BrokerFactory toBrokerFactory(EntityManagerFactory emf) {
        BrokerFactory bf = JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)emf);
        if (bf instanceof DelegatingBrokerFactory) {
            bf = ((DelegatingBrokerFactory)bf).getInnermostDelegate();
        }
        return bf;
    }

    public void testGetObjectById() {
        OpenJPAEntityManager pm = this.getPM();
        RuntimeTest1 b = (RuntimeTest1)pm.find(RuntimeTest1.class, (Object)this._id);
        TestPersistenceManager.assertEquals((String)"STRING", (String)b.getStringField());
        Id invalidId = new Id(RuntimeTest1.class, -1L);
        try {
            pm.find(RuntimeTest1.class, (Object)invalidId);
            TestPersistenceManager.fail((String)"Invalid Object");
        }
        catch (Exception e) {
            // empty catch block
        }
        invalidId = new Id(RuntimeTest4.class, -1L);
        try {
            RuntimeTest4 a = (RuntimeTest4)pm.getReference(RuntimeTest4.class, (Object)invalidId);
            TestPersistenceManager.assertNotNull((String)"invalid without subclasses and without validating should return hollow or throw exception", (Object)a);
            a.getName();
            TestPersistenceManager.fail((String)"Allowed access of invalid hollow instance.");
        }
        catch (EntityNotFoundException enfe) {
            // empty catch block
        }
        invalidId = new Id(RuntimeTest4.class, -3L);
        TestPersistenceManager.assertNull((Object)pm.find(RuntimeTest4.class, (Object)invalidId));
        this.endEm((EntityManager)pm);
    }

    public void testGetObjectsById() {
        OpenJPAEntityManager pm = this.getPM();
        ArrayList<Integer> idlist = new ArrayList<Integer>();
        idlist.add(this._id);
        idlist.add(this._id2);
        Collection pcs = pm.findAll(RuntimeTest1.class, idlist);
        TestPersistenceManager.assertEquals((int)2, (int)pcs.size());
        Iterator iter = pcs.iterator();
        TestPersistenceManager.assertEquals((String)"STRING", (String)((RuntimeTest1)iter.next()).getStringField());
        TestPersistenceManager.assertEquals((String)"STRING2", (String)((RuntimeTest2)iter.next()).getStringField());
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        idlist = new ArrayList();
        idlist.add(this._id);
        idlist.add(this._id);
        pcs = pm.findAll(RuntimeTest1.class, idlist);
        iter = pcs.iterator();
        TestPersistenceManager.assertEquals((int)2, (int)pcs.size());
        TestPersistenceManager.assertEquals((String)"STRING", (String)((RuntimeTest1)iter.next()).getStringField());
        iter = pcs.iterator();
        TestPersistenceManager.assertTrue((iter.next() == iter.next() ? 1 : 0) != 0);
        this.endEm((EntityManager)pm);
        Id invalidId = new Id(RuntimeTest4.class, -1L);
        pm = this.getPM();
        idlist = new ArrayList();
        idlist.add(this._id);
        idlist.add((Integer)invalidId);
        try {
            pcs = (ArrayList)pm.findAll(RuntimeTest1.class, idlist);
            iter = pcs.iterator();
            TestPersistenceManager.assertEquals((int)2, (int)pcs.size());
            TestPersistenceManager.assertEquals((String)"STRING", (String)((RuntimeTest1)iter.next()).getStringField());
            TestPersistenceManager.assertNotNull(iter.next());
            TestPersistenceManager.fail((String)"invalid id didnt cause exception");
        }
        catch (Exception onfe) {
            // empty catch block
        }
        try {
            ((RuntimeTest4)iter.next()).getName();
            TestPersistenceManager.fail((String)"Accessed invalid object.");
        }
        catch (Exception onfe) {
            this.bug(1138, onfe, "Wrong exception type");
        }
        pm = this.getPM();
        try {
            pm.findAll(RuntimeTest1.class, idlist);
            TestPersistenceManager.fail((String)"Found invalid object.");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.endEm((EntityManager)pm);
    }

    public void testEvictAll() {
        PCState s;
        OpenJPAEntityManager pm = this.getPM();
        List l = pm.createExtent(RuntimeTest1.class, true).list();
        pm.retrieveAll((Collection)l);
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            s = this.getStateManager(iter.next(), (EntityManager)pm).getPCState();
            TestPersistenceManager.assertEquals((Object)PCState.PNONTRANS, (Object)s);
        }
        pm.evictAll();
        iter = l.iterator();
        while (iter.hasNext()) {
            s = this.getStateManager(iter.next(), (EntityManager)pm).getPCState();
            TestPersistenceManager.assertEquals((Object)PCState.HOLLOW, (Object)s);
        }
    }

    public void testEvictAllCollection() {
        PCState s;
        OpenJPAEntityManager pm = this.getPM();
        List l = pm.createExtent(RuntimeTest1.class, true).list();
        pm.retrieveAll((Collection)l);
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            s = this.getStateManager(iter.next(), (EntityManager)pm).getPCState();
            TestPersistenceManager.assertEquals((Object)PCState.PNONTRANS, (Object)s);
        }
        pm.evictAll((Collection)l);
        iter = l.iterator();
        while (iter.hasNext()) {
            s = this.getStateManager(iter.next(), (EntityManager)pm).getPCState();
            TestPersistenceManager.assertEquals((Object)PCState.HOLLOW, (Object)s);
        }
    }

    public void testEvictAllClass() {
        PCState s;
        OpenJPAEntityManager pm = this.getPM();
        List l = pm.createExtent(RuntimeTest1.class, true).list();
        pm.retrieveAll((Collection)l);
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            s = this.getStateManager(iter.next(), (EntityManager)pm).getPCState();
            TestPersistenceManager.assertEquals((Object)PCState.PNONTRANS, (Object)s);
        }
        pm.evictAll(RuntimeTest1.class);
        iter = l.iterator();
        while (iter.hasNext()) {
            s = this.getStateManager(iter.next(), (EntityManager)pm).getPCState();
            TestPersistenceManager.assertEquals((Object)PCState.HOLLOW, (Object)s);
        }
    }

    public void testEvictAllClassFailure() {
        OpenJPAEntityManager pm = this.getPM();
        List l = pm.createExtent(RuntimeTest1.class, true).list();
        pm.retrieveAll((Collection)l);
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            PCState s = this.getStateManager(iter.next(), (EntityManager)pm).getPCState();
            TestPersistenceManager.assertEquals((Object)PCState.PNONTRANS, (Object)s);
        }
        pm.evictAll(RuntimeTest2.class);
        boolean foundPNONTRANS = false;
        Iterator iter2 = l.iterator();
        while (iter2.hasNext()) {
            PCState s = this.getStateManager(iter2.next(), (EntityManager)pm).getPCState();
            if (s != PCState.PNONTRANS) continue;
            foundPNONTRANS = true;
            break;
        }
        TestPersistenceManager.assertTrue((String)"should have found some RuntimeTest1s that were not evicted", (boolean)foundPNONTRANS);
    }

    public void testEvictAllExtent() {
        PCState s;
        OpenJPAEntityManager pm = this.getPM();
        List l = pm.createExtent(RuntimeTest1.class, true).list();
        pm.retrieveAll((Collection)l);
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            s = this.getStateManager(iter.next(), (EntityManager)pm).getPCState();
            TestPersistenceManager.assertEquals((Object)PCState.PNONTRANS, (Object)s);
        }
        pm.evictAll(pm.createExtent(RuntimeTest1.class, true));
        iter = l.iterator();
        while (iter.hasNext()) {
            s = this.getStateManager(iter.next(), (EntityManager)pm).getPCState();
            TestPersistenceManager.assertEquals((Object)PCState.HOLLOW, (Object)s);
        }
        pm.retrieveAll((Collection)l);
        iter = l.iterator();
        while (iter.hasNext()) {
            s = this.getStateManager(iter.next(), (EntityManager)pm).getPCState();
            TestPersistenceManager.assertEquals((Object)PCState.PNONTRANS, (Object)s);
        }
        pm.evictAll(pm.createExtent(RuntimeTest1.class, false));
        for (Object o : l) {
            if (o.getClass() != RuntimeTest1.class) continue;
            PCState s2 = this.getStateManager(o, (EntityManager)pm).getPCState();
            TestPersistenceManager.assertEquals((Object)PCState.HOLLOW, (Object)s2);
        }
    }
}

