/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.Extent;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.MapElementPC;
import org.apache.openjpa.persistence.kernel.common.apps.MapElementPCChild;
import org.apache.openjpa.persistence.kernel.common.apps.PersistentMapHolder;

public class TestPersistentMaps
extends BaseKernelTest {
    private static final String JDOQL = "javax.jdo.query.JDOQL";

    public TestPersistentMaps() {
    }

    public TestPersistentMaps(String name) {
        super(name);
    }

    public void setUp() {
        this.deleteAll(PersistentMapHolder.class);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        pm.persist((Object)new PersistentMapHolder());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    private PersistentMapHolder getHolder(OpenJPAEntityManager pm) {
        Extent e = pm.createExtent(PersistentMapHolder.class, true);
        this.assertSize(1, e.list());
        return (PersistentMapHolder)e.iterator().next();
    }

    private Object keyInstance(Class type) throws Exception {
        if (type.getName().equals(String.class.getName())) {
            return TestPersistentMaps.randomString();
        }
        return type.newInstance();
    }

    private void testMap(int num, String name, Class keyClass, Class valueClass) throws Exception {
        OpenJPAEntityManager srcpm = this.getPM(true, true);
        this.startTx((EntityManager)srcpm);
        PersistentMapHolder holder = this.getHolder(srcpm);
        Map map = holder.getNamedMap(name);
        HashMap<Object, Object> internalMap = new HashMap<Object, Object>();
        for (int i = 0; i < num; ++i) {
            Object key = this.keyInstance(keyClass);
            Object value = this.keyInstance(valueClass);
            map.put(key, value);
            internalMap.put(key, value);
            TestPersistentMaps.assertEquals(map.get(key), internalMap.get(key));
        }
        this.endTx((EntityManager)srcpm);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        map = holder.getNamedMap(name);
        for (Object k : internalMap.keySet()) {
            TestPersistentMaps.assertEquals(map.get(k), internalMap.get(k));
        }
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        String selectWhere = "select from " + PersistentMapHolder.class.getName() + " where ";
        pm = this.getPM();
        this.startTx((EntityManager)pm);
        for (Object param : internalMap.keySet()) {
            Object val;
            if (pm.isPersistent(param)) {
                param = pm.find(param.getClass(), pm.getObjectId(param));
            }
            if (pm.isPersistent(val = internalMap.get(param))) {
                val = pm.find(val.getClass(), pm.getObjectId(val));
            }
            OpenJPAQuery q = pm.createQuery(JDOQL, selectWhere + name + ".containsKey(:param)");
            q.setParameter("param", param);
            this.assertSize(1, q.getResultList());
            q = pm.createQuery(JDOQL, selectWhere + name + ".containsValue(:value)");
            q.setParameter("value", val);
            this.assertSize(1, q.getResultList());
            q = pm.createQuery(JDOQL, selectWhere + name + ".containsValue(" + name + ".get(:param))");
            q.setParameter("param", param);
            this.assertSize(1, q.getResultList());
            q = pm.createQuery(JDOQL, selectWhere + name + ".get(:param) != null");
            q.setParameter("param", param);
            this.assertSize(1, q.getResultList());
            q = pm.createQuery(JDOQL, selectWhere + name + ".get(:param) == :value");
            q.setParameter("param", param);
            q.setParameter("value", val);
            this.assertSize(1, q.getResultList());
            q = pm.createQuery(JDOQL, selectWhere + name + ".get(:param) != :value");
            q.setParameter("param", param);
            q.setParameter("value", val);
            this.assertSize(0, q.getResultList());
        }
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        this.startTx((EntityManager)pm);
        for (Object param : internalMap.keySet()) {
            if (pm.isPersistent(param)) {
                param = pm.find(param.getClass(), pm.getObjectId(param));
            }
            ArrayList<String> getQueries = new ArrayList<String>(Arrays.asList(selectWhere + name + ".get(:param) != null", selectWhere + name + ".get(:param) == " + name + ".get(:param)", selectWhere + "!(" + name + ".get(:param) == null)", selectWhere + "!(" + name + ".get(:param) != " + name + ".get(:param))"));
            for (String query : getQueries) {
                if (valueClass == String.class) {
                    query = query + " order by " + name + ".get(:param) desc";
                }
                OpenJPAQuery q = pm.createQuery(JDOQL, query);
                q.setParameter("param", param);
                this.assertSize(1, q.getResultList());
            }
        }
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        this.endEm((EntityManager)srcpm);
    }

    public void testPCKeyStringValue() throws Exception {
        this.testMap(5, "testPCKeyStringValue", MapElementPC.class, String.class);
    }

    public void testStringKeyPCValue() throws Exception {
        this.testMap(6, "testStringKeyPCValue", String.class, MapElementPC.class);
    }

    public void testPCKeyPCValue() throws Exception {
        this.testMap(7, "testPCKeyPCValue", MapElementPC.class, MapElementPC.class);
    }

    public void testPCSubKeyStringValue() throws Exception {
        this.testMap(8, "testPCSubKeyStringValue", MapElementPCChild.class, String.class);
    }

    public void testStringKeyPCSubValue() throws Exception {
        this.testMap(9, "testStringKeyPCSubValue", String.class, MapElementPCChild.class);
    }

    public void testPCSubKeyPCValue() throws Exception {
        this.testMap(10, "testPCSubKeyPCValue", MapElementPCChild.class, MapElementPC.class);
    }

    public void testPCSubKeyPCSubValue() throws Exception {
        this.testMap(11, "testPCSubKeyPCSubValue", MapElementPCChild.class, MapElementPCChild.class);
    }

    public void testPCKeyPCSubValue() throws Exception {
        this.testMap(12, "testPCKeyPCSubValue", MapElementPC.class, MapElementPCChild.class);
    }

    public void testPCIntfKeyStringValue() throws Exception {
        this.testMap(13, "testPCIntfKeyStringValue", MapElementPC.class, String.class);
    }

    public void testStringKeyPCIntfValue() throws Exception {
        this.testMap(14, "testStringKeyPCIntfValue", String.class, MapElementPC.class);
    }

    public void testPCIntfKeyPCValue() throws Exception {
        this.testMap(15, "testPCIntfKeyPCValue", MapElementPC.class, MapElementPC.class);
    }

    public void testQueryMultipleMaps() throws Exception {
        int i;
        this.deleteAll(PersistentMapHolder.class);
        String mapName = "testStringKeyPCValue";
        String[] mapNames = new String[]{"testPCKeyStringValue", "testPCKeyPCValue", "testPCSubKeyStringValue", "testStringKeyPCSubValue", "testPCSubKeyPCValue", "testPCSubKeyPCSubValue", "testPCKeyPCSubValue", "testPCIntfKeyStringValue", "testStringKeyPCIntfValue", "testPCIntfKeyPCValue"};
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        MapElementPC pc = new MapElementPC();
        pc.setElementData("foo");
        int max = 5;
        for (i = 0; i < max; ++i) {
            PersistentMapHolder holder = new PersistentMapHolder();
            for (int j = 0; j < i; ++j) {
                holder.getNamedMap(mapName).put("key" + j, pc);
            }
            pm.persist((Object)holder);
        }
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        pc = (MapElementPC)pm.find(MapElementPC.class, pm.getObjectId((Object)pc));
        for (i = 0; i < max; ++i) {
            String key = "key" + i;
            String selectWhere = "select from " + PersistentMapHolder.class.getName() + " where ";
            OpenJPAQuery q = pm.createQuery(JDOQL, selectWhere + mapName + ".containsKey(:key)");
            q.setParameter("key", (Object)key);
            this.assertSize(max - i - 1, q.getResultList());
            q = pm.createQuery(JDOQL, selectWhere + mapName + ".get(:key) == :val");
            q.setParameter("key", (Object)key);
            q.setParameter("val", (Object)pc);
            this.assertSize(max - i - 1, q.getResultList());
            q = pm.createQuery(JDOQL, selectWhere + "testPCKeyStringValue.isEmpty() && " + mapName + ".get(:key) == :val");
            q.setParameter("key", (Object)key);
            q.setParameter("val", (Object)pc);
            this.assertSize(max - i - 1, q.getResultList());
            for (int j = 0; j < mapNames.length; ++j) {
                StringBuffer query = new StringBuffer(selectWhere);
                for (int k = 0; k < j; ++k) {
                    query.append(mapNames[k] + ".isEmpty() && ");
                }
                q = pm.createQuery(JDOQL, query + mapName + ".get(:key) == :val");
                q.setParameter("key", (Object)key);
                q.setParameter("val", (Object)pc);
                this.assertSize(max - i - 1, q.getResultList());
            }
        }
        this.endEm((EntityManager)pm);
    }
}

