/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import junit.framework.Assert;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.PessimisticLockException;
import org.apache.openjpa.persistence.kernel.PessimisticLockEntity;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestPessimisticLockException
extends SQLListenerTestCase {
    int pKey = 1;
    static boolean doSleep = true;

    @Override
    public void setUp() throws Exception {
        super.setUp(PessimisticLockEntity.class);
    }

    protected boolean skipTest() {
        if (this.emf.getConfiguration() instanceof JDBCConfiguration) {
            DBDictionary inst = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
            return !(inst instanceof DB2Dictionary) && !(inst instanceof OracleDictionary);
        }
        return true;
    }

    public void testPessimisticLockException() {
        if (!this.skipTest()) {
            this.populate();
            TestThread t1 = new TestThread();
            TestThread t2 = new TestThread();
            t1.start();
            t2.start();
            while (t1.isAlive() || t2.isAlive()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (t1.gotPLEx && t2.gotPLEx) {
                TestPessimisticLockException.fail((String)"Both threads got a PersistenceLockException!  Only one thread should have received a PersistenceLockException");
            } else if (!t1.gotPLEx && !t2.gotPLEx) {
                TestPessimisticLockException.fail((String)"Neither thread got a PersistenceLockException!  One thread should have received a PersistenceLockException");
            } else if (t1.count < 2 && t2.count < 2) {
                TestPessimisticLockException.fail((String)"PersistenceLockException was received, but not the expected number of times!  One thread should have received a PersistenceLockException at least twice.");
            }
        }
    }

    public void testSQLCount() {
        if (!this.skipTest()) {
            this.populate();
            this.resetSQL();
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            em.getTransaction().begin();
            PessimisticLockEntity plEnt = (PessimisticLockEntity)em.find(PessimisticLockEntity.class, (Object)this.pKey);
            em.refresh((Object)plEnt, LockModeType.PESSIMISTIC_WRITE);
            plEnt.setName("test");
            em.getTransaction().commit();
            em.close();
            TestPessimisticLockException.assertEquals((String)"There should only be 3 SQL statements", (int)3, (int)this.getSQLCount());
        }
    }

    public void populate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        PessimisticLockEntity pt = new PessimisticLockEntity();
        pt.setId(this.pKey);
        em.persist((Object)pt);
        em.getTransaction().commit();
        em.close();
    }

    private class TestThread
    extends Thread {
        boolean gotPLEx = false;
        int count = 0;

        private TestThread() {
        }

        @Override
        public synchronized void run() {
            OpenJPAEntityManager oem = OpenJPAPersistence.cast((EntityManager)TestPessimisticLockException.this.emf.createEntityManager());
            oem.getTransaction().begin();
            PessimisticLockEntity entity = (PessimisticLockEntity)oem.find(PessimisticLockEntity.class, (Object)TestPessimisticLockException.this.pKey);
            boolean locked = false;
            while (!locked) {
                try {
                    oem.getFetchPlan().setLockTimeout(5000);
                    oem.lock((Object)entity, LockModeType.PESSIMISTIC_READ);
                    locked = true;
                }
                catch (PessimisticLockException ple) {
                    this.gotPLEx = true;
                    ++this.count;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    oem.refresh((Object)entity);
                }
                catch (Throwable pe) {
                    pe.printStackTrace();
                    Assert.fail((String)("Caught an unexepected exception: " + pe));
                }
                if (doSleep) {
                    doSleep = false;
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                if (oem.getTransaction().getRollbackOnly()) continue;
                oem.getTransaction().commit();
            }
        }
    }
}

