/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.HashMap;
import java.util.Locale;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;

public class TestRetainValuesInOptimistic
extends BaseKernelTest {
    private Object _oid = null;

    public TestRetainValuesInOptimistic() {
    }

    public TestRetainValuesInOptimistic(String test) {
        super(test);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.deleteAll(RuntimeTest1.class);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        RuntimeTest1 pc = new RuntimeTest1("str1", 1);
        pm.persist((Object)pc);
        this.endTx((EntityManager)pm);
        this._oid = pm.getObjectId((Object)pc);
        this.endEm((EntityManager)pm);
    }

    public void testRetain() {
        this.clearTest(true);
        this.optLockTest(true);
    }

    public void testNotRetain() {
        this.clearTest(false);
        this.optLockTest(false);
    }

    private void clearTest(boolean retain) {
        OpenJPAEntityManager pm = this.getPM(retain);
        OpenJPAEntityManagerFactory pmf = pm.getEntityManagerFactory();
        RuntimeTest1 pc = (RuntimeTest1)pm.find(RuntimeTest1.class, this._oid);
        OpenJPAEntityManager pm2 = this.getPM();
        RuntimeTest1 pc2 = (RuntimeTest1)pm2.find(RuntimeTest1.class, this._oid);
        this.startTx((EntityManager)pm2);
        pc2.setStringField("str2");
        pc2.setIntField1(2);
        this.endTx((EntityManager)pm2);
        this.endEm((EntityManager)pm2);
        this.startTx((EntityManager)pm);
        pc.setLocaleField(Locale.CHINA);
        TestRetainValuesInOptimistic.assertEquals((String)(retain ? "str1" : "str2"), (String)pc.getStringField());
        TestRetainValuesInOptimistic.assertEquals((int)(retain ? 1 : 2), (int)pc.getIntField1());
        try {
            this.endTx((EntityManager)pm);
            if (retain) {
                TestRetainValuesInOptimistic.fail((String)"Should have caused OL violation");
            }
        }
        catch (RuntimeException re) {
            if (!retain) {
                throw re;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.endEm((EntityManager)pm);
        if (!retain) {
            pm = this.getPM();
            pc = (RuntimeTest1)pm.find(RuntimeTest1.class, this._oid);
            TestRetainValuesInOptimistic.assertEquals((String)"str2", (String)pc.getStringField());
            TestRetainValuesInOptimistic.assertEquals((int)2, (int)pc.getIntField1());
            this.endEm((EntityManager)pm);
            try {
                pmf.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void optLockTest(boolean retain) {
        OpenJPAEntityManager pm2;
        OpenJPAEntityManagerFactory pmf;
        OpenJPAEntityManager pm1;
        block6: {
            pm1 = this.getPM(retain);
            pmf = pm1.getEntityManagerFactory();
            this.startTx((EntityManager)pm1);
            RuntimeTest1 pc1 = (RuntimeTest1)pm1.find(RuntimeTest1.class, this._oid);
            this.endTx((EntityManager)pm1);
            pm2 = this.getPM(retain);
            this.startTx((EntityManager)pm2);
            RuntimeTest1 pc2 = (RuntimeTest1)pm2.find(RuntimeTest1.class, this._oid);
            pc2.setStringField("str3");
            pc2.setIntField1(3);
            this.endTx((EntityManager)pm2);
            this.startTx((EntityManager)pm1);
            pc1.setStringField("str4");
            pc1.setIntField1(4);
            try {
                this.endTx((EntityManager)pm1);
                if (retain) {
                    TestRetainValuesInOptimistic.fail((String)"Expected opt lock error.");
                }
            }
            catch (Exception jove) {
                if (retain) break block6;
                TestRetainValuesInOptimistic.fail((String)"Caught opt lock error.");
            }
        }
        pm1.close();
        this.endEm((EntityManager)pm2);
        if (retain) {
            try {
                pmf.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private OpenJPAEntityManager getPM(boolean retain) {
        OpenJPAEntityManager pm;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.AutoClear", "all");
        if (retain) {
            pm = this.getPM(true, true);
        } else {
            OpenJPAEntityManagerFactory pmf = this.getEmf(props);
            pm = pmf.createEntityManager();
            pm.setOptimistic(true);
            pm.setRetainState(true);
        }
        return pm;
    }
}

