/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import junit.framework.Assert;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.OpenJPASavepoint;
import org.apache.openjpa.kernel.SavepointManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest2;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest3;

public class TestSavepointOrdering
extends BaseKernelTest {
    private static final int USER = 1;
    private static final int RELEASED = 2;
    private static final int ROLLBACK = 4;
    static Map<String, TrackingSavepoint> _assigned = new HashMap<String, TrackingSavepoint>();

    public TestSavepointOrdering(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp(RuntimeTest1.class, RuntimeTest2.class, RuntimeTest3.class);
        _assigned.clear();
    }

    public void testCleanUpCommit() {
        this.doCleanUpTest(true);
    }

    public void testCleanUpRollback() {
        this.doCleanUpTest(false);
    }

    public void doCleanUpTest(boolean commit) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.SavepointManager", TrackingSavepointManager.class.getName());
        OpenJPAEntityManagerFactory pmf = this.getEmf(props);
        OpenJPAEntityManager pm = pmf.createEntityManager();
        this.startTx((EntityManager)pm);
        pm.setSavepoint("test");
        pm.setSavepoint("test2");
        if (commit) {
            this.endTx((EntityManager)pm);
        } else {
            this.rollbackTx((EntityManager)pm);
        }
        this.assertFlags("test", 2, 5);
        this.assertFlags("test2", 2, 5);
        this.endEm((EntityManager)pm);
    }

    public void testOrderingWithRollback() {
        this.doOrderingTest(true);
    }

    public void testOrderingWithRelease() {
        this.doOrderingTest(false);
    }

    private void doOrderingTest(boolean rollback) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.SavepointManager", TrackingSavepointManager.class.getName());
        OpenJPAEntityManagerFactory pmf = this.getEmf(props);
        OpenJPAEntityManager pm = pmf.createEntityManager();
        this.startTx((EntityManager)pm);
        pm.setSavepoint("before");
        pm.setSavepoint("before2");
        pm.setSavepoint("test");
        pm.setSavepoint("test2");
        pm.setSavepoint("after");
        pm.setSavepoint("after2");
        if (rollback) {
            pm.rollbackToSavepoint("test2");
        } else {
            pm.releaseSavepoint("test2");
        }
        this.assertFlags("before", 0, 6);
        this.assertFlags("before2", 0, 6);
        this.assertFlags("test", 0, 6);
        this.assertFlags("after", 2, 1);
        this.assertFlags("after2", 2, 1);
        if (rollback) {
            this.assertFlags("test2", 4, 0);
        } else {
            this.assertFlags("test2", 3, 0);
        }
        pm.setSavepoint("after3");
        if (rollback) {
            pm.rollbackToSavepoint("test");
        } else {
            pm.releaseSavepoint("test");
        }
        this.assertFlags("before", 0, 6);
        this.assertFlags("before2", 0, 6);
        if (rollback) {
            this.assertFlags("test", 4, 0);
        } else {
            this.assertFlags("test", 3, 0);
        }
        this.assertFlags("after3", 2, 1);
        this.rollbackTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testDisallowFlush() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.SavepointManager", TrackingSavepointManager.class.getName() + "(AllowFlush=false)");
        OpenJPAEntityManagerFactory pmf = this.getEmf(props);
        OpenJPAEntityManager pm = pmf.createEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)new RuntimeTest1());
        pm.setSavepoint("a");
        try {
            pm.flush();
            TestSavepointOrdering.fail((String)"should have failed.");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.rollbackTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testDisallowFlush2() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.SavepointManager", TrackingSavepointManager.class.getName() + "(AllowFlush=false)");
        OpenJPAEntityManagerFactory pmf = this.getEmf(props);
        OpenJPAEntityManager pm = pmf.createEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)new RuntimeTest1());
        pm.flush();
        try {
            pm.setSavepoint("a");
            TestSavepointOrdering.fail((String)"should have failed.");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.rollbackTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testAllowFlush() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.SavepointManager", TrackingSavepointManager.class.getName() + "(AllowFlush=true)");
        OpenJPAEntityManagerFactory pmf = this.getEmf(props);
        OpenJPAEntityManager pm = pmf.createEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)new RuntimeTest1());
        pm.setSavepoint("a");
        try {
            pm.flush();
        }
        catch (Exception e) {
            TestSavepointOrdering.fail((String)"allows flush.");
        }
        this.rollbackTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testAllowFlush2() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.SavepointManager", TrackingSavepointManager.class.getName() + "(AllowFlush=true)");
        OpenJPAEntityManagerFactory pmf = this.getEmf(props);
        OpenJPAEntityManager pm = pmf.createEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)new RuntimeTest1());
        pm.flush();
        try {
            pm.setSavepoint("a");
        }
        catch (Exception e) {
            TestSavepointOrdering.fail((String)"allows flush.");
        }
        this.rollbackTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    private void assertFlags(String name, int flag, int noflag) {
        TrackingSavepoint sp = _assigned.get(name);
        TestSavepointOrdering.assertNotNull((Object)((Object)sp));
        TestSavepointOrdering.assertEquals((int)(sp.flags & flag), (int)flag);
        TestSavepointOrdering.assertTrue(((sp.flags & noflag) == 0 ? 1 : 0) != 0);
    }

    private static class TrackingSavepoint
    extends OpenJPASavepoint {
        int flags = 0;

        public TrackingSavepoint(Broker broker, String name) {
            super(broker, name, false);
        }

        public Collection rollback(Collection previous) {
            if ((this.flags & 6) != 0) {
                Assert.fail((String)"already used");
            }
            this.flags |= 4;
            return super.rollback(previous);
        }

        public void release(boolean user) {
            if ((this.flags & 6) != 0) {
                Assert.fail((String)"already used");
            }
            this.flags |= 2;
            if (user) {
                if ((this.flags & 1) != 0) {
                    Assert.fail((String)"already released");
                }
                this.flags |= 1;
            }
            super.release(user);
        }
    }

    public static class TrackingSavepointManager
    implements SavepointManager {
        public boolean allowFlush = false;

        public boolean supportsIncrementalFlush() {
            return this.allowFlush;
        }

        public OpenJPASavepoint newSavepoint(String name, Broker broker) {
            TrackingSavepoint sp = new TrackingSavepoint(broker, name);
            _assigned.put(sp.getName(), sp);
            return sp;
        }
    }
}

