/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.Iterator;
import java.util.Properties;
import javax.persistence.EntityManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.ModRuntimeTest1;
import org.apache.openjpa.persistence.kernel.common.apps.ModRuntimeTest2;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest4;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest5;

public class TestSavepoints
extends BaseKernelTest {
    public TestSavepoints(String name) {
        super(name);
    }

    protected String getSavepointPlugin() {
        return "in-mem";
    }

    @Override
    public Properties getProperties(String[] props) {
        Properties properties = super.getProperties(props);
        properties.put("openjpa.SavepointManager", this.getSavepointPlugin());
        return properties;
    }

    public void setUp() throws Exception {
        super.setUp(ModRuntimeTest1.class, ModRuntimeTest2.class, RuntimeTest4.class, RuntimeTest5.class);
    }

    public void testSimple() {
        this.doSimpleTest(true, 0, 0);
        this.doSimpleTest(true, 2, 0);
        this.doSimpleTest(true, 0, 2);
        this.doSimpleTest(false, 0, 0);
        this.doSimpleTest(false, 2, 0);
        this.doSimpleTest(false, 0, 2);
    }

    private void doSimpleTest(boolean newPC, int before, int after) {
        int i;
        OpenJPAEntityManager pm = this.getPM();
        ModRuntimeTest1 pc = new ModRuntimeTest1();
        this.startTx((EntityManager)pm);
        pc.setStringField("orig");
        pc.setIntField(-11);
        pm.persist((Object)pc);
        Object oid = pm.getObjectId((Object)pc);
        if (!newPC) {
            this.endTx((EntityManager)pm);
            pm = this.getPM();
            this.startTx((EntityManager)pm);
            pc = (ModRuntimeTest1)pm.find(ModRuntimeTest1.class, oid);
        }
        for (i = 0; i < before; ++i) {
            pc.setStringField("before" + i);
            pc.setIntField(i);
            pm.setSavepoint("before" + i);
        }
        pc.setStringField("value");
        pc.setIntField(333);
        pm.setSavepoint("test");
        for (i = 0; i < after; ++i) {
            pc.setStringField("after" + i);
            pc.setIntField(i * 10);
            pm.setSavepoint("after" + i);
        }
        pm.rollbackToSavepoint("test");
        TestSavepoints.assertEquals((String)"value", (String)pc.getStringField());
        TestSavepoints.assertEquals((int)333, (int)pc.getIntField());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        pc = (ModRuntimeTest1)pm.find(ModRuntimeTest1.class, oid);
        TestSavepoints.assertEquals((String)"value", (String)pc.getStringField());
        TestSavepoints.assertEquals((int)333, (int)pc.getIntField());
        this.endEm((EntityManager)pm);
    }

    public void testCleanOrdering() {
        OpenJPAEntityManager pm = this.getPM();
        ModRuntimeTest1 pc = new ModRuntimeTest1("orig", 1);
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        Object oid = pm.getObjectId((Object)pc);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        pm.setOptimistic(false);
        this.startTx((EntityManager)pm);
        ModRuntimeTest1 pc2 = new ModRuntimeTest1("foo", 2);
        pm.persist((Object)pc2);
        pm.setSavepoint("s1");
        pc = (ModRuntimeTest1)pm.find(ModRuntimeTest1.class, oid);
        TestSavepoints.assertTrue((boolean)pm.isTransactional((Object)pc));
        pc.setStringField("test");
        pm.setSavepoint("s2");
        pc.setStringField("bar");
        pm.rollbackToSavepoint("s2");
        TestSavepoints.assertTrue((boolean)pm.isTransactional((Object)pc));
        this.rollbackTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testLastSavepoint() {
        OpenJPAEntityManager pm = this.getPM();
        ModRuntimeTest1 pc = new ModRuntimeTest1("orig", 1);
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        Object oid = pm.getObjectId((Object)pc);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        pm.setOptimistic(false);
        this.startTx((EntityManager)pm);
        pc = (ModRuntimeTest1)pm.find(ModRuntimeTest1.class, oid);
        pc.setStringField("s1");
        pm.setSavepoint("s1");
        pc.setStringField("s2");
        pm.setSavepoint("s2");
        pc.setStringField("diff");
        pm.rollbackToSavepoint();
        TestSavepoints.assertEquals((String)"s2", (String)pc.getStringField());
        pm.releaseSavepoint();
        try {
            pm.rollbackToSavepoint("s1");
            TestSavepoints.fail((String)"Exhausted.");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.rollbackTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testNewRollback() {
        this.doNewRollbackTest(false, 0, 0);
        this.doNewRollbackTest(false, 2, 0);
        this.doNewRollbackTest(false, 0, 2);
        this.doNewRollbackTest(true, 0, 0);
        this.doNewRollbackTest(true, 2, 0);
        this.doNewRollbackTest(true, 0, 2);
    }

    public void doNewRollbackTest(boolean restore, int before, int after) {
        OpenJPAEntityManager pm = this.getPM();
        pm.setRetainState(restore);
        this.startTx((EntityManager)pm);
        for (int i = 0; i < before; ++i) {
            pm.persist((Object)new ModRuntimeTest1("s" + i, i));
        }
        pm.setSavepoint("test");
        ModRuntimeTest1 pc = new ModRuntimeTest1();
        pc.setStringField("orig");
        pm.persist((Object)pc);
        Object oid = pm.getObjectId((Object)pc);
        for (int i = 0; i < after; ++i) {
            pm.persist((Object)new ModRuntimeTest1());
            pm.setSavepoint("after" + i);
        }
        pm.rollbackToSavepoint("test");
        TestSavepoints.assertEquals((String)"orig", (String)pc.getStringField());
        TestSavepoints.assertFalse((boolean)pm.isPersistent((Object)pc));
        TestSavepoints.assertEquals((int)before, (int)pm.getTransactionalObjects().size());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        TestSavepoints.assertNull((Object)pm.find(ModRuntimeTest1.class, oid));
        this.endEm((EntityManager)pm);
    }

    public void testNewRelation() {
        this.doNewRelationTest(true, 0, 0);
        this.doNewRelationTest(true, 2, 0);
        this.doNewRelationTest(true, 0, 2);
        this.doNewRelationTest(false, 0, 0);
        this.doNewRelationTest(false, 2, 0);
        this.doNewRelationTest(false, 0, 2);
    }

    public void doNewRelationTest(boolean nullRel, int before, int after) {
        this.deleteAll(ModRuntimeTest1.class);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        ModRuntimeTest1 pc = new ModRuntimeTest1();
        pc.setStringField("orig");
        if (!nullRel) {
            pc.setSelfOneOne(new ModRuntimeTest1("one", 1));
        }
        pm.persist((Object)pc);
        Object oid = pm.getObjectId((Object)pc);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        pm.setRetainState(true);
        this.startTx((EntityManager)pm);
        pc = (ModRuntimeTest1)pm.find(ModRuntimeTest1.class, oid);
        for (int i = 0; i < before; ++i) {
            pc.setSelfOneOne(new ModRuntimeTest1("before" + i, i));
            pm.setSavepoint("before" + i);
        }
        pm.setSavepoint("test");
        pc.setSelfOneOne(new ModRuntimeTest1("new", 2));
        ModRuntimeTest1 pc2 = pc.getSelfOneOne();
        for (int i = 0; i < after; ++i) {
            pc.setSelfOneOne(new ModRuntimeTest1());
            pm.setSavepoint("after" + i);
        }
        pm.rollbackToSavepoint("test");
        TestSavepoints.assertEquals((String)"orig", (String)pc.getStringField());
        TestSavepoints.assertFalse((boolean)pm.isPersistent((Object)pc2));
        if (before > 0) {
            TestSavepoints.assertEquals((String)("before" + (before - 1)), (String)pc.getSelfOneOne().getStringField());
        } else if (nullRel) {
            TestSavepoints.assertNull((Object)pc.getSelfOneOne());
        } else {
            TestSavepoints.assertEquals((String)"one", (String)pc.getSelfOneOne().getStringField());
        }
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        pc = (ModRuntimeTest1)pm.find(ModRuntimeTest1.class, oid);
        TestSavepoints.assertEquals((String)"orig", (String)pc.getStringField());
        if (before > 0) {
            TestSavepoints.assertEquals((String)("before" + (before - 1)), (String)pc.getSelfOneOne().getStringField());
        } else if (nullRel) {
            TestSavepoints.assertNull((Object)pc.getSelfOneOne());
        } else {
            TestSavepoints.assertEquals((String)"one", (String)pc.getSelfOneOne().getStringField());
        }
        this.endEm((EntityManager)pm);
    }

    public void testNullRelation() {
        this.doNullRelationTest(true, 0, 0);
        this.doNullRelationTest(true, 2, 0);
        this.doNullRelationTest(true, 0, 2);
        this.doNullRelationTest(false, 0, 0);
        this.doNullRelationTest(false, 2, 0);
        this.doNullRelationTest(false, 0, 2);
    }

    public void doNullRelationTest(boolean retain, int before, int after) {
        int i;
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        ModRuntimeTest1 pc = new ModRuntimeTest1();
        pc.setStringField("orig");
        pc.setSelfOneOne(new ModRuntimeTest1("one", 1));
        pm.persist((Object)pc);
        Object oid = pm.getObjectId((Object)pc);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        pm.setRetainState(true);
        this.startTx((EntityManager)pm);
        pc = (ModRuntimeTest1)pm.find(ModRuntimeTest1.class, oid);
        for (i = 0; i < before; ++i) {
            pc.setSelfOneOne(new ModRuntimeTest1("before" + i, i));
            pm.setSavepoint("before" + i);
        }
        pm.setSavepoint("test");
        pc.setSelfOneOne(null);
        for (i = 0; i < after; ++i) {
            pc.setSelfOneOne(new ModRuntimeTest1());
            pm.setSavepoint("after" + i);
        }
        pm.rollbackToSavepoint("test");
        TestSavepoints.assertEquals((String)"orig", (String)pc.getStringField());
        if (before > 0) {
            TestSavepoints.assertEquals((String)("before" + (before - 1)), (String)pc.getSelfOneOne().getStringField());
        } else {
            TestSavepoints.assertEquals((String)"one", (String)pc.getSelfOneOne().getStringField());
        }
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        pc = (ModRuntimeTest1)pm.find(ModRuntimeTest1.class, oid);
        TestSavepoints.assertEquals((String)"orig", (String)pc.getStringField());
        if (before > 0) {
            TestSavepoints.assertEquals((String)("before" + (before - 1)), (String)pc.getSelfOneOne().getStringField());
        } else {
            TestSavepoints.assertEquals((String)"one", (String)pc.getSelfOneOne().getStringField());
        }
        this.endEm((EntityManager)pm);
    }

    public void testCollection() {
        this.doCollectionTest(true, 0, 0);
        this.doCollectionTest(true, 2, 0);
        this.doCollectionTest(true, 0, 2);
        this.doCollectionTest(false, 0, 0);
        this.doCollectionTest(false, 2, 0);
        this.doCollectionTest(false, 0, 2);
    }

    public void doCollectionTest(boolean newPC, int before, int after) {
        int i;
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        ModRuntimeTest1 pc = new ModRuntimeTest1("orig", 1);
        ModRuntimeTest1 pc2 = this.newElement(pc, "persist", 2);
        ModRuntimeTest1 pc3 = this.newElement(pc, "delete", 3);
        pm.persist((Object)pc);
        pm.persist((Object)pc3);
        Object oid = pm.getObjectId((Object)pc);
        if (!newPC) {
            this.endTx((EntityManager)pm);
            this.endEm((EntityManager)pm);
            pm = this.getPM();
            this.startTx((EntityManager)pm);
            pc = (ModRuntimeTest1)pm.find(ModRuntimeTest1.class, oid);
            TestSavepoints.assertEquals((int)2, (int)pc.getSelfOneMany().size());
            for (ModRuntimeTest1 temp : pc.getSelfOneMany()) {
                if (temp.getIntField() == 2) {
                    pc2 = temp;
                    continue;
                }
                if (temp.getIntField() == 3) {
                    pc3 = temp;
                    continue;
                }
                TestSavepoints.fail((String)"unknown");
            }
        }
        for (i = 0; i < before; ++i) {
            this.newElement(pc, "before" + i, (i + 1) * 10);
            pm.setSavepoint("before" + i);
        }
        pm.setSavepoint("test");
        pm.remove((Object)pc3);
        pc.getSelfOneMany().remove(pc2);
        pc.getSelfOneMany().remove(pc3);
        pc2.setSelfOneMany(null);
        for (i = 0; i < after; ++i) {
            this.newElement(pc, "after" + i, (i + 1) * -10);
            pm.setSavepoint("after" + i);
        }
        pm.rollbackToSavepoint("test");
        TestSavepoints.assertEquals((String)"orig", (String)pc.getStringField());
        TestSavepoints.assertFalse((boolean)pm.isRemoved((Object)pc2));
        for (ModRuntimeTest1 temp : pc.getSelfOneMany()) {
            TestSavepoints.assertFalse((boolean)pm.isRemoved((Object)temp));
            TestSavepoints.assertEquals((Object)pc, (Object)temp.getSelfOneOne());
            if (temp.getIntField() >= 0) continue;
            TestSavepoints.fail((String)("shouldn't be here:" + temp.getStringField()));
        }
        TestSavepoints.assertTrue((boolean)pc.getSelfOneMany().contains(pc2));
        TestSavepoints.assertTrue((boolean)pc.getSelfOneMany().contains(pc3));
        TestSavepoints.assertEquals((int)(2 + before), (int)pc.getSelfOneMany().size());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        pc = (ModRuntimeTest1)pm.find(ModRuntimeTest1.class, oid);
        TestSavepoints.assertEquals((String)"orig", (String)pc.getStringField());
        TestSavepoints.assertEquals((int)(2 + before), (int)pc.getSelfOneMany().size());
        boolean found2 = false;
        boolean found3 = false;
        for (ModRuntimeTest1 temp : pc.getSelfOneMany()) {
            TestSavepoints.assertEquals((Object)pc, (Object)temp.getSelfOneOne());
            if (temp.getIntField() < 0) {
                TestSavepoints.fail((String)("shouldn't be here:" + temp.getStringField()));
                continue;
            }
            if (temp.getIntField() == 2) {
                found2 = true;
                continue;
            }
            if (temp.getIntField() != 3) continue;
            found3 = true;
        }
        TestSavepoints.assertTrue((found2 && found3 ? 1 : 0) != 0);
        this.endEm((EntityManager)pm);
    }

    public void testChangeTracker() {
        int count;
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        RuntimeTest4 pc = new RuntimeTest4("orig");
        for (int i = 0; i < 12; ++i) {
            pc.getRuntimeTest5s().add(new RuntimeTest5("five" + i));
        }
        pm.persist((Object)pc);
        Object oid = pm.getObjectId((Object)pc);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        this.startTx((EntityManager)pm);
        pc = (RuntimeTest4)pm.find(RuntimeTest4.class, oid);
        TestSavepoints.assertEquals((int)12, (int)pc.getRuntimeTest5s().size());
        Iterator i = pc.getRuntimeTest5s().iterator();
        for (count = 0; count < 2; ++count) {
            i.next();
            i.remove();
        }
        TestSavepoints.assertEquals((int)10, (int)pc.getRuntimeTest5s().size());
        pm.setSavepoint("test");
        i = pc.getRuntimeTest5s().iterator();
        for (count = 0; count < 2; ++count) {
            i.next();
            i.remove();
        }
        TestSavepoints.assertEquals((int)8, (int)pc.getRuntimeTest5s().size());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        pc = (RuntimeTest4)pm.find(RuntimeTest4.class, oid);
        TestSavepoints.assertEquals((int)8, (int)pc.getRuntimeTest5s().size());
        this.endEm((EntityManager)pm);
    }

    private ModRuntimeTest1 newElement(ModRuntimeTest1 one, String str, int i) {
        ModRuntimeTest1 two = new ModRuntimeTest1(str, i);
        two.setSelfOneOne(one);
        one.getSelfOneMany().add(two);
        return two;
    }

    public static PCState getState(Object o) {
        OpenJPAEntityManager pm = OpenJPAPersistence.getEntityManager((Object)o);
        if (pm == null) {
            return null;
        }
        return JPAFacadeHelper.toBroker((EntityManager)pm).getStateManager(o).getPCState();
    }
}

