/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.Permission;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest2;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest3;

public class TestSecurityContext
extends BaseKernelTest {
    private SecurityManager oldManager;

    public TestSecurityContext() {
    }

    public TestSecurityContext(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp(RuntimeTest1.class, RuntimeTest2.class, RuntimeTest3.class);
        this.oldManager = System.getSecurityManager();
    }

    @Override
    public void tearDown() throws Exception {
        System.setSecurityManager(this.oldManager);
        this.oldManager = null;
        super.tearDown();
    }

    public void testInSecureClassLoader() {
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        pm.createExtent(RuntimeTest1.class, true).iterator().hasNext();
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public class StrictSecurityManager
    extends SecurityManager {
        private void debug(String msg) {
        }

        @Override
        public void checkAccept(String host, int port) {
            this.debug("checkAccept: " + host + "," + port);
            super.checkAccept(host, port);
        }

        @Override
        public void checkAccess(Thread t) {
            this.debug("checkAccess: " + t);
            super.checkAccess(t);
        }

        @Override
        public void checkAccess(ThreadGroup g) {
            this.debug("checkAccess: " + g);
            super.checkAccess(g);
        }

        public void checkAwtEventQueueAccess() {
            this.debug("checkAwtEventQueueAccess");
            super.checkAwtEventQueueAccess();
        }

        @Override
        public void checkConnect(String host, int port) {
            this.debug("checkConnect: " + host + "," + port);
            super.checkConnect(host, port);
        }

        @Override
        public void checkConnect(String host, int port, Object context) {
            this.debug("checkConnect: " + host + "," + port + "," + context);
            super.checkConnect(host, port, context);
        }

        @Override
        public void checkCreateClassLoader() {
            this.debug("checkCreateClassLoader");
            super.checkCreateClassLoader();
        }

        @Override
        public void checkDelete(String file) {
            this.debug("checkDelete: " + file);
            super.checkDelete(file);
        }

        @Override
        public void checkExec(String cmd) {
            this.debug("checkExec: " + cmd);
            super.checkExec(cmd);
        }

        @Override
        public void checkExit(int status) {
            this.debug("checkExit: " + status);
            super.checkExit(status);
        }

        @Override
        public void checkLink(String lib) {
            this.debug("checkLink: " + lib);
            super.checkLink(lib);
        }

        @Override
        public void checkListen(int port) {
            this.debug("checkListen: " + port);
            super.checkListen(port);
        }

        public void checkMemberAccess(Class clazz, int which) {
            this.debug("checkMemberAccess: " + clazz + "," + which);
            super.checkMemberAccess(clazz, which);
        }

        @Override
        public void checkMulticast(InetAddress maddr) {
            this.debug("checkMulticast: " + maddr);
            super.checkMulticast(maddr);
        }

        @Override
        public void checkMulticast(InetAddress maddr, byte ttl) {
            this.debug("checkMulticast: " + maddr + "," + ttl);
            super.checkMulticast(maddr, ttl);
        }

        @Override
        public void checkPackageAccess(String pkg) {
            this.debug("checkPackageAccess: " + pkg);
            super.checkPackageAccess(pkg);
        }

        @Override
        public void checkPackageDefinition(String pkg) {
            this.debug("checkPackageDefinition: " + pkg);
            super.checkPackageDefinition(pkg);
        }

        @Override
        public void checkPermission(Permission perm) {
            this.debug("checkPermission: " + perm);
            super.checkPermission(perm);
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
            this.debug("checkPermission: " + perm + "," + context);
            super.checkPermission(perm, context);
        }

        @Override
        public void checkPrintJobAccess() {
            this.debug("checkPrintJobAccess");
            super.checkPrintJobAccess();
        }

        @Override
        public void checkPropertiesAccess() {
            this.debug("checkPropertiesAccess");
            super.checkPropertiesAccess();
        }

        @Override
        public void checkPropertyAccess(String key) {
            this.debug("checkPropertyAccess: " + key);
            super.checkPropertyAccess(key);
        }

        @Override
        public void checkRead(FileDescriptor fd) {
            this.debug("checkRead: " + fd);
            super.checkRead(fd);
        }

        @Override
        public void checkRead(String file) {
            this.debug("checkRead: " + file);
            super.checkRead(file);
        }

        @Override
        public void checkRead(String file, Object context) {
            this.debug("checkRead: " + file + "," + context);
            super.checkRead(file, context);
        }

        @Override
        public void checkSecurityAccess(String target) {
            this.debug("checkSecurityAccess: " + target);
            super.checkSecurityAccess(target);
        }

        @Override
        public void checkSetFactory() {
            this.debug("checkSetFactory");
            super.checkSetFactory();
        }

        public void checkSystemClipboardAccess() {
            this.debug("checkSystemClipboardAccess");
            super.checkSystemClipboardAccess();
        }

        public boolean checkTopLevelWindow(Object window) {
            this.debug("checkTopLevelWindow: " + window);
            return super.checkTopLevelWindow(window);
        }

        @Override
        public void checkWrite(FileDescriptor fd) {
            this.debug("checkWrite: " + fd);
            super.checkWrite(fd);
        }

        @Override
        public void checkWrite(String file) {
            this.debug("checkWrite: " + file);
            super.checkWrite(file);
        }

        protected int classDepth(String name) {
            this.debug("classDepth: " + name);
            return super.classDepth(name);
        }

        protected int classLoaderDepth() {
            this.debug("classLoaderDepth");
            return super.classLoaderDepth();
        }

        protected ClassLoader currentClassLoader() {
            this.debug("currentClassLoader");
            return super.currentClassLoader();
        }

        protected Class currentLoadedClass() {
            this.debug("currentLoadedClass");
            return super.currentLoadedClass();
        }

        protected Class[] getClassContext() {
            this.debug("getClassContext");
            return super.getClassContext();
        }

        public boolean getInCheck() {
            this.debug("getInCheck");
            return super.getInCheck();
        }

        @Override
        public Object getSecurityContext() {
            this.debug("getSecurityContext");
            return super.getSecurityContext();
        }

        @Override
        public ThreadGroup getThreadGroup() {
            this.debug("getThreadGroup");
            return super.getThreadGroup();
        }

        protected boolean inClass(String name) {
            this.debug("inClass: " + name);
            return super.inClass(name);
        }

        protected boolean inClassLoader() {
            this.debug("inClassLoader");
            return super.inClassLoader();
        }
    }
}

