/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.LinkedList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Table;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;

public class TestStaticInnerClasses
extends BaseKernelTest {
    private Object _oid = null;

    public TestStaticInnerClasses() {
    }

    public TestStaticInnerClasses(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp(Inner.class);
        Inner inner = new Inner("foo");
        inner.addTwin();
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        pm.persist((Object)inner);
        this._oid = pm.getObjectId((Object)inner);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testGetById() {
        OpenJPAEntityManager pm = this.getPM();
        Inner inner = (Inner)pm.find(Inner.class, this._oid);
        TestStaticInnerClasses.assertNotNull((Object)inner);
        TestStaticInnerClasses.assertEquals((String)"foo", (String)inner.getString());
        this.endEm((EntityManager)pm);
    }

    public void testGetByQuery() {
    }

    @Entity
    @Table(name="StaticInner")
    public static class Inner
    implements PersistenceCapable {
        private int num = 0;
        private String string = null;
        private List twins = new LinkedList();
        private static int pcInheritedFieldCount;
        private static String[] pcFieldNames;
        private static Class[] pcFieldTypes;
        private static byte[] pcFieldFlags;
        private static Class pcPCSuperclass;
        protected transient StateManager pcStateManager;
        static /* synthetic */ Class class$Ljava$lang$String;
        static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$kernel$TestStaticInnerClasses$Inner;
        private transient Object pcDetachedState;

        protected Inner() {
        }

        public Inner(String string) {
            this.string = string;
        }

        public void addTwin() {
            this.twins.add(new Inner(Inner.pcGetstring(this)));
        }

        public String getString() {
            return Inner.pcGetstring(this);
        }

        public int pcGetEnhancementContractVersion() {
            return 1674154;
        }

        static {
            pcFieldNames = new String[]{"num", "string"};
            Class[] classArray = new Class[2];
            classArray[0] = Integer.TYPE;
            Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Inner.class$("java.lang.String"));
            classArray[1] = clazz;
            pcFieldTypes = classArray;
            pcFieldFlags = new byte[]{26, 26};
            Class clazz2 = class$Lorg$apache$openjpa$persistence$kernel$TestStaticInnerClasses$Inner != null ? class$Lorg$apache$openjpa$persistence$kernel$TestStaticInnerClasses$Inner : (class$Lorg$apache$openjpa$persistence$kernel$TestStaticInnerClasses$Inner = Inner.class$("org.apache.openjpa.persistence.kernel.TestStaticInnerClasses$Inner"));
            PCRegistry.register((Class)clazz2, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"TestStaticInnerClasses$Inner", (PersistenceCapable)new Inner());
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        protected void pcClearFields() {
            this.num = 0;
            this.string = null;
        }

        public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
            Inner inner = new Inner();
            if (bl) {
                inner.pcClearFields();
            }
            inner.pcStateManager = stateManager;
            inner.pcCopyKeyFieldsFromObjectId(object);
            return inner;
        }

        public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
            Inner inner = new Inner();
            if (bl) {
                inner.pcClearFields();
            }
            inner.pcStateManager = stateManager;
            return inner;
        }

        protected static int pcGetManagedFieldCount() {
            return 2;
        }

        public void pcReplaceField(int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.num = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                    return;
                }
                case 1: {
                    this.string = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcReplaceFields(int[] nArray) {
            int n = 0;
            while (n < nArray.length) {
                this.pcReplaceField(nArray[n]);
                ++n;
            }
        }

        public void pcProvideField(int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.num);
                    return;
                }
                case 1: {
                    this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.string);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcProvideFields(int[] nArray) {
            int n = 0;
            while (n < nArray.length) {
                this.pcProvideField(nArray[n]);
                ++n;
            }
        }

        protected void pcCopyField(Inner inner, int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.num = inner.num;
                    return;
                }
                case 1: {
                    this.string = inner.string;
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcCopyFields(Object object, int[] nArray) {
            Inner inner = (Inner)object;
            if (inner.pcStateManager != this.pcStateManager) {
                throw new IllegalArgumentException();
            }
            if (this.pcStateManager == null) {
                throw new IllegalStateException();
            }
            int n = 0;
            while (n < nArray.length) {
                this.pcCopyField(inner, nArray[n]);
                ++n;
            }
        }

        public Object pcGetGenericContext() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.getGenericContext();
        }

        public Object pcFetchObjectId() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.fetchObjectId();
        }

        public boolean pcIsDeleted() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isDeleted();
        }

        public boolean pcIsDirty() {
            if (this.pcStateManager == null) {
                return false;
            }
            StateManager stateManager = this.pcStateManager;
            RedefinitionHelper.dirtyCheck((StateManager)stateManager);
            return stateManager.isDirty();
        }

        public boolean pcIsNew() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isNew();
        }

        public boolean pcIsPersistent() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isPersistent();
        }

        public boolean pcIsTransactional() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isTransactional();
        }

        public boolean pcSerializing() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.serializing();
        }

        public void pcDirty(String string) {
            if (this.pcStateManager == null) {
                return;
            }
            this.pcStateManager.dirty(string);
        }

        public StateManager pcGetStateManager() {
            return this.pcStateManager;
        }

        public Object pcGetVersion() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.getVersion();
        }

        public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
            if (this.pcStateManager != null) {
                this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
                return;
            }
            this.pcStateManager = stateManager;
        }

        public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        }

        public void pcCopyKeyFieldsToObjectId(Object object) {
        }

        public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        }

        public void pcCopyKeyFieldsFromObjectId(Object object) {
        }

        public Object pcNewObjectIdInstance() {
            return null;
        }

        public Object pcNewObjectIdInstance(Object object) {
            return null;
        }

        private static final int pcGetnum(Inner inner) {
            if (inner.pcStateManager == null) {
                return inner.num;
            }
            int n = pcInheritedFieldCount + 0;
            inner.pcStateManager.accessingField(n);
            return inner.num;
        }

        private static final void pcSetnum(Inner inner, int n) {
            if (inner.pcStateManager == null) {
                inner.num = n;
                return;
            }
            inner.pcStateManager.settingIntField((PersistenceCapable)inner, pcInheritedFieldCount + 0, inner.num, n, 0);
        }

        private static final String pcGetstring(Inner inner) {
            if (inner.pcStateManager == null) {
                return inner.string;
            }
            int n = pcInheritedFieldCount + 1;
            inner.pcStateManager.accessingField(n);
            return inner.string;
        }

        private static final void pcSetstring(Inner inner, String string) {
            if (inner.pcStateManager == null) {
                inner.string = string;
                return;
            }
            inner.pcStateManager.settingStringField((PersistenceCapable)inner, pcInheritedFieldCount + 1, inner.string, string, 0);
        }

        public Boolean pcIsDetached() {
            if (this.pcStateManager != null) {
                if (this.pcStateManager.isDetached()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Object pcGetDetachedState() {
            return this.pcDetachedState;
        }

        public void pcSetDetachedState(Object object) {
            this.pcDetachedState = object;
        }
    }
}

