/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.log;

import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.lib.log.AbstractLog;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.log.LogFactory;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.PersistenceProviderImpl;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;

public class TestConnectionRetainModeWarning
extends AbstractPersistenceTestCase
implements LogFactory {
    private static List<String> messages = new ArrayList<String>();
    Localizer _loc = Localizer.forPackage(PersistenceProviderImpl.class);

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        messages.clear();
    }

    public Log getLog(String channel) {
        return new AbstractLog(){

            protected boolean isEnabled(short logLevel) {
                return true;
            }

            public void trace(Object message) {
                messages.add(message.toString());
            }

            protected void log(short type, String message, Throwable t) {
                messages.add(message);
            }

            public void error(Object message) {
                messages.add(message.toString());
            }

            public void warn(Object message) {
                super.warn((Object)message.toString());
            }

            public void info(Object message) {
                messages.add(message.toString());
            }
        };
    }

    public void assertMessageContains(String s) {
        for (String message : messages) {
            if (!message.contains(s)) continue;
            return;
        }
        TestConnectionRetainModeWarning.fail((String)("Did not find message " + s + " in " + messages));
    }

    public void assertMessageNotFound(String s) {
        for (String message : messages) {
            if (!message.contains(s)) continue;
            TestConnectionRetainModeWarning.fail((String)("Found unexpected messsage " + s));
        }
    }

    public void testInfoMessage() {
        OpenJPAEntityManagerFactorySPI emf = this.createEMF("openjpa.Log", ((Object)((Object)this)).getClass().getCanonicalName(), "openjpa.ConnectionRetainMode", "always");
        TestConnectionRetainModeWarning.assertNotNull((Object)emf);
        this.assertMessageContains(this._loc.get("retain-always", (Object)this.getPersistenceUnitName()).toString());
        emf.close();
    }

    public void testInfoMessageNotFound() {
        OpenJPAEntityManagerFactorySPI emf = this.createEMF("openjpa.Log", ((Object)((Object)this)).getClass().getCanonicalName(), "openjpa.ConnectionRetainMode", "on-demand");
        TestConnectionRetainModeWarning.assertNotNull((Object)emf);
        this.assertMessageNotFound(this._loc.get("retain-always", (Object)this.getPersistenceUnitName()).toString());
        emf.close();
    }
}

