/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.managedinterface;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.Extent;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.managedinterface.ManagedIface;
import org.apache.openjpa.persistence.managedinterface.ManagedInterfaceEmbed;
import org.apache.openjpa.persistence.managedinterface.ManagedInterfaceOwner;
import org.apache.openjpa.persistence.managedinterface.ManagedInterfaceSup;
import org.apache.openjpa.persistence.managedinterface.MixedInterface;
import org.apache.openjpa.persistence.managedinterface.MixedInterfaceImpl;
import org.apache.openjpa.persistence.managedinterface.NonMappedInterface;
import org.apache.openjpa.persistence.managedinterface.NonMappedInterfaceImpl;
import org.apache.openjpa.persistence.query.SimpleEntity;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

@AllowFailure(message="On JDK6 Upgrade these tests are failing with wrong mapping. Column PC_ID in ManagedInterfaceSup Table is not created. getPC() is defined as property in ManageIFace sub-interface")
public class TestManagedInterfaces
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        super.setUp(SimpleEntity.class, ManagedInterfaceEmbed.class, ManagedInterfaceSup.class, ManagedIface.class, ManagedInterfaceOwner.class, MixedInterface.class, MixedInterfaceImpl.class, NonMappedInterfaceImpl.class, CLEAR_TABLES);
    }

    public void testEmbeddedMetaData() {
        this.emf.createEntityManager().close();
        ClassMetaData ownerMeta = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, ManagedIface.class);
        ClassMetaData embeddedMeta = ownerMeta.getField("embed").getDefiningMetaData();
        TestManagedInterfaces.assertTrue((boolean)embeddedMeta.isManagedInterface());
        TestManagedInterfaces.assertTrue((boolean)embeddedMeta.isIntercepting());
        ClassMetaData embeddableMeta = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, ManagedInterfaceEmbed.class);
        TestManagedInterfaces.assertTrue((boolean)embeddableMeta.isManagedInterface());
        TestManagedInterfaces.assertTrue((boolean)embeddableMeta.isIntercepting());
    }

    public void testManagedInterface() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ManagedIface pc = (ManagedIface)em.createInstance(ManagedIface.class);
        pc.setIntFieldSup(3);
        pc.setIntField(4);
        pc.setEmbed((ManagedInterfaceEmbed)em.createInstance(ManagedInterfaceEmbed.class));
        pc.getEmbed().setEmbedIntField(5);
        TestManagedInterfaces.assertEquals((int)5, (int)pc.getEmbed().getEmbedIntField());
        em.persist((Object)pc);
        Object oid = em.getObjectId((Object)pc);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (ManagedIface)em.find(ManagedIface.class, oid);
        TestManagedInterfaces.assertEquals((int)3, (int)pc.getIntFieldSup());
        TestManagedInterfaces.assertEquals((int)4, (int)pc.getIntField());
        TestManagedInterfaces.assertEquals((int)5, (int)pc.getEmbed().getEmbedIntField());
        em.getTransaction().begin();
        pc.setIntField(14);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        OpenJPAQuery query = em.createQuery("select o from ManagedIface o where o.intField = 14");
        pc = (ManagedIface)query.getSingleResult();
        TestManagedInterfaces.assertEquals((int)14, (int)pc.getIntField());
        em.remove((Object)pc);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        try {
            TestManagedInterfaces.assertNull((Object)em.find(ManagedIface.class, oid));
        }
        catch (EntityNotFoundException onfe) {
            // empty catch block
        }
        em.close();
    }

    public void testInterfaceOwner() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        ManagedInterfaceOwner pc = new ManagedInterfaceOwner();
        pc.setIFace((ManagedInterfaceSup)em.createInstance(ManagedInterfaceSup.class));
        pc.setEmbed((ManagedInterfaceEmbed)em.createInstance(ManagedInterfaceEmbed.class));
        pc.getIFace().setIntFieldSup(3);
        pc.getEmbed().setEmbedIntField(5);
        em.getTransaction().begin();
        em.persist((Object)pc);
        Object oid = em.getObjectId((Object)pc);
        em.getTransaction().commit();
        pc = (ManagedInterfaceOwner)em.find(ManagedInterfaceOwner.class, oid);
        TestManagedInterfaces.assertEquals((int)3, (int)pc.getIFace().getIntFieldSup());
        TestManagedInterfaces.assertEquals((int)5, (int)pc.getEmbed().getEmbedIntField());
        em.close();
        em = this.emf.createEntityManager();
        pc = (ManagedInterfaceOwner)em.find(ManagedInterfaceOwner.class, oid);
        TestManagedInterfaces.assertEquals((int)3, (int)pc.getIFace().getIntFieldSup());
        TestManagedInterfaces.assertEquals((int)5, (int)pc.getEmbed().getEmbedIntField());
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        OpenJPAQuery q = em.createQuery("select o from ManagedInterfaceOwner o where o.iface.intFieldSup = 3 and o.embed.embedIntField = 5");
        pc = (ManagedInterfaceOwner)q.getSingleResult();
        TestManagedInterfaces.assertEquals((int)3, (int)pc.getIFace().getIntFieldSup());
        TestManagedInterfaces.assertEquals((int)5, (int)pc.getEmbed().getEmbedIntField());
        pc.getIFace().setIntFieldSup(13);
        pc.getEmbed().setEmbedIntField(15);
        TestManagedInterfaces.assertEquals((int)13, (int)pc.getIFace().getIntFieldSup());
        TestManagedInterfaces.assertEquals((int)15, (int)pc.getEmbed().getEmbedIntField());
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (ManagedInterfaceOwner)em.find(ManagedInterfaceOwner.class, oid);
        TestManagedInterfaces.assertEquals((int)13, (int)pc.getIFace().getIntFieldSup());
        TestManagedInterfaces.assertEquals((int)15, (int)pc.getEmbed().getEmbedIntField());
        em.close();
    }

    public void testCollection() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ManagedIface pc = (ManagedIface)em.createInstance(ManagedIface.class);
        Set<Integer> set = new HashSet<Integer>();
        set.add(new Integer(3));
        set.add(new Integer(4));
        set.add(new Integer(5));
        pc.setSetInteger(set);
        em.persist((Object)pc);
        Object oid = em.getObjectId((Object)pc);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (ManagedIface)em.find(ManagedIface.class, oid);
        set = pc.getSetInteger();
        TestManagedInterfaces.assertEquals((int)3, (int)set.size());
        TestManagedInterfaces.assertTrue((boolean)set.contains(new Integer(3)));
        TestManagedInterfaces.assertTrue((boolean)set.contains(new Integer(4)));
        TestManagedInterfaces.assertTrue((boolean)set.contains(new Integer(5)));
        em.getTransaction().begin();
        set.remove(new Integer(4));
        set.add(new Integer(14));
        set.add(new Integer(15));
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (ManagedIface)em.find(ManagedIface.class, oid);
        set = pc.getSetInteger();
        TestManagedInterfaces.assertEquals((int)4, (int)set.size());
        TestManagedInterfaces.assertTrue((boolean)set.contains(new Integer(3)));
        TestManagedInterfaces.assertTrue((boolean)set.contains(new Integer(5)));
        TestManagedInterfaces.assertTrue((boolean)set.contains(new Integer(14)));
        TestManagedInterfaces.assertTrue((boolean)set.contains(new Integer(15)));
        em.getTransaction().begin();
        pc.setSetInteger(null);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (ManagedIface)em.find(ManagedIface.class, oid);
        set = pc.getSetInteger();
        TestManagedInterfaces.assertTrue((set == null || set.size() == 0 ? 1 : 0) != 0);
        em.close();
    }

    public void testCollectionPC() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ManagedIface pc = (ManagedIface)em.createInstance(ManagedIface.class);
        Set<SimpleEntity> set = new HashSet<SimpleEntity>();
        set.add(new SimpleEntity("a", "3"));
        set.add(new SimpleEntity("b", "4"));
        set.add(new SimpleEntity("c", "5"));
        pc.setSetPC(set);
        em.persist((Object)pc);
        Object oid = em.getObjectId((Object)pc);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (ManagedIface)em.find(ManagedIface.class, oid);
        set = pc.getSetPC();
        TestManagedInterfaces.assertEquals((int)3, (int)set.size());
        ArrayList<String> seen = new ArrayList<String>();
        SimpleEntity toRem = null;
        for (SimpleEntity rel : set) {
            seen.add(rel.getName());
            if (!rel.getValue().equals("4")) continue;
            toRem = rel;
        }
        TestManagedInterfaces.assertEquals((int)3, (int)seen.size());
        TestManagedInterfaces.assertTrue((boolean)seen.contains("a"));
        TestManagedInterfaces.assertTrue((boolean)seen.contains("b"));
        TestManagedInterfaces.assertTrue((boolean)seen.contains("c"));
        em.getTransaction().begin();
        TestManagedInterfaces.assertNotNull((Object)toRem);
        set.remove(toRem);
        set.add(new SimpleEntity("x", "14"));
        set.add(new SimpleEntity("y", "15"));
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (ManagedIface)em.find(ManagedIface.class, oid);
        set = pc.getSetPC();
        TestManagedInterfaces.assertEquals((int)4, (int)set.size());
        seen.clear();
        for (SimpleEntity rel : set) {
            seen.add(rel.getName());
        }
        TestManagedInterfaces.assertEquals((int)4, (int)seen.size());
        TestManagedInterfaces.assertTrue((boolean)seen.contains("a"));
        TestManagedInterfaces.assertTrue((boolean)seen.contains("c"));
        TestManagedInterfaces.assertTrue((boolean)seen.contains("x"));
        TestManagedInterfaces.assertTrue((boolean)seen.contains("y"));
        em.getTransaction().begin();
        pc.setSetPC(null);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (ManagedIface)em.find(ManagedIface.class, oid);
        set = pc.getSetPC();
        TestManagedInterfaces.assertTrue((set == null || set.size() == 0 ? 1 : 0) != 0);
        em.close();
    }

    public void testCollectionInterfaces() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ManagedIface pc = (ManagedIface)em.createInstance(ManagedIface.class);
        Set<Object> set = new HashSet<ManagedIface>();
        set.add(this.createInstance((OpenJPAEntityManager)em, 3));
        set.add(this.createInstance((OpenJPAEntityManager)em, 4));
        set.add(this.createInstance((OpenJPAEntityManager)em, 5));
        pc.setSetI(set);
        em.persist((Object)pc);
        Object oid = em.getObjectId((Object)pc);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (ManagedIface)em.find(ManagedIface.class, oid);
        set = pc.getSetI();
        TestManagedInterfaces.assertEquals((int)3, (int)set.size());
        ArrayList<Integer> seen = new ArrayList<Integer>();
        Object var6_6 = null;
        ManagedIface toRem = null;
        for (ManagedIface managedIface : set) {
            seen.add(new Integer(managedIface.getIntField()));
            if (managedIface.getIntField() != 4) continue;
            toRem = managedIface;
        }
        TestManagedInterfaces.assertEquals((int)3, (int)seen.size());
        TestManagedInterfaces.assertTrue((boolean)seen.contains(new Integer(3)));
        TestManagedInterfaces.assertTrue((boolean)seen.contains(new Integer(4)));
        TestManagedInterfaces.assertTrue((boolean)seen.contains(new Integer(5)));
        em.getTransaction().begin();
        TestManagedInterfaces.assertNotNull((Object)toRem);
        set.remove(toRem);
        set.add(this.createInstance((OpenJPAEntityManager)em, 14));
        set.add(this.createInstance((OpenJPAEntityManager)em, 15));
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (ManagedIface)em.find(ManagedIface.class, oid);
        set = pc.getSetI();
        TestManagedInterfaces.assertEquals((int)4, (int)set.size());
        seen.clear();
        for (ManagedIface managedIface : set) {
            seen.add(new Integer(managedIface.getIntField()));
        }
        TestManagedInterfaces.assertEquals((int)4, (int)seen.size());
        TestManagedInterfaces.assertTrue((boolean)seen.contains(new Integer(3)));
        TestManagedInterfaces.assertTrue((boolean)seen.contains(new Integer(5)));
        TestManagedInterfaces.assertTrue((boolean)seen.contains(new Integer(14)));
        TestManagedInterfaces.assertTrue((boolean)seen.contains(new Integer(15)));
        em.getTransaction().begin();
        pc.setSetPC(null);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (ManagedIface)em.find(ManagedIface.class, oid);
        set = pc.getSetPC();
        TestManagedInterfaces.assertTrue((set == null || set.size() == 0 ? 1 : 0) != 0);
        em.close();
    }

    public void testMixedQuery() {
        this.createMixed();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAQuery q = em.createQuery("select o from MixedInterface o where o.intField = 4");
        List c = q.getResultList();
        HashSet seen = new HashSet();
        TestManagedInterfaces.assertEquals((int)2, (int)c.size());
        for (MixedInterface pc : c) {
            TestManagedInterfaces.assertEquals((int)4, (int)pc.getIntField());
            seen.add(pc.getClass());
        }
        TestManagedInterfaces.assertEquals((int)2, (int)seen.size());
    }

    public void testQueryForMixedInterfaceImpls() {
        this.createMixed();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAQuery q = em.createQuery("select o from MixedInterfaceImpl o where o.intField = 4");
        MixedInterface pc = (MixedInterface)q.getSingleResult();
        TestManagedInterfaces.assertEquals((int)4, (int)pc.getIntField());
        TestManagedInterfaces.assertTrue((boolean)(pc instanceof MixedInterfaceImpl));
        em.close();
    }

    public void testMixedExtent() {
        this.createMixed();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Extent e = em.createExtent(MixedInterface.class, true);
        HashSet seen = new HashSet();
        int size = 0;
        Iterator it = e.iterator();
        while (it.hasNext()) {
            seen.add(it.next().getClass());
            ++size;
        }
        TestManagedInterfaces.assertEquals((int)3, (int)size);
        TestManagedInterfaces.assertEquals((int)2, (int)seen.size());
        e = em.createExtent(MixedInterface.class, false);
        seen = new HashSet();
        size = 0;
        it = e.iterator();
        while (it.hasNext()) {
            seen.add(it.next().getClass());
            ++size;
        }
        TestManagedInterfaces.assertEquals((int)1, (int)size);
        TestManagedInterfaces.assertNotEquals(MixedInterfaceImpl.class, seen.iterator().next());
        em.close();
    }

    private void createMixed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        MixedInterface pc = (MixedInterface)em.createInstance(MixedInterface.class);
        pc.setIntField(4);
        em.persist((Object)pc);
        pc = new MixedInterfaceImpl();
        pc.setIntField(4);
        em.persist((Object)pc);
        pc = new MixedInterfaceImpl();
        pc.setIntField(8);
        em.persist((Object)pc);
        em.getTransaction().commit();
        em.close();
    }

    public void testUnimplementedThrowsException() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        ManagedIface pc = this.createInstance((OpenJPAEntityManager)em, 1);
        try {
            pc.unimplemented();
            TestManagedInterfaces.fail((String)"Exception expected.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        em.close();
    }

    public void testNonMappedCreateInstanceException() {
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            em.createInstance(NonMappedInterface.class);
            TestManagedInterfaces.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (em != null) {
            em.close();
        }
    }

    public void testDetach() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ManagedIface pc = this.createInstance((OpenJPAEntityManager)em, 4);
        em.persist((Object)pc);
        Object oid = em.getObjectId((Object)pc);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        ManagedIface pcx = (ManagedIface)em.find(ManagedIface.class, oid);
        pc = (ManagedIface)em.detachCopy((Object)pcx);
        em.close();
        TestManagedInterfaces.assertTrue((boolean)em.isDetached((Object)pc));
        pc.setIntField(7);
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.merge((Object)pc);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (ManagedIface)em.find(ManagedIface.class, oid);
        TestManagedInterfaces.assertEquals((int)7, (int)pc.getIntField());
        em.close();
    }

    private ManagedIface createInstance(OpenJPAEntityManager em, int i) {
        ManagedIface pc = (ManagedIface)em.createInstance(ManagedIface.class);
        pc.setIntField(i);
        return pc;
    }
}

