/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.merge;

import java.util.ArrayList;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.merge.model.Inner;
import org.apache.openjpa.persistence.merge.model.Outer;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestLazyFields
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES, Outer.class, Inner.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMergeOfLazyFields() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.getTransaction().begin();
            Outer o1 = new Outer();
            Inner i1 = new Inner();
            o1.setInners(new ArrayList<Inner>());
            o1.getInners().add(i1);
            em.persist((Object)o1);
            em.getTransaction().commit();
            em.clear();
            long id = o1.getId();
            em.getTransaction().begin();
            Outer o2 = (Outer)em.find(Outer.class, (Object)id);
            Outer mergedO2 = (Outer)em.merge((Object)o2);
            TestLazyFields.assertEquals((Object)mergedO2, (Object)o2);
            em.getTransaction().commit();
            em.clear();
            em.getTransaction().begin();
            Outer o3 = (Outer)em.find(Outer.class, (Object)id);
            TestLazyFields.assertTrue((o3.getInners().size() > 0 ? 1 : 0) != 0);
            em.getTransaction().commit();
            em.clear();
        }
        finally {
            if (em != null) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

