/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.merge;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.merge.Child;
import org.apache.openjpa.persistence.merge.GrandChild;
import org.apache.openjpa.persistence.merge.Parent;
import org.apache.openjpa.persistence.merge.ParentPK;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestMergeNew
extends SQLListenerTestCase {
    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES, Parent.class, Child.class, GrandChild.class);
        TestMergeNew.assertNotNull((Object)this.emf);
        this.populate();
    }

    public void testMergeNewParent() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ParentPK pk = new ParentPK(1);
        pk.setKey1("K1");
        Parent parent = (Parent)em.find(Parent.class, (Object)pk);
        Child child = new Child();
        child.setChildKey(1);
        child.setParent(parent);
        parent.getChilds().add(child);
        GrandChild grandChild = new GrandChild();
        grandChild.setGrandChildKey(1);
        grandChild.setChild(child);
        child.getGrandChilds().add(grandChild);
        Parent newParent = (Parent)em.merge((Object)parent);
        TestMergeNew.assertNotNull((Object)newParent);
        TestMergeNew.assertEquals((String)newParent.getKey1(), (String)"K1");
        TestMergeNew.assertEquals((Object)newParent.getKey2(), (Object)new Integer(1));
        ArrayList childs = (ArrayList)newParent.getChilds();
        TestMergeNew.assertNotNull((Object)childs);
        TestMergeNew.assertEquals((int)childs.size(), (int)1);
        Child newChild = (Child)childs.get(0);
        TestMergeNew.assertNotSame((Object)child, (Object)newChild);
        Parent childParent = newChild.getParent();
        TestMergeNew.assertEquals((Object)childParent, (Object)newParent);
        TestMergeNew.assertEquals((Object)newChild.getChildKey(), (Object)new Integer(1));
        ArrayList grandChilds = (ArrayList)newChild.getGrandChilds();
        TestMergeNew.assertNotNull((Object)grandChilds);
        TestMergeNew.assertEquals((int)grandChilds.size(), (int)1);
        GrandChild newGrandChild = (GrandChild)grandChilds.get(0);
        TestMergeNew.assertNotSame((Object)newGrandChild, (Object)grandChild);
        Child grandChildChild = newGrandChild.getChild();
        TestMergeNew.assertEquals((Object)grandChildChild, (Object)newChild);
        em.getTransaction().commit();
        em.close();
    }

    public void testMergeParentRoundTrip() throws ClassNotFoundException, IOException {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ParentPK pk = new ParentPK(1);
        pk.setKey1("K1");
        Parent parent = (Parent)em.find(Parent.class, (Object)pk);
        Parent p2 = TestMergeNew.roundtrip(parent);
        Child child = new Child();
        child.setChildKey(1);
        child.setParent(p2);
        p2.getChilds().add(child);
        GrandChild grandChild = new GrandChild();
        grandChild.setChild(child);
        grandChild.setGrandChildKey(1);
        child.getGrandChilds().add(grandChild);
        Parent p3 = TestMergeNew.roundtrip(p2);
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Parent newParent = (Parent)em.merge((Object)p3);
        em.getTransaction().commit();
        TestMergeNew.assertNotNull((Object)newParent);
        TestMergeNew.assertEquals((String)newParent.getKey1(), (String)"K1");
        TestMergeNew.assertEquals((Object)newParent.getKey2(), (Object)new Integer(1));
        ArrayList childs = (ArrayList)newParent.getChilds();
        TestMergeNew.assertNotNull((Object)childs);
        TestMergeNew.assertEquals((int)childs.size(), (int)1);
        Child newChild = (Child)childs.get(0);
        TestMergeNew.assertNotSame((Object)child, (Object)newChild);
        Parent childParent = newChild.getParent();
        TestMergeNew.assertNotNull((Object)childParent);
        TestMergeNew.assertEquals((Object)newChild.getChildKey(), (Object)new Integer(1));
        ArrayList grandChilds = (ArrayList)newChild.getGrandChilds();
        TestMergeNew.assertNotNull((Object)grandChilds);
        TestMergeNew.assertEquals((int)grandChilds.size(), (int)1);
        GrandChild newGrandChild = (GrandChild)grandChilds.get(0);
        TestMergeNew.assertNotSame((Object)newGrandChild, (Object)grandChild);
        Child grandChildChild = newGrandChild.getChild();
        TestMergeNew.assertNotNull((Object)grandChildChild);
        em.close();
    }

    private void populate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Parent p = new Parent();
        p.setKey1("K1");
        p.setKey2(1);
        em.persist((Object)p);
        em.getTransaction().commit();
        em.close();
    }
}

