/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.meta.common.apps.MetaTest1;
import org.apache.openjpa.persistence.meta.common.apps.MetaTest2;
import org.apache.openjpa.persistence.meta.common.apps.MetaTest3;
import org.apache.openjpa.persistence.meta.common.apps.MetaTest5;
import org.apache.openjpa.persistence.meta.common.apps.MetaTest6;

public class TestClassMetaData
extends AbstractTestCase {
    private MetaDataRepository _repos = null;
    private ClassMetaData _metaTest1 = null;
    private ClassMetaData _metaTest2 = null;
    private ClassMetaData _metaTest3 = null;
    private ClassMetaData _metaTest5 = null;
    private ClassMetaData _metaTest6 = null;

    public TestClassMetaData(String test) {
        super(test, "metacactusapp");
    }

    public void setUp() throws Exception {
        this._repos = this.getRepository();
        this._metaTest5 = this._repos.getMetaData(MetaTest5.class, null, true);
        this._metaTest3 = this._repos.getMetaData(MetaTest3.class, null, true);
        this._metaTest2 = this._repos.getMetaData(MetaTest2.class, null, true);
        this._metaTest1 = this._repos.getMetaData(MetaTest1.class, null, true);
        this._metaTest6 = this._repos.getMetaData(MetaTest6.class, null, true);
    }

    protected MetaDataRepository getRepository() throws Exception {
        OpenJPAEntityManager em = this.currentEntityManager();
        Broker broker = JPAFacadeHelper.toBroker((EntityManager)em);
        return broker.getConfiguration().newMetaDataRepositoryInstance();
    }

    public void testClassDefaults() {
        TestClassMetaData.assertEquals((String)MetaTest1.class.getName(), (String)this._metaTest1.getDescribedType().getName());
        TestClassMetaData.assertNull((Object)this._metaTest1.getPCSuperclass());
        TestClassMetaData.assertEquals((int)1, (int)this._metaTest1.getIdentityType());
        TestClassMetaData.assertTrue((boolean)this._metaTest1.getRequiresExtent());
    }

    public void testGetProxyFields() {
        FieldMetaData[] proxies = this._metaTest3.getProxyFields();
        TestClassMetaData.assertEquals((int)2, (int)proxies.length);
        proxies = this._metaTest1.getProxyFields();
        TestClassMetaData.assertEquals((int)2, (int)proxies.length);
        proxies = this._metaTest5.getProxyFields();
        TestClassMetaData.assertEquals((int)0, (int)proxies.length);
    }

    public void testDefaultNonPersistentFields() {
        TestClassMetaData.assertNull((Object)this._metaTest1.getField("staticField"));
        TestClassMetaData.assertNull((Object)this._metaTest1.getField("finalfield"));
        TestClassMetaData.assertNull((Object)this._metaTest1.getField("transientfield"));
        TestClassMetaData.assertNull((Object)this._metaTest1.getField("metaTest4Field"));
        TestClassMetaData.assertNull((Object)this._metaTest1.getField("metaTest4ArrayField"));
        TestClassMetaData.assertNull((Object)this._metaTest1.getField("objectField"));
        TestClassMetaData.assertNull((Object)this._metaTest1.getField("longWrapperField"));
        FieldMetaData fmd = this._metaTest1.getField("doubleField");
        TestClassMetaData.assertEquals((int)1, (int)fmd.getManagement());
    }

    public void testBasicFields() {
        FieldMetaData fmd = this._metaTest1.getField("stringField");
        TestClassMetaData.assertEquals((int)9, (int)fmd.getTypeCode());
        TestClassMetaData.assertEquals((int)9, (int)fmd.getDeclaredTypeCode());
        TestClassMetaData.assertNull((Object)fmd.getTypeMetaData());
        TestClassMetaData.assertNull((Object)fmd.getDeclaredTypeMetaData());
        fmd = this._metaTest1.getField("intWrapperField");
        TestClassMetaData.assertEquals((int)21, (int)fmd.getTypeCode());
        TestClassMetaData.assertEquals((int)21, (int)fmd.getDeclaredTypeCode());
        fmd = this._metaTest1.getField("intField");
        TestClassMetaData.assertEquals((int)5, (int)fmd.getTypeCode());
        TestClassMetaData.assertEquals((int)5, (int)fmd.getDeclaredTypeCode());
        fmd = this._metaTest1.getField("metaTest2Field");
        TestClassMetaData.assertEquals((int)15, (int)fmd.getTypeCode());
        TestClassMetaData.assertEquals((int)15, (int)fmd.getDeclaredTypeCode());
        TestClassMetaData.assertEquals((Object)this._metaTest2, (Object)fmd.getTypeMetaData());
        TestClassMetaData.assertEquals((Object)this._metaTest2, (Object)fmd.getDeclaredTypeMetaData());
        fmd = this._metaTest1.getField("metaTest2ArrayField");
        TestClassMetaData.assertEquals((int)11, (int)fmd.getTypeCode());
        TestClassMetaData.assertEquals((int)15, (int)fmd.getElement().getTypeCode());
        TestClassMetaData.assertEquals((int)11, (int)fmd.getDeclaredTypeCode());
        TestClassMetaData.assertEquals((int)15, (int)fmd.getElement().getDeclaredTypeCode());
        fmd = this._metaTest1.getField("intArrayField");
        TestClassMetaData.assertEquals((int)11, (int)fmd.getTypeCode());
        TestClassMetaData.assertEquals((int)5, (int)fmd.getElement().getTypeCode());
        TestClassMetaData.assertEquals((int)11, (int)fmd.getDeclaredTypeCode());
        TestClassMetaData.assertEquals((int)5, (int)fmd.getElement().getDeclaredTypeCode());
        fmd = this._metaTest1.getField("intField");
        TestClassMetaData.assertEquals((int)2, (int)fmd.getNullValue());
        TestClassMetaData.assertTrue((!fmd.isInDefaultFetchGroup() ? 1 : 0) != 0);
        TestClassMetaData.assertTrue((!fmd.isEmbedded() ? 1 : 0) != 0);
        fmd = this._metaTest1.getField("stringField");
        TestClassMetaData.assertEquals((int)-1, (int)fmd.getNullValue());
        TestClassMetaData.assertTrue((boolean)fmd.isInDefaultFetchGroup());
        TestClassMetaData.assertTrue((boolean)fmd.isEmbedded());
    }

    public void testCollectionFields() {
        FieldMetaData fmd = this._metaTest2.getField("collectionField1");
        TestClassMetaData.assertEquals((int)12, (int)fmd.getTypeCode());
        TestClassMetaData.assertEquals((int)8, (int)fmd.getElement().getTypeCode());
        TestClassMetaData.assertEquals(Object.class, (Object)fmd.getElement().getType());
        TestClassMetaData.assertNull((Object)fmd.getElement().getTypeMetaData());
        TestClassMetaData.assertEquals((int)12, (int)fmd.getDeclaredTypeCode());
        TestClassMetaData.assertEquals((int)8, (int)fmd.getElement().getDeclaredTypeCode());
        TestClassMetaData.assertEquals(Object.class, (Object)fmd.getElement().getDeclaredType());
        TestClassMetaData.assertNull((Object)fmd.getElement().getTypeMetaData());
        TestClassMetaData.assertTrue((boolean)fmd.getElement().isEmbedded());
        fmd = this._metaTest2.getField("collectionField2");
        TestClassMetaData.assertEquals((int)12, (int)fmd.getTypeCode());
        TestClassMetaData.assertEquals((int)15, (int)fmd.getElement().getTypeCode());
        TestClassMetaData.assertEquals(MetaTest3.class, (Object)fmd.getElement().getType());
        TestClassMetaData.assertEquals((Object)this._metaTest3, (Object)fmd.getElement().getTypeMetaData());
        TestClassMetaData.assertEquals((int)12, (int)fmd.getDeclaredTypeCode());
        TestClassMetaData.assertEquals((int)15, (int)fmd.getElement().getDeclaredTypeCode());
        TestClassMetaData.assertEquals(MetaTest3.class, (Object)fmd.getElement().getDeclaredType());
        TestClassMetaData.assertEquals((Object)this._metaTest3, (Object)fmd.getElement().getDeclaredTypeMetaData());
        TestClassMetaData.assertTrue((!fmd.getElement().isEmbedded() ? 1 : 0) != 0);
        fmd = this._metaTest2.getField("mapField1");
        TestClassMetaData.assertEquals((int)13, (int)fmd.getTypeCode());
        TestClassMetaData.assertEquals((int)8, (int)fmd.getKey().getTypeCode());
        TestClassMetaData.assertEquals((int)8, (int)fmd.getElement().getTypeCode());
        TestClassMetaData.assertEquals(Object.class, (Object)fmd.getKey().getType());
        TestClassMetaData.assertNull((Object)fmd.getKey().getTypeMetaData());
        TestClassMetaData.assertEquals(Object.class, (Object)fmd.getElement().getType());
        TestClassMetaData.assertEquals((int)13, (int)fmd.getDeclaredTypeCode());
        TestClassMetaData.assertEquals((int)8, (int)fmd.getKey().getDeclaredTypeCode());
        TestClassMetaData.assertEquals((int)8, (int)fmd.getElement().getDeclaredTypeCode());
        TestClassMetaData.assertEquals(Object.class, (Object)fmd.getKey().getDeclaredType());
        TestClassMetaData.assertNull((Object)fmd.getKey().getDeclaredTypeMetaData());
        TestClassMetaData.assertEquals(Object.class, (Object)fmd.getElement().getDeclaredType());
        TestClassMetaData.assertTrue((boolean)fmd.getKey().isEmbedded());
        TestClassMetaData.assertTrue((boolean)fmd.getElement().isEmbedded());
        fmd = this._metaTest2.getField("mapField2");
        TestClassMetaData.assertEquals((int)13, (int)fmd.getTypeCode());
        TestClassMetaData.assertEquals((int)9, (int)fmd.getKey().getTypeCode());
        TestClassMetaData.assertEquals((int)21, (int)fmd.getElement().getTypeCode());
        TestClassMetaData.assertEquals(String.class, (Object)fmd.getKey().getType());
        TestClassMetaData.assertEquals(Integer.class, (Object)fmd.getElement().getType());
        TestClassMetaData.assertEquals((int)13, (int)fmd.getDeclaredTypeCode());
        TestClassMetaData.assertEquals((int)9, (int)fmd.getKey().getDeclaredTypeCode());
        TestClassMetaData.assertEquals((int)21, (int)fmd.getElement().getDeclaredTypeCode());
        TestClassMetaData.assertEquals(String.class, (Object)fmd.getKey().getDeclaredType());
        TestClassMetaData.assertEquals(Integer.class, (Object)fmd.getElement().getDeclaredType());
        TestClassMetaData.assertTrue((boolean)fmd.getKey().isEmbedded());
        TestClassMetaData.assertTrue((!fmd.getElement().isEmbedded() ? 1 : 0) != 0);
    }

    public void testBasicClass() {
        TestClassMetaData.assertEquals((Object)this._metaTest1, (Object)this._metaTest2.getPCSuperclassMetaData());
        TestClassMetaData.assertTrue((!this._metaTest2.getRequiresExtent() ? 1 : 0) != 0);
    }

    public void testApplicationIdentity() {
        TestClassMetaData.assertEquals((int)2, (int)this._metaTest5.getIdentityType());
        TestClassMetaData.assertEquals((String)MetaTest5.MetaTest5Id.class.getName(), (String)this._metaTest5.getObjectIdType().getName());
        TestClassMetaData.assertEquals((int)2, (int)this._metaTest6.getIdentityType());
        TestClassMetaData.assertEquals((String)MetaTest5.MetaTest5Id.class.getName(), (String)this._metaTest6.getObjectIdType().getName());
    }

    public void testAbsoluteFieldNumbering() {
        TestClassMetaData.assertEquals((int)0, (int)this._metaTest1.getField("doubleField").getIndex());
        TestClassMetaData.assertEquals((int)1, (int)this._metaTest1.getField("intArrayField").getIndex());
        TestClassMetaData.assertEquals((int)2, (int)this._metaTest1.getField("intField").getIndex());
        TestClassMetaData.assertEquals((int)3, (int)this._metaTest1.getField("intWrapperField").getIndex());
        TestClassMetaData.assertEquals((int)4, (int)this._metaTest1.getField("metaTest2ArrayField").getIndex());
        TestClassMetaData.assertEquals((int)5, (int)this._metaTest1.getField("metaTest2Field").getIndex());
        TestClassMetaData.assertEquals((int)6, (int)this._metaTest1.getField("stringField").getIndex());
        TestClassMetaData.assertEquals((int)7, (int)this._metaTest2.getField("collectionField1").getIndex());
        TestClassMetaData.assertEquals((int)8, (int)this._metaTest2.getField("collectionField2").getIndex());
        TestClassMetaData.assertEquals((int)9, (int)this._metaTest2.getField("mapField1").getIndex());
        TestClassMetaData.assertEquals((int)10, (int)this._metaTest2.getField("mapField2").getIndex());
    }

    public void testGetFields() {
        FieldMetaData[] fmds = this._metaTest2.getFields();
        TestClassMetaData.assertEquals((String)"doubleField", (String)fmds[0].getName());
        TestClassMetaData.assertEquals((String)"intField", (String)fmds[2].getName());
        TestClassMetaData.assertEquals((String)"collectionField2", (String)fmds[8].getName());
    }

    public void testStaticInnerClasses() {
        TestClassMetaData.assertNotNull((Object)this._repos.getMetaData(MetaTest1.Inner.class, null, true));
    }

    public void testExternalTypes() {
        FieldMetaData fmd = this._metaTest3.getField("pcField");
        TestClassMetaData.assertEquals((int)27, (int)fmd.getTypeCode());
        TestClassMetaData.assertEquals((int)27, (int)fmd.getDeclaredTypeCode());
        TestClassMetaData.assertEquals(PersistenceCapable.class, (Object)fmd.getType());
        TestClassMetaData.assertEquals(Object.class, (Object)fmd.getDeclaredType());
        TestClassMetaData.assertNull((Object)fmd.getDeclaredTypeMetaData());
        TestClassMetaData.assertNull((Object)fmd.getTypeMetaData());
        fmd = this._metaTest3.getField("metaField");
        TestClassMetaData.assertEquals((int)15, (int)fmd.getTypeCode());
        TestClassMetaData.assertEquals((int)15, (int)fmd.getDeclaredTypeCode());
        TestClassMetaData.assertEquals(MetaTest2.class, (Object)fmd.getType());
        TestClassMetaData.assertEquals(Object.class, (Object)fmd.getDeclaredType());
        TestClassMetaData.assertEquals((Object)this._metaTest2, (Object)fmd.getDeclaredTypeMetaData());
        TestClassMetaData.assertEquals((Object)this._metaTest2, (Object)fmd.getTypeMetaData());
        fmd = this._metaTest3.getField("externalField");
        TestClassMetaData.assertTrue((boolean)fmd.isExternalized());
        TestClassMetaData.assertEquals((int)13, (int)fmd.getTypeCode());
        TestClassMetaData.assertEquals((int)8, (int)fmd.getDeclaredTypeCode());
        TestClassMetaData.assertEquals(Map.class, (Object)fmd.getType());
        TestClassMetaData.assertEquals(Object.class, (Object)fmd.getDeclaredType());
        TestClassMetaData.assertEquals((int)9, (int)fmd.getKey().getTypeCode());
        TestClassMetaData.assertEquals((int)8, (int)fmd.getKey().getDeclaredTypeCode());
        TestClassMetaData.assertEquals(String.class, (Object)fmd.getKey().getType());
        TestClassMetaData.assertEquals(Object.class, (Object)fmd.getKey().getDeclaredType());
        TestClassMetaData.assertEquals((int)15, (int)fmd.getElement().getTypeCode());
        TestClassMetaData.assertEquals((int)8, (int)fmd.getElement().getDeclaredTypeCode());
        TestClassMetaData.assertEquals(MetaTest2.class, (Object)fmd.getElement().getType());
        TestClassMetaData.assertEquals(Object.class, (Object)fmd.getElement().getDeclaredType());
        TestClassMetaData.assertEquals((Object)this._metaTest2, (Object)fmd.getElement().getTypeMetaData());
        TestClassMetaData.assertNull((Object)fmd.getElement().getDeclaredTypeMetaData());
    }
}

