/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.meta.common.apps.MetaTest7;

public class TestFactoryMethod
extends AbstractTestCase {
    private MetaDataRepository _repos = null;
    private ClassMetaData _metaTest7 = null;

    public TestFactoryMethod(String test) {
        super(test, "metacactusapp");
    }

    public void setUp() throws Exception {
        this._repos = this.getRepository();
        this._metaTest7 = this._repos.getMetaData(MetaTest7.class, null, true);
    }

    protected MetaDataRepository getRepository() throws Exception {
        OpenJPAEntityManager em = this.currentEntityManager();
        Broker broker = JPAFacadeHelper.toBroker((EntityManager)em);
        return broker.getConfiguration().newMetaDataRepositoryInstance();
    }

    public void testFactoryMatchesByType() {
        FieldMetaData fieldMetaData = this._metaTest7.getField("status");
        Member factoryMember = fieldMetaData.getFactoryMethod();
        TestFactoryMethod.assertEquals((String)"valueOf", (String)factoryMember.getName());
        Method factoryMethod = (Method)factoryMember;
        Class<?>[] parameterTypes = factoryMethod.getParameterTypes();
        TestFactoryMethod.assertEquals((String)"Both valueOf methods take just 1 parameter", (int)1, (int)parameterTypes.length);
        TestFactoryMethod.assertEquals((String)"Need to match the type of the underlying field or the factory method will fail when called", String.class, parameterTypes[0]);
    }

    public void testFactoryMatchesByTypeWidening() {
        FieldMetaData fieldMetaData = this._metaTest7.getField("intLongStatus");
        Member factoryMember = fieldMetaData.getFactoryMethod();
        TestFactoryMethod.assertEquals((String)"valueOf", (String)factoryMember.getName());
        Method factoryMethod = (Method)factoryMember;
        Class<?>[] parameterTypes = factoryMethod.getParameterTypes();
        TestFactoryMethod.assertEquals((String)"Both valueOf methods take just 1 parameter", (int)1, (int)parameterTypes.length);
        TestFactoryMethod.assertEquals((String)"Need to match the type of the underlying field or the factory method will fail when called", Long.TYPE, parameterTypes[0]);
    }

    public void testFactoryMatchesByTypeBoxing() {
        FieldMetaData fieldMetaData = this._metaTest7.getField("intIntegerStatus");
        Member factoryMember = fieldMetaData.getFactoryMethod();
        TestFactoryMethod.assertEquals((String)"valueOf", (String)factoryMember.getName());
        Method factoryMethod = (Method)factoryMember;
        Class<?>[] parameterTypes = factoryMethod.getParameterTypes();
        TestFactoryMethod.assertEquals((String)"Both valueOf methods take just 1 parameter", (int)1, (int)parameterTypes.length);
        TestFactoryMethod.assertEquals((String)"Need to match the type of the underlying field or the factory method will fail when called", Integer.class, parameterTypes[0]);
    }

    public void testFactoryMatchesByTypeWrapper() {
        FieldMetaData fieldMetaData = this._metaTest7.getField("integerIntegerStatus");
        Member factoryMember = fieldMetaData.getFactoryMethod();
        TestFactoryMethod.assertEquals((String)"valueOf", (String)factoryMember.getName());
        Method factoryMethod = (Method)factoryMember;
        Class<?>[] parameterTypes = factoryMethod.getParameterTypes();
        TestFactoryMethod.assertEquals((String)"Both valueOf methods take just 1 parameter", (int)1, (int)parameterTypes.length);
        TestFactoryMethod.assertEquals((String)"Need to match the type of the underlying field or the factory method will fail when called", Integer.class, parameterTypes[0]);
    }

    public void testFactoryMatchesByTypeUnboxing() {
        FieldMetaData fieldMetaData = this._metaTest7.getField("integerIntStatus");
        Member factoryMember = fieldMetaData.getFactoryMethod();
        TestFactoryMethod.assertEquals((String)"valueOf", (String)factoryMember.getName());
        Method factoryMethod = (Method)factoryMember;
        Class<?>[] parameterTypes = factoryMethod.getParameterTypes();
        TestFactoryMethod.assertEquals((String)"Both valueOf methods take just 1 parameter", (int)1, (int)parameterTypes.length);
        TestFactoryMethod.assertEquals((String)"Need to match the type of the underlying field or the factory method will fail when called", Integer.TYPE, parameterTypes[0]);
    }

    public void testFactoryMatchesByTypeUnboxingWidening() {
        FieldMetaData fieldMetaData = this._metaTest7.getField("integerLongStatus");
        Member factoryMember = fieldMetaData.getFactoryMethod();
        TestFactoryMethod.assertEquals((String)"valueOf", (String)factoryMember.getName());
        Method factoryMethod = (Method)factoryMember;
        Class<?>[] parameterTypes = factoryMethod.getParameterTypes();
        TestFactoryMethod.assertEquals((String)"Both valueOf methods take just 1 parameter", (int)1, (int)parameterTypes.length);
        TestFactoryMethod.assertEquals((String)"Need to match the type of the underlying field or the factory method will fail when called", Long.TYPE, parameterTypes[0]);
    }
}

