/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.meta.common.apps.OrderByPC;
import org.apache.openjpa.persistence.meta.common.apps.OrderByPCRel;
import org.apache.openjpa.persistence.meta.common.apps.OrderByPCRelSub;

public class TestOrderBy
extends AbstractTestCase {
    public TestOrderBy(String test) {
        super(test, "metacactusapp");
    }

    public void setUp() {
        this.deleteAll(OrderByPCRel.class);
        this.deleteAll(OrderByPC.class);
    }

    public void testStringList() {
        this.stringListTest(false, false);
    }

    public void testEagerParallelStringList() {
        this.stringListTest(true, true);
    }

    public void testEagerJoinStringList() {
        this.stringListTest(true, false);
    }

    private void stringListTest(boolean eager, boolean parallel) {
        String[] strs = new String[]{"9", "0", "5", "1", "3", "7", "8", "2", "6", "4"};
        OrderByPC pc = new OrderByPC();
        pc.setId(1L);
        pc.getStringListAsc().addAll(Arrays.asList(strs));
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)pc);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        if (eager) {
            pm.getFetchPlan().addField(OrderByPC.class, "stringListAsc");
        }
        if (parallel) {
            OpenJPAQuery q = pm.createQuery("select a FROM " + OrderByPC.class.getSimpleName());
            List res = q.getResultList();
            TestOrderBy.assertEquals((int)1, (int)res.size());
            pc = (OrderByPC)res.get(0);
        } else {
            pc = (OrderByPC)pm.find(OrderByPC.class, oid);
        }
        List stringList = pc.getStringListAsc();
        for (int i = 0; i < 10; ++i) {
            TestOrderBy.assertEquals((Object)String.valueOf(i), stringList.get(i));
        }
        this.endEm((EntityManager)pm);
    }

    public void testIntArray() {
        int[] ints = new int[]{9, 0, 5, 1, 3, 7, 8, 2, 6, 4};
        OrderByPC pc = new OrderByPC();
        pc.setId(1L);
        pc.setIntArrayDesc(ints);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)pc);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        pc = (OrderByPC)pm.find(OrderByPC.class, oid);
        int[] intArray = pc.getIntArrayDesc();
        for (int i = 0; i < 10; ++i) {
            TestOrderBy.assertEquals((int)(9 - i), (int)intArray[i]);
        }
        this.endEm((EntityManager)pm);
    }

    public void testOrderByPK() {
        this.orderByPKTest(false, false, false);
    }

    public void testEagerJoinOrderByPK() {
        this.orderByPKTest(true, false, false);
    }

    public void testEagerParallelOrderByPK() {
        this.orderByPKTest(true, true, false);
    }

    public void testOneToManyOrderByPK() {
        this.orderByPKTest(false, false, true);
    }

    public void testEagerJoinOneToManyOrderByPK() {
        this.orderByPKTest(true, false, true);
    }

    public void testEagerParallelOneToManyOrderByPK() {
        this.orderByPKTest(true, true, true);
    }

    private void orderByPKTest(boolean eager, boolean parallel, boolean oneToMany) {
        long[] ids = new long[]{9L, 0L, 5L, 1L, 3L, 7L, 8L, 2L, 6L, 4L};
        OrderByPC pc = new OrderByPC();
        pc.setId(1L);
        OrderByPC pc2 = new OrderByPC();
        pc2.setId(2L);
        for (int i = 0; i < ids.length; ++i) {
            OrderByPCRel rel = i % 2 == 0 ? new OrderByPCRel() : new OrderByPCRelSub();
            rel.setId(ids[i]);
            if (oneToMany) {
                pc.getOneToManyAsc().add(rel);
                rel.setToOne(pc);
            } else {
                pc.getOrderByPKAsc().add(rel);
            }
            if (!parallel) continue;
            pc2.getOrderByPKAsc().add(rel);
        }
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        pm.persist((Object)pc2);
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)pc);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        if (eager) {
            pm.getFetchPlan().addField(OrderByPC.class, "orderByPKAsc");
        }
        if (parallel) {
            OpenJPAQuery q = pm.createQuery("select a FROM " + OrderByPC.class.getSimpleName() + " select order by id asc");
            pc = (OrderByPC)q.getResultList().get(0);
            q.closeAll();
        } else {
            pc = (OrderByPC)pm.find(OrderByPC.class, oid);
        }
        List orderByPK = oneToMany ? pc.getOneToManyAsc() : pc.getOrderByPKAsc();
        for (int i = 0; i < 10; ++i) {
            TestOrderBy.assertEquals((long)i, (long)((OrderByPCRel)orderByPK.get(i)).getId());
        }
        this.endEm((EntityManager)pm);
    }

    public void testOrderByRelatedField() {
        String[] strs = new String[]{"9", "0", "5", "1", "3", "7", "8", "2", "6", "4"};
        OrderByPC pc = new OrderByPC();
        pc.setId(1L);
        for (int i = 0; i < strs.length; ++i) {
            OrderByPCRel rel = i % 2 == 0 ? new OrderByPCRel() : new OrderByPCRelSub();
            rel.setId(i);
            rel.setString(strs[i]);
            pc.getOrderByStringDesc().add(rel);
        }
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)pc);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        pc = (OrderByPC)pm.find(OrderByPC.class, oid);
        List orderByRelField = pc.getOrderByStringDesc();
        for (int i = 0; i < 10; ++i) {
            TestOrderBy.assertEquals((String)String.valueOf(9 - i), (String)((OrderByPCRel)orderByRelField.get(i)).getString());
        }
        this.endEm((EntityManager)pm);
    }

    public void testOrderByPKAndRelatedField() {
        this.orderByPKAndRelatedFieldTest(false, false);
    }

    public void testEagerJoinOrderByPKAndRelatedField() {
        this.orderByPKAndRelatedFieldTest(true, false);
    }

    public void testEagerParallelOrderByPKAndRelatedField() {
        this.orderByPKAndRelatedFieldTest(true, true);
    }

    private void orderByPKAndRelatedFieldTest(boolean eager, boolean parallel) {
        OrderByPC pc = new OrderByPC();
        pc.setId(1L);
        OrderByPC pc2 = new OrderByPC();
        pc.setId(2L);
        OrderByPCRel rel1 = new OrderByPCRel();
        rel1.setId(1L);
        rel1.setString("1");
        OrderByPCRelSub rel2 = new OrderByPCRelSub();
        rel2.setId(2L);
        rel2.setString("1");
        OrderByPCRel rel3 = new OrderByPCRel();
        rel3.setId(3L);
        rel3.setString("2");
        OrderByPCRelSub rel4 = new OrderByPCRelSub();
        rel4.setId(4L);
        rel4.setString("2");
        pc.getOrderByStringAndPKDesc().addAll(Arrays.asList(rel1, rel2, rel4, rel3));
        if (parallel) {
            pc2.getOrderByStringAndPKDesc().addAll(Arrays.asList(rel1, rel2, rel4, rel3));
        }
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        pm.persist((Object)pc2);
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)pc);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        if (eager) {
            pm.getFetchPlan().addField(OrderByPC.class, "orderByStringAndPKDesc");
        }
        if (parallel) {
            OpenJPAQuery q = pm.createQuery("select a FROM " + OrderByPC.class.getSimpleName() + " select order by id asc");
            pc = (OrderByPC)q.getResultList().get(0);
            q.closeAll();
        } else {
            pc = (OrderByPC)pm.find(OrderByPC.class, oid);
        }
        List multiOrder = pc.getOrderByStringAndPKDesc();
        for (int i = 0; i < 4; ++i) {
            TestOrderBy.assertEquals((long)(4 - i), (long)((OrderByPCRel)multiOrder.get(i)).getId());
        }
        this.endEm((EntityManager)pm);
    }
}

