/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import java.util.ArrayList;
import java.util.HashSet;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.meta.MdrTestEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestQueryTypeAliasRegistration
extends SingleEMFTestCase {
    private final int threads = 100;

    @Override
    public void setUp() throws Exception {
        super.setUp(MdrTestEntity.class);
        TestQueryTypeAliasRegistration.assertNotNull((Object)this.emf);
        new MdrTestEntity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiThreadGetMetaDataAlias() throws Exception {
        try {
            ArrayList<Worker> workers = new ArrayList<Worker>();
            HashSet<Exception> exceptions = new HashSet<Exception>();
            for (int i = 0; i < 100; ++i) {
                Worker w = new Worker((EntityManagerFactory)this.emf);
                workers.add(w);
            }
            for (Worker w : workers) {
                w.start();
            }
            for (Worker w : workers) {
                w.join();
                Exception e = w.getException();
                if (e == null) continue;
                exceptions.add(w.getException());
            }
            TestQueryTypeAliasRegistration.assertTrue((String)("Caught " + ((Object)exceptions).toString()), (exceptions.size() == 0 ? 1 : 0) != 0);
        }
        finally {
            if (this.emf != null) {
                this.emf.close();
            }
        }
    }

    class Worker
    extends Thread {
        OpenJPAEntityManagerFactorySPI emf;
        OpenJPAEntityManagerSPI em;
        MetaDataRepository repo;
        Exception ex;

        Worker(EntityManagerFactory e) {
            this.emf = (OpenJPAEntityManagerFactorySPI)e;
            this.em = this.emf.createEntityManager();
            this.repo = this.em.getConfiguration().getMetaDataRepositoryInstance();
        }

        Exception getException() {
            return this.ex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.repo.getMetaData("MdrTestEntity", Thread.currentThread().getContextClassLoader(), true);
            }
            catch (Exception e) {
                this.ex = e;
                e.printStackTrace();
            }
            finally {
                this.em.close();
            }
        }
    }
}

