/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.meta.common.apps.SequenceAssigned;
import org.apache.openjpa.persistence.meta.common.apps.SequenceAssigned2;
import org.apache.openjpa.persistence.meta.common.apps.SequenceAssigned3;

public class TestSequenceAssigned
extends AbstractTestCase {
    public TestSequenceAssigned(String testName) {
        super(testName, "metacactusapp");
    }

    public void setUp() {
        this.deleteAll(SequenceAssigned.class);
        this.deleteAll(SequenceAssigned3.class);
    }

    public void testGetObjectId() {
        SequenceAssigned pc = new SequenceAssigned();
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        SequenceAssigned.Id id = (SequenceAssigned.Id)pm.getObjectId((Object)pc);
        TestSequenceAssigned.assertTrue((0L != id.pk ? 1 : 0) != 0);
        TestSequenceAssigned.assertTrue((0L != pc.getPK() ? 1 : 0) != 0);
        TestSequenceAssigned.assertEquals((long)pc.getPK(), (long)id.pk);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testGetValue() {
        SequenceAssigned pc = new SequenceAssigned();
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        TestSequenceAssigned.assertEquals((long)0L, (long)pc.getPK());
        pm.persist((Object)pc);
        TestSequenceAssigned.assertTrue((0L != pc.getPK() ? 1 : 0) != 0);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testPrimitive() {
        SequenceAssigned pc = new SequenceAssigned();
        SequenceAssigned pc2 = new SequenceAssigned();
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        pm.persist((Object)pc2);
        pm.flush();
        TestSequenceAssigned.assertTrue((0L != pc.getPK() ? 1 : 0) != 0);
        TestSequenceAssigned.assertTrue((0L != pc2.getPK() ? 1 : 0) != 0);
        TestSequenceAssigned.assertTrue((pc.getPK() != pc2.getPK() ? 1 : 0) != 0);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testManualAssign() {
        SequenceAssigned pc = new SequenceAssigned();
        SequenceAssigned3 pc2 = new SequenceAssigned3();
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pc.setPK(-100L);
        pc2.setPK(new Long(-100L));
        pm.persist((Object)pc);
        pm.persist((Object)pc2);
        pm.flush();
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)pc);
        Object oid2 = pm.getObjectId((Object)pc2);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        pc = (SequenceAssigned)pm.find(SequenceAssigned.class, oid);
        pc2 = (SequenceAssigned3)pm.find(SequenceAssigned3.class, oid2);
        TestSequenceAssigned.assertEquals((long)-100L, (long)pc.getPK());
        TestSequenceAssigned.assertEquals((Object)new Long(-100L), (Object)pc2.getPK());
        this.endEm((EntityManager)pm);
    }

    public void testInheritance() {
        SequenceAssigned2 pc = new SequenceAssigned2();
        SequenceAssigned2 pc2 = new SequenceAssigned2();
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        pm.persist((Object)pc2);
        pm.flush();
        TestSequenceAssigned.assertTrue((0L != pc.getPK() ? 1 : 0) != 0);
        TestSequenceAssigned.assertTrue((0L != pc2.getPK() ? 1 : 0) != 0);
        TestSequenceAssigned.assertTrue((pc.getPK() != pc2.getPK() ? 1 : 0) != 0);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testWrapper() {
        SequenceAssigned3 pc = new SequenceAssigned3();
        SequenceAssigned3 pc2 = new SequenceAssigned3();
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        pm.persist((Object)pc2);
        pm.flush();
        TestSequenceAssigned.assertNotNull((Object)pc.getPK());
        TestSequenceAssigned.assertNotNull((Object)pc2.getPK());
        TestSequenceAssigned.assertTrue((0L != pc.getPK() ? 1 : 0) != 0);
        TestSequenceAssigned.assertTrue((0L != pc2.getPK() ? 1 : 0) != 0);
        TestSequenceAssigned.assertNotEquals(pc.getPK(), pc2.getPK());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testGetObjectById() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        SequenceAssigned pc = new SequenceAssigned();
        pm.persist((Object)pc);
        Object oid = pm.getObjectId((Object)pc);
        TestSequenceAssigned.assertTrue((0L != ((SequenceAssigned.Id)oid).pk ? 1 : 0) != 0);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        pm.find(SequenceAssigned.class, oid);
        this.endEm((EntityManager)pm);
    }

    public void testReachability() {
        SequenceAssigned pc = new SequenceAssigned();
        SequenceAssigned pc2 = new SequenceAssigned();
        pc.setOther(pc2);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        this.endTx((EntityManager)pm);
        SequenceAssigned.Id id = (SequenceAssigned.Id)pm.getObjectId((Object)pc2);
        TestSequenceAssigned.assertTrue((0L != id.pk ? 1 : 0) != 0);
        TestSequenceAssigned.assertTrue((0L != pc2.getPK() ? 1 : 0) != 0);
        TestSequenceAssigned.assertEquals((long)pc2.getPK(), (long)id.pk);
        this.endEm((EntityManager)pm);
    }
}

