/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.models.library;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.models.library.Book;
import org.apache.openjpa.persistence.models.library.Volunteer;
import org.apache.openjpa.util.IntId;
import org.apache.openjpa.util.InternalException;

@Entity
@Table(name="LIBBORROWER")
public class Borrower
implements PersistenceCapable {
    @Id
    @GeneratedValue
    private int oid;
    @Basic
    private String name;
    @OneToMany(mappedBy="borrower", fetch=FetchType.EAGER)
    private Set<Book> books;
    @OneToOne(mappedBy="borrower", cascade={CascadeType.PERSIST, CascadeType.REMOVE})
    private Volunteer volunteer;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$util$Set;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$models$library$Volunteer;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$models$library$Borrower;
    private transient Object pcDetachedState;

    protected Borrower() {
    }

    public Borrower(String name) {
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.length() <= 0) {
            throw new IllegalArgumentException("name cannot be empty or null");
        }
        this.name = name;
        this.books = new HashSet<Book>();
    }

    public String getName() {
        return Borrower.pcGetname(this);
    }

    public List<Book> getBooks() {
        if (Borrower.pcGetbooks(this) == null) {
            return null;
        }
        return new ArrayList<Book>(Borrower.pcGetbooks(this));
    }

    public void borrowBook(Book book) {
        if (book == null) {
            return;
        }
        Borrower.pcGetbooks(this).add(book);
        book.setBorrower(this);
    }

    public void returnBook(Book book) {
        if (book == null) {
            return;
        }
        Borrower.pcGetbooks(this).remove(book);
        book.clearBorrower();
    }

    void setVolunteer(Volunteer volunteer) {
        Borrower.pcSetvolunteer(this, volunteer);
    }

    public Volunteer getVolunteer() {
        return Borrower.pcGetvolunteer(this);
    }

    public String toString() {
        return "borrower [" + Borrower.pcGetoid(this) + "] " + Borrower.pcGetname(this);
    }

    public int hashCode() {
        return Borrower.pcGetoid(this);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (Borrower.pcGetoid(this) == 0) {
            return false;
        }
        if (other instanceof Borrower) {
            Borrower ob = (Borrower)other;
            return Borrower.pcGetoid(this) == Borrower.pcGetoid(ob);
        }
        return false;
    }

    public int pcGetEnhancementContractVersion() {
        return 1674154;
    }

    static {
        pcFieldNames = new String[]{"books", "name", "oid", "volunteer"};
        Class[] classArray = new Class[4];
        Class clazz = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = Borrower.class$("java.util.Set"));
        classArray[0] = clazz;
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Borrower.class$("java.lang.String"));
        classArray[1] = clazz2;
        classArray[2] = Integer.TYPE;
        Class clazz3 = class$Lorg$apache$openjpa$persistence$models$library$Volunteer != null ? class$Lorg$apache$openjpa$persistence$models$library$Volunteer : (class$Lorg$apache$openjpa$persistence$models$library$Volunteer = Borrower.class$("org.apache.openjpa.persistence.models.library.Volunteer"));
        classArray[3] = clazz3;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{10, 26, 26, 10};
        Class clazz4 = class$Lorg$apache$openjpa$persistence$models$library$Borrower != null ? class$Lorg$apache$openjpa$persistence$models$library$Borrower : (class$Lorg$apache$openjpa$persistence$models$library$Borrower = Borrower.class$("org.apache.openjpa.persistence.models.library.Borrower"));
        PCRegistry.register((Class)clazz4, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Borrower", (PersistenceCapable)new Borrower());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.books = null;
        this.name = null;
        this.oid = 0;
        this.volunteer = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        Borrower borrower = new Borrower();
        if (bl) {
            borrower.pcClearFields();
        }
        borrower.pcStateManager = stateManager;
        borrower.pcCopyKeyFieldsFromObjectId(object);
        return borrower;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        Borrower borrower = new Borrower();
        if (bl) {
            borrower.pcClearFields();
        }
        borrower.pcStateManager = stateManager;
        return borrower;
    }

    protected static int pcGetManagedFieldCount() {
        return 4;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.books = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.oid = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.volunteer = (Volunteer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.books);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 2: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.oid);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.volunteer);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(Borrower borrower, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.books = borrower.books;
                return;
            }
            case 1: {
                this.name = borrower.name;
                return;
            }
            case 2: {
                this.oid = borrower.oid;
                return;
            }
            case 3: {
                this.volunteer = borrower.volunteer;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        Borrower borrower = (Borrower)object;
        if (borrower.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(borrower, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        IntId intId = (IntId)object;
        fieldConsumer.storeIntField(2 + pcInheritedFieldCount, intId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        IntId intId = (IntId)object;
        this.oid = intId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openjpa$persistence$models$library$Borrower != null ? class$Lorg$apache$openjpa$persistence$models$library$Borrower : (class$Lorg$apache$openjpa$persistence$models$library$Borrower = Borrower.class$("org.apache.openjpa.persistence.models.library.Borrower"));
        return new IntId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openjpa$persistence$models$library$Borrower != null ? class$Lorg$apache$openjpa$persistence$models$library$Borrower : (class$Lorg$apache$openjpa$persistence$models$library$Borrower = Borrower.class$("org.apache.openjpa.persistence.models.library.Borrower"));
        return new IntId(clazz, this.oid);
    }

    private static final Set pcGetbooks(Borrower borrower) {
        if (borrower.pcStateManager == null) {
            return borrower.books;
        }
        int n = pcInheritedFieldCount + 0;
        borrower.pcStateManager.accessingField(n);
        return borrower.books;
    }

    private static final void pcSetbooks(Borrower borrower, Set set) {
        if (borrower.pcStateManager == null) {
            borrower.books = set;
            return;
        }
        borrower.pcStateManager.settingObjectField((PersistenceCapable)borrower, pcInheritedFieldCount + 0, borrower.books, (Object)set, 0);
    }

    private static final String pcGetname(Borrower borrower) {
        if (borrower.pcStateManager == null) {
            return borrower.name;
        }
        int n = pcInheritedFieldCount + 1;
        borrower.pcStateManager.accessingField(n);
        return borrower.name;
    }

    private static final void pcSetname(Borrower borrower, String string) {
        if (borrower.pcStateManager == null) {
            borrower.name = string;
            return;
        }
        borrower.pcStateManager.settingStringField((PersistenceCapable)borrower, pcInheritedFieldCount + 1, borrower.name, string, 0);
    }

    private static final int pcGetoid(Borrower borrower) {
        if (borrower.pcStateManager == null) {
            return borrower.oid;
        }
        int n = pcInheritedFieldCount + 2;
        borrower.pcStateManager.accessingField(n);
        return borrower.oid;
    }

    private static final void pcSetoid(Borrower borrower, int n) {
        if (borrower.pcStateManager == null) {
            borrower.oid = n;
            return;
        }
        borrower.pcStateManager.settingIntField((PersistenceCapable)borrower, pcInheritedFieldCount + 2, borrower.oid, n, 0);
    }

    private static final Volunteer pcGetvolunteer(Borrower borrower) {
        if (borrower.pcStateManager == null) {
            return borrower.volunteer;
        }
        int n = pcInheritedFieldCount + 3;
        borrower.pcStateManager.accessingField(n);
        return borrower.volunteer;
    }

    private static final void pcSetvolunteer(Borrower borrower, Volunteer volunteer) {
        if (borrower.pcStateManager == null) {
            borrower.volunteer = volunteer;
            return;
        }
        borrower.pcStateManager.settingObjectField((PersistenceCapable)borrower, pcInheritedFieldCount + 3, (Object)borrower.volunteer, (Object)volunteer, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.oid != 0) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

