/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.nullity;

import java.util.List;
import javax.persistence.RollbackException;
import javax.persistence.TypedQuery;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.jdbc.sql.SybaseDictionary;
import org.apache.openjpa.persistence.InvalidStateException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.nullity.AbstractNullityTestCase;
import org.apache.openjpa.persistence.nullity.NullValues;

public class TestBasicFieldNullity
extends AbstractNullityTestCase {
    private DBDictionary dict = null;

    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES, "Retain data after test run", NullValues.class);
        this.dict = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
    }

    public void testNullOnOptionalFieldIsAllowed() {
        NullValues pc = new NullValues();
        pc.setOptional(null);
        this.assertCommitSucceeds(pc, NEW);
    }

    public void testNullOnNonOptionalFieldIsDisallowed() {
        NullValues pc = new NullValues();
        pc.setNotOptional(null);
        this.assertCommitFails(pc, NEW, InvalidStateException.class);
    }

    public void testNotNullOnOptionalFieldIsAllowed() {
        NullValues pc = new NullValues();
        this.assertCommitSucceeds(pc, NEW);
    }

    public void testNotNullOnNonOptionalFieldIsAllowed() {
        NullValues pc = new NullValues();
        this.assertCommitSucceeds(pc, NEW);
    }

    public void testNullOnNullableColumnAllowed() {
        NullValues pc = new NullValues();
        pc.setNullable(null);
        this.assertCommitSucceeds(pc, NEW);
    }

    public void testNullOnNonNullableColumnIsDisallowed() {
        NullValues pc = new NullValues();
        pc.setNotNullable(null);
        this.assertCommitFails(pc, NEW, RollbackException.class);
    }

    public void testNotNullOnNullableColumnIsAllowed() {
        NullValues pc = new NullValues();
        this.assertCommitSucceeds(pc, NEW);
    }

    public void testNotNullOnNonNullableColumnIsAllowed() {
        NullValues pc = new NullValues();
        this.assertCommitSucceeds(pc, NEW);
    }

    public void testNullOnOptionalBlobFieldIsAllowed() {
        NullValues pc = new NullValues();
        pc.setOptionalBlob(null);
        this.assertCommitSucceeds(pc, NEW);
    }

    public void testNullOnNonOptionalBlobFieldIsDisallowed() {
        NullValues pc = new NullValues();
        pc.setNotOptionalBlob(null);
        this.assertCommitFails(pc, NEW, InvalidStateException.class);
    }

    public void testNullOnNullableBlobColumnAllowed() {
        NullValues pc = new NullValues();
        pc.setNullableBlob(null);
        this.assertCommitSucceeds(pc, NEW);
    }

    public void testNullOnNonNullableBlobColumnIsDisallowed() {
        NullValues pc = new NullValues();
        pc.setNotNullableBlob(null);
        this.assertCommitFails(pc, NEW, RollbackException.class);
    }

    public void testX() {
        NullValues pc = new NullValues();
        this.assertCommitSucceeds(pc, NEW);
        OpenJPAPersistence.getEntityManager((Object)pc).close();
        pc.setNotNullableBlob(null);
        this.assertCommitFails(pc, !NEW, RollbackException.class);
    }

    public void testUniqueStringColumnCanBeNull() {
        if (!this.isUniqueColumnNullable()) {
            return;
        }
        NullValues pc = new NullValues();
        pc.setUniqueNullable(null);
        this.assertCommitSucceeds(pc, NEW);
    }

    public void testUniqueStringColumnAsNull() {
        if (!this.isUniqueColumnNullable()) {
            return;
        }
        NullValues pc = new NullValues();
        pc.setUniqueNullable(null);
        this.assertCommitSucceeds(pc, NEW);
        String jpql = "select n from NullValues n where n.uniqueNullable = :p";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List result = em.createQuery(jpql, NullValues.class).setParameter("p", null).getResultList();
        TestBasicFieldNullity.assertFalse((boolean)result.isEmpty());
        for (NullValues n : result) {
            TestBasicFieldNullity.assertNull((Object)n.getUniqueNullable());
        }
    }

    public void testUniqueStringColumnAsEmpty() {
        String EMPTY_STRING = "";
        NullValues pc = new NullValues();
        pc.setUniqueNullable(EMPTY_STRING);
        this.assertCommitSucceeds(pc, NEW);
        String jpql = "select n from NullValues n where n.uniqueNullable = :p";
        if (this.dict instanceof OracleDictionary) {
            jpql = "select n from NullValues n where n.uniqueNullable IS NULL";
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TypedQuery query = em.createQuery(jpql, NullValues.class);
        if (!(this.dict instanceof OracleDictionary)) {
            query.setParameter("p", (Object)EMPTY_STRING);
        }
        List result = query.getResultList();
        TestBasicFieldNullity.assertFalse((boolean)result.isEmpty());
        for (NullValues n : result) {
            if (this.dict instanceof OracleDictionary) {
                TestBasicFieldNullity.assertNull((Object)n.getUniqueNullable());
                continue;
            }
            if (this.dict instanceof SybaseDictionary) {
                TestBasicFieldNullity.assertEquals((String)" ", (String)n.getUniqueNullable());
                continue;
            }
            TestBasicFieldNullity.assertEquals((String)EMPTY_STRING, (String)n.getUniqueNullable());
        }
    }

    boolean isUniqueColumnNullable() {
        return ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsNullUniqueColumn;
    }
}

