/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.property;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.property.EmbeddableAddress;
import org.apache.openjpa.persistence.property.EntityContact;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestCompatible
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(EntityContact.class, EmbeddableAddress.class, "openjpa.Compatibility", "PrivatePersistentProperties=true", DROP_TABLES);
    }

    public void testPrivateEmbbeddable() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityContact contactCreate = new EntityContact();
        contactCreate.setId("Contact id");
        contactCreate.setEmail("Contact email address");
        contactCreate.setPhone("Contact phone number");
        contactCreate.setType("HOME");
        EmbeddableAddress address = new EmbeddableAddress();
        address.setLine1("Address line 1");
        address.setLine2("Address line 2");
        address.setCity("Address city");
        address.setState("Address state");
        address.setZipCode("Address zipcode");
        address.setCountry("Address country");
        contactCreate.setAddress(address);
        em.getTransaction().begin();
        em.persist((Object)contactCreate);
        em.getTransaction().commit();
        em.clear();
        em.close();
        em = this.emf.createEntityManager();
        EntityContact contactFind = (EntityContact)em.find(EntityContact.class, (Object)"Contact id");
        TestCompatible.assertTrue((contactFind != null ? 1 : 0) != 0);
        TestCompatible.assertTrue((boolean)contactFind.getId().equals("Contact id"));
        TestCompatible.assertTrue((boolean)contactFind.getEmail().equals("Contact email address"));
        TestCompatible.assertTrue((boolean)contactFind.getPhone().equals("Contact phone number"));
        TestCompatible.assertTrue((boolean)contactFind.getType().equals("HOME"));
        TestCompatible.assertTrue((contactFind.getAddress() != null ? 1 : 0) != 0);
        TestCompatible.assertTrue((boolean)contactFind.getAddress().getLine1().equals("Address line 1"));
        TestCompatible.assertTrue((boolean)contactFind.getAddress().getLine2().equals("Address line 2"));
        TestCompatible.assertTrue((boolean)contactFind.getAddress().getCity().equals("Address city"));
        TestCompatible.assertTrue((boolean)contactFind.getAddress().getState().equals("Address state"));
        TestCompatible.assertTrue((boolean)contactFind.getAddress().getZipCode().equals("Address zipcode"));
        TestCompatible.assertTrue((boolean)contactFind.getAddress().getCountry().equals("Address country"));
        em.getTransaction().begin();
        em.remove((Object)contactFind);
        em.getTransaction().commit();
        em.clear();
        em.close();
    }
}

