/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.proxy;

import java.util.UUID;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.proxy.entities.Address;
import org.apache.openjpa.persistence.proxy.entities.Annuity;
import org.apache.openjpa.persistence.proxy.entities.AnnuityHolder;
import org.apache.openjpa.persistence.proxy.entities.AnnuityPersistebleObject;
import org.apache.openjpa.persistence.proxy.entities.Contact;
import org.apache.openjpa.persistence.proxy.entities.EquityAnnuity;
import org.apache.openjpa.persistence.proxy.entities.FixedAnnuity;
import org.apache.openjpa.persistence.proxy.entities.Payor;
import org.apache.openjpa.persistence.proxy.entities.Payout;
import org.apache.openjpa.persistence.proxy.entities.Person;
import org.apache.openjpa.persistence.proxy.entities.Rider;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestEntitySerialize
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(DROP_TABLES, Address.class, Annuity.class, AnnuityHolder.class, AnnuityPersistebleObject.class, Contact.class, EquityAnnuity.class, FixedAnnuity.class, Payor.class, Payout.class, Person.class, Rider.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSerialization() throws Exception {
        OpenJPAEntityManagerFactorySPI emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"Annuity1Compat", (String)"org/apache/openjpa/persistence/proxy/persistence1.xml");
        TestEntitySerialize.assertNotNull((Object)emf);
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        try {
            em.getTransaction().begin();
            Annuity ann = this.createAnnuity((EntityManager)em);
            TestEntitySerialize.assertNotNull((Object)TestEntitySerialize.roundtrip(ann));
            em.getTransaction().commit();
        }
        finally {
            this.closeEM((EntityManager)em);
        }
    }

    private Annuity createAnnuity(EntityManager em) {
        FixedAnnuity fixedAnn = new FixedAnnuity();
        fixedAnn.setRate(10.0);
        fixedAnn.setId(this.getId());
        fixedAnn.setAmount(500.0);
        fixedAnn.setAccountNumber("123456");
        em.persist((Object)fixedAnn);
        EquityAnnuity equityAnn = new EquityAnnuity();
        equityAnn.setId(this.getId());
        equityAnn.setAmount(500.0);
        equityAnn.setAccountNumber("123456");
        equityAnn.setFundNames("Something nothing wrong");
        equityAnn.setIndexRate(10.99);
        equityAnn.setLastPaidAmt(100.0);
        equityAnn.setPreviousAnnuity(fixedAnn);
        em.persist((Object)equityAnn);
        return equityAnn;
    }

    private String getId() {
        UUID uid = UUID.randomUUID();
        return uid.toString();
    }
}

