/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.proxy;

import java.util.LinkedHashSet;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.proxy.AbstractEntity;
import org.apache.openjpa.persistence.proxy.ConcreteEntity;
import org.apache.openjpa.persistence.proxy.TreeNode;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;
import org.apache.openjpa.util.ChangeTracker;
import org.apache.openjpa.util.ProxyCollection;

public class TestProxyCollection
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, TreeNode.class, ConcreteEntity.class, AbstractEntity.class);
    }

    public void testCreateTree() {
        TreeNode root = new TreeNode();
        root.setName("0");
        int[] fanOuts = new int[]{1, 2, 3};
        root.createTree(fanOuts);
        this.assertArrayEquals(fanOuts, root.getFanOuts());
    }

    public void testModifyTree() {
        int[] fanOuts = new int[]{1, 2, 2, 4};
        int[] newFanOuts = new int[]{1, 3, 1, 2};
        TreeNode root = new TreeNode();
        root.createTree(fanOuts);
        this.assertArrayEquals(fanOuts, root.getFanOuts());
        root.modify(newFanOuts);
        this.assertArrayEquals(newFanOuts, root.getFanOuts());
    }

    public void testPersistTree() {
        int[] fanOuts = new int[]{2, 3, 4};
        this.verify(this.create(fanOuts), fanOuts);
    }

    public void testAddNodeAtLeaf() {
        int[] original = new int[]{1, 2, 3};
        int[] modifier = new int[]{1, 2, 4};
        this.createModifyAndMerge(original, modifier);
    }

    public void testAddNewLevel() {
        int[] original = new int[]{1, 2, 3};
        int[] modifier = new int[]{1, 2, 3, 2};
        this.createModifyAndMerge(original, modifier);
    }

    public void testAddAndRemove() {
        int[] original = new int[]{2, 3, 4};
        int[] modifier = new int[]{4, 3, 2};
        this.createModifyAndMerge(original, modifier);
    }

    public void testAddAtAllLevel() {
        int[] original = new int[]{2, 3, 4};
        int[] modifier = new int[]{3, 4, 5};
        this.createModifyAndMerge(original, modifier);
    }

    public void testRemoveAtAllLevel() {
        int[] original = new int[]{2, 3, 4};
        int[] modifier = new int[]{1, 2, 3};
        this.createModifyAndMerge(original, modifier);
    }

    public void testCreateCorrectType() {
        ConcreteEntity ce = new ConcreteEntity();
        ce.addItem(ce);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)ce);
        em.getTransaction().commit();
        em.clear();
        ce = (ConcreteEntity)em.find(ConcreteEntity.class, (Object)ce.getId());
        TestProxyCollection.assertNotNull((Object)ce);
        Class<?> proxyCls = ce.getItems().getClass();
        TestProxyCollection.assertTrue((String)(proxyCls + " is not assignableFrom " + LinkedHashSet.class), (boolean)LinkedHashSet.class.isAssignableFrom(proxyCls));
    }

    void createModifyAndMerge(int[] original, int[] modifier) {
        TreeNode root = this.create(original);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        TreeNode modified = (TreeNode)em.find(TreeNode.class, (Object)root.getId());
        modified.modify(modifier);
        em.merge((Object)modified);
        em.getTransaction().commit();
        em.clear();
        this.assertProxyCollection(root.getNodes(), false);
        this.verify(root, modifier);
    }

    TreeNode create(int[] original) {
        TreeNode root = new TreeNode();
        root.createTree(original);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)root);
        em.getTransaction().commit();
        em.clear();
        return root;
    }

    void verify(TreeNode node, int[] fanOuts) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        TreeNode test = (TreeNode)em.find(TreeNode.class, (Object)node.getId());
        TestProxyCollection.assertNotNull((Object)test);
        this.assertArrayEquals(fanOuts, test.getFanOuts());
    }

    void assertArrayEquals(int[] a, int[] b) {
        TestProxyCollection.assertEquals((int)a.length, (int)b.length);
        for (int i = 0; i < a.length; ++i) {
            TestProxyCollection.assertEquals((int)a[i], (int)b[i]);
        }
    }

    void assertProxyCollection(Object o, boolean tracking) {
        TestProxyCollection.assertTrue((boolean)(o instanceof ProxyCollection));
        ChangeTracker tracker = ((ProxyCollection)o).getChangeTracker();
        if (tracking) {
            TestProxyCollection.assertNotNull((Object)tracker);
            TestProxyCollection.assertTrue((boolean)tracker.isTracking());
        } else {
            TestProxyCollection.assertFalse((boolean)tracker.isTracking());
        }
    }

    void assertNotProxyCollection(Object o) {
        TestProxyCollection.assertFalse((boolean)(o instanceof ProxyCollection));
    }
}

