/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.proxy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Version;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.DetachedState;
import org.apache.openjpa.persistence.ElementDependent;
import org.apache.openjpa.persistence.jdbc.ElementJoinColumn;
import org.apache.openjpa.persistence.jdbc.OrderColumn;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;

@Entity
@DetachedState
public class TreeNode
implements Serializable,
PersistenceCapable {
    @Id
    @GeneratedValue
    private long id;
    private String name;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @ElementJoinColumn(name="ParentID")
    @OrderColumn(name="Sequence")
    @ElementDependent
    private List<TreeNode> childern = new ArrayList<TreeNode>();
    @Version
    private int version;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient boolean pcVersionInit;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$proxy$TreeNode;
    private transient Object pcDetachedState;
    private static final long serialVersionUID;

    public long getId() {
        return TreeNode.pcGetid(this);
    }

    public String getName() {
        return TreeNode.pcGetname(this);
    }

    public void setName(String name) {
        TreeNode.pcSetname(this, name);
    }

    public void addNode(TreeNode node) {
        this.addNode(node, TreeNode.pcGetchildern(this).size());
    }

    public void addNode(TreeNode node, int position) {
        this.checkSequenceRange(position);
        TreeNode.pcGetchildern(this).add(position, node);
    }

    public boolean removeNode(TreeNode node) {
        return TreeNode.pcGetchildern(this).remove(node);
    }

    public TreeNode removeNode(int sequence) {
        this.checkSequenceRange(sequence);
        return (TreeNode)TreeNode.pcGetchildern(this).remove(sequence);
    }

    public TreeNode getNode(int sequence) {
        this.checkSequenceRange(sequence);
        return (TreeNode)TreeNode.pcGetchildern(this).get(sequence);
    }

    public List<TreeNode> getNodes() {
        return TreeNode.pcGetchildern(this);
    }

    public void clearNodes() {
        TreeNode.pcGetchildern(this).clear();
    }

    public boolean isLeaf() {
        return TreeNode.pcGetchildern(this).isEmpty();
    }

    protected void checkSequenceRange(int sequence) throws IllegalArgumentException {
        int size = TreeNode.pcGetchildern(this).size();
        if (sequence < 0 || sequence > size) {
            throw new IllegalArgumentException("Sequence number is beyond range of 0 to " + size + ".");
        }
    }

    public int getVersion() {
        return TreeNode.pcGetversion(this);
    }

    public void createTree(int[] fanOuts) {
        if (fanOuts.length == 0) {
            return;
        }
        int[] nextFanOuts = new int[fanOuts.length];
        System.arraycopy(fanOuts, 1, nextFanOuts, 0, fanOuts.length - 1);
        for (int j = 0; j < fanOuts[0]; ++j) {
            TreeNode child = new TreeNode();
            child.setName(this.getName() + "." + j);
            this.addNode(child);
            child.createTree(nextFanOuts);
        }
    }

    public void modify(int[] fanOuts) {
        int i;
        if (fanOuts == null || fanOuts.length == 0) {
            return;
        }
        int n = fanOuts[0];
        int[] nextFanOuts = new int[fanOuts.length];
        System.arraycopy(fanOuts, 1, nextFanOuts, 0, fanOuts.length - 1);
        List<TreeNode> children = this.getNodes();
        int diff = children.size() - n;
        if (diff < 0) {
            for (i = 0; i < -diff; ++i) {
                TreeNode newChild = new TreeNode();
                int position = this.getNodes().size();
                newChild.setName(this.getName() + "." + position);
                this.addNode(newChild);
            }
        } else if (diff > 0) {
            for (i = 0; i < diff; ++i) {
                int position = this.getNodes().size() - 1;
                this.removeNode(position);
            }
        }
        children = this.getNodes();
        for (TreeNode child : children) {
            child.modify(nextFanOuts);
        }
    }

    public int[] getFanOuts() {
        return this.getFanOuts(new int[0]);
    }

    private int[] getFanOuts(int[] list) {
        List<TreeNode> children = this.getNodes();
        if (children.isEmpty()) {
            return list;
        }
        int[] fanOuts = new int[children.size()];
        int i = 0;
        for (TreeNode child : children) {
            fanOuts[i++] = child.getNodes().size();
        }
        for (int j = 0; j < fanOuts.length - 1; ++j) {
            if (fanOuts[j] == fanOuts[j + 1]) continue;
            throw new RuntimeException("non-uniform fanouts for children  of " + this.getName());
        }
        int[] newList = new int[list.length + 1];
        System.arraycopy(list, 0, newList, 0, list.length);
        newList[list.length] = children.size();
        return children.get(0).getFanOuts(newList);
    }

    public void print(PrintStream out) {
        this.print(2, out);
    }

    private void print(int tab, PrintStream out) {
        for (int i = 0; i < tab; ++i) {
            out.print(" ");
        }
        out.println(this.getName());
        for (TreeNode child : this.getNodes()) {
            child.print(tab + 2, out);
        }
    }

    public int pcGetEnhancementContractVersion() {
        return 1674154;
    }

    static {
        serialVersionUID = 4798946931693726888L;
        pcFieldNames = new String[]{"childern", "id", "name", "version"};
        Class[] classArray = new Class[4];
        Class clazz = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = TreeNode.class$("java.util.List"));
        classArray[0] = clazz;
        classArray[1] = Long.TYPE;
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = TreeNode.class$("java.lang.String"));
        classArray[2] = clazz2;
        classArray[3] = Integer.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{5, 26, 26, 21};
        Class clazz3 = class$Lorg$apache$openjpa$persistence$proxy$TreeNode != null ? class$Lorg$apache$openjpa$persistence$proxy$TreeNode : (class$Lorg$apache$openjpa$persistence$proxy$TreeNode = TreeNode.class$("org.apache.openjpa.persistence.proxy.TreeNode"));
        PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"TreeNode", (PersistenceCapable)new TreeNode());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.childern = null;
        this.id = 0L;
        this.name = null;
        this.version = 0;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        TreeNode treeNode = new TreeNode();
        if (bl) {
            treeNode.pcClearFields();
        }
        treeNode.pcStateManager = stateManager;
        treeNode.pcCopyKeyFieldsFromObjectId(object);
        return treeNode;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        TreeNode treeNode = new TreeNode();
        if (bl) {
            treeNode.pcClearFields();
        }
        treeNode.pcStateManager = stateManager;
        return treeNode;
    }

    protected static int pcGetManagedFieldCount() {
        return 4;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.childern = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.id = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.version = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                this.pcVersionInit = true;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.childern);
                return;
            }
            case 1: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 3: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.version);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(TreeNode treeNode, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.childern = treeNode.childern;
                return;
            }
            case 1: {
                this.id = treeNode.id;
                return;
            }
            case 2: {
                this.name = treeNode.name;
                return;
            }
            case 3: {
                this.version = treeNode.version;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        TreeNode treeNode = (TreeNode)object;
        if (treeNode.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(treeNode, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return new Integer(this.version);
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeLongField(1 + pcInheritedFieldCount, longId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.id = longId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openjpa$persistence$proxy$TreeNode != null ? class$Lorg$apache$openjpa$persistence$proxy$TreeNode : (class$Lorg$apache$openjpa$persistence$proxy$TreeNode = TreeNode.class$("org.apache.openjpa.persistence.proxy.TreeNode"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openjpa$persistence$proxy$TreeNode != null ? class$Lorg$apache$openjpa$persistence$proxy$TreeNode : (class$Lorg$apache$openjpa$persistence$proxy$TreeNode = TreeNode.class$("org.apache.openjpa.persistence.proxy.TreeNode"));
        return new LongId(clazz, this.id);
    }

    private static final List pcGetchildern(TreeNode treeNode) {
        if (treeNode.pcStateManager == null) {
            return treeNode.childern;
        }
        int n = pcInheritedFieldCount + 0;
        treeNode.pcStateManager.accessingField(n);
        return treeNode.childern;
    }

    private static final void pcSetchildern(TreeNode treeNode, List list) {
        if (treeNode.pcStateManager == null) {
            treeNode.childern = list;
            return;
        }
        treeNode.pcStateManager.settingObjectField((PersistenceCapable)treeNode, pcInheritedFieldCount + 0, treeNode.childern, (Object)list, 0);
    }

    private static final long pcGetid(TreeNode treeNode) {
        if (treeNode.pcStateManager == null) {
            return treeNode.id;
        }
        int n = pcInheritedFieldCount + 1;
        treeNode.pcStateManager.accessingField(n);
        return treeNode.id;
    }

    private static final void pcSetid(TreeNode treeNode, long l) {
        if (treeNode.pcStateManager == null) {
            treeNode.id = l;
            return;
        }
        treeNode.pcStateManager.settingLongField((PersistenceCapable)treeNode, pcInheritedFieldCount + 1, treeNode.id, l, 0);
    }

    private static final String pcGetname(TreeNode treeNode) {
        if (treeNode.pcStateManager == null) {
            return treeNode.name;
        }
        int n = pcInheritedFieldCount + 2;
        treeNode.pcStateManager.accessingField(n);
        return treeNode.name;
    }

    private static final void pcSetname(TreeNode treeNode, String string) {
        if (treeNode.pcStateManager == null) {
            treeNode.name = string;
            return;
        }
        treeNode.pcStateManager.settingStringField((PersistenceCapable)treeNode, pcInheritedFieldCount + 2, treeNode.name, string, 0);
    }

    private static final int pcGetversion(TreeNode treeNode) {
        if (treeNode.pcStateManager == null) {
            return treeNode.version;
        }
        int n = pcInheritedFieldCount + 3;
        treeNode.pcStateManager.accessingField(n);
        return treeNode.version;
    }

    private static final void pcSetversion(TreeNode treeNode, int n) {
        if (treeNode.pcStateManager == null) {
            treeNode.version = n;
            treeNode.pcVersionInit = true;
            return;
        }
        treeNode.pcStateManager.settingIntField((PersistenceCapable)treeNode, pcInheritedFieldCount + 3, treeNode.version, n, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.version != 0) {
            return Boolean.TRUE;
        }
        if (this.pcVersionInit) {
            return Boolean.TRUE;
        }
        return null;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

