/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.proxy.delayed;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.DetachedStateManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.proxy.delayed.Award;
import org.apache.openjpa.persistence.proxy.delayed.Certification;
import org.apache.openjpa.persistence.proxy.delayed.IAccount;
import org.apache.openjpa.persistence.proxy.delayed.IDepartment;
import org.apache.openjpa.persistence.proxy.delayed.IEmployee;
import org.apache.openjpa.persistence.proxy.delayed.IMember;
import org.apache.openjpa.persistence.proxy.delayed.IUserIdentity;
import org.apache.openjpa.persistence.proxy.delayed.Location;
import org.apache.openjpa.persistence.proxy.delayed.Product;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;
import org.apache.openjpa.util.DelayedProxy;
import org.apache.openjpa.util.Proxy;
import org.apache.openjpa.util.ProxyCollection;

public abstract class DelayedProxyCollectionsTestCase
extends SQLListenerTestCase {
    protected static Set<String> _ignoreMethods;
    protected static Set<String> _delayMethods;
    protected static Set<Class<?>> _ignoreInterfaces;

    @Override
    public void setUp(Object ... props) {
        ArrayList<Object> parms = new ArrayList<Object>();
        parms.addAll(Arrays.asList(CLEAR_TABLES, "openjpa.ProxyManager", "delayCollectionLoading=true", Award.class, Location.class, Product.class, Certification.class));
        parms.addAll(Arrays.asList(props));
        super.setUp(parms.toArray());
    }

    public abstract IAccount createAccount(String var1, IUserIdentity var2);

    public abstract IDepartment createDepartment();

    public abstract IDepartment findDepartment(EntityManager var1, int var2);

    public abstract IEmployee createEmployee();

    public abstract Collection<IEmployee> createEmployees();

    public abstract IMember createMember(String var1);

    public abstract IUserIdentity findUserIdentity(EntityManager var1, int var2);

    public abstract IUserIdentity createUserIdentity();

    public abstract Collection<Product> createProducts();

    public abstract Collection<Certification> createCertifications();

    public abstract IEmployee getEmployee(Collection<IEmployee> var1, int var2);

    public abstract Collection<Award> createAwards();

    public abstract Product getProduct(Collection<Product> var1, int var2);

    public abstract Collection<Location> createLocations();

    public abstract Collection<IAccount> createAccounts();

    public static String stringMethodName(Method m) {
        return DelayedProxyCollectionsTestCase.stringMethodName(m.getName(), m.getParameterTypes());
    }

    public static String stringMethodName(String m, Class<?>[] types) {
        StringBuilder sb = new StringBuilder(m);
        if (types != null) {
            for (Class<?> type : types) {
                sb.append(":");
                sb.append(type.getName());
            }
        }
        return sb.toString();
    }

    public Set<String> methodsToIgnore() {
        return _ignoreMethods;
    }

    public Award createAward() {
        Award a = new Award();
        a.setAwdName("Employee of the Month " + new Random().nextInt(999999));
        a.setAwdType("Certificate");
        return a;
    }

    public Certification createCertification() {
        Certification c = new Certification();
        c.setName("Certification XYZ " + new Random().nextInt(999999));
        c.setCertDate(new Date());
        return c;
    }

    public Product createProduct() {
        Product p = new Product();
        p.setName("Product : " + new Random().nextInt(999999));
        return p;
    }

    public Location createLocation() {
        Location l = new Location();
        l.setAddress(new Random().nextInt(9999) + " Wandering Way");
        l.setCity("Somewhere");
        l.setZip(Integer.toString(new Random().nextInt(99999)));
        return l;
    }

    public void testSingleRemove() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        IDepartment d = this.createDepartment();
        IEmployee e = this.createEmployee();
        e.setDept(d);
        e.setEmpName("John");
        IEmployee e2 = this.createEmployee();
        e2.setDept(d);
        e2.setEmpName("Joe");
        Collection<IEmployee> emps = this.createEmployees();
        emps.add(e);
        emps.add(e2);
        d.setEmployees(emps);
        em.getTransaction().begin();
        em.persist((Object)d);
        em.getTransaction().commit();
        em.clear();
        this.resetSQL();
        d = this.findDepartment((EntityManager)em, d.getId());
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        DelayedProxyCollectionsTestCase.assertNotNull((Object)d);
        emps = d.getEmployees();
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        DelayedProxyCollectionsTestCase.assertTrue((boolean)(emps instanceof DelayedProxy));
        DelayedProxy dep = (DelayedProxy)emps;
        dep.setDirectAccess(true);
        DelayedProxyCollectionsTestCase.assertEquals((int)0, (int)emps.size());
        dep.setDirectAccess(false);
        DelayedProxyCollectionsTestCase.assertNotNull(emps);
        this.resetSQL();
        em.getTransaction().begin();
        emps.remove(e);
        em.getTransaction().commit();
        this.assertAnySQLAnyOrder("DELETE FROM DC_DEP_EMP .*");
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*", "SELECT .* DC_DEPARTMENT .*");
        this.resetSQL();
        DelayedProxyCollectionsTestCase.assertEquals((int)1, (int)emps.size());
        this.assertAnySQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        IEmployee e3 = this.getEmployee(emps, 0);
        DelayedProxyCollectionsTestCase.assertEquals((Object)e2, (Object)e3);
        em.close();
    }

    public void testSingleAdd() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        IDepartment d = this.createDepartment();
        IEmployee e = this.createEmployee();
        e.setDept(d);
        e.setEmpName("John");
        Collection<IEmployee> emps = this.createEmployees();
        emps.add(e);
        d.setEmployees(emps);
        em.getTransaction().begin();
        em.persist((Object)d);
        em.getTransaction().commit();
        em.clear();
        this.resetSQL();
        d = this.findDepartment((EntityManager)em, d.getId());
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        DelayedProxyCollectionsTestCase.assertNotNull((Object)d);
        emps = d.getEmployees();
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        DelayedProxyCollectionsTestCase.assertTrue((boolean)(emps instanceof DelayedProxy));
        DelayedProxy dep = (DelayedProxy)emps;
        dep.setDirectAccess(true);
        DelayedProxyCollectionsTestCase.assertEquals((int)0, (int)emps.size());
        dep.setDirectAccess(false);
        DelayedProxyCollectionsTestCase.assertNotNull(emps);
        this.resetSQL();
        em.getTransaction().begin();
        IEmployee e2 = this.createEmployee();
        e2.setDept(d);
        e2.setEmpName("Joe");
        emps.add(e2);
        em.getTransaction().commit();
        this.assertAnySQLAnyOrder("INSERT INTO DC_DEP_EMP .*");
        this.assertAnySQLAnyOrder("INSERT INTO DC_EMPLOYEE .*");
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*", "SELECT .* DC_DEPARTMENT .*");
        this.resetSQL();
        DelayedProxyCollectionsTestCase.assertTrue((boolean)emps.contains(e));
        DelayedProxyCollectionsTestCase.assertTrue((boolean)emps.contains(e2));
        this.assertAnySQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        this.resetSQL();
        DelayedProxyCollectionsTestCase.assertEquals((int)2, (int)emps.size());
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        em.close();
    }

    public void testMixedAddRemove() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        IDepartment d = this.createDepartment();
        IEmployee e = this.createEmployee();
        e.setDept(d);
        e.setEmpName("John");
        Collection<IEmployee> emps = this.createEmployees();
        emps.add(e);
        d.setEmployees(emps);
        em.getTransaction().begin();
        em.persist((Object)d);
        em.getTransaction().commit();
        em.clear();
        this.resetSQL();
        d = this.findDepartment((EntityManager)em, d.getId());
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        DelayedProxyCollectionsTestCase.assertNotNull((Object)d);
        emps = d.getEmployees();
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        DelayedProxyCollectionsTestCase.assertTrue((boolean)(emps instanceof DelayedProxy));
        DelayedProxy dep = (DelayedProxy)emps;
        dep.setDirectAccess(true);
        DelayedProxyCollectionsTestCase.assertEquals((int)0, (int)emps.size());
        dep.setDirectAccess(false);
        DelayedProxyCollectionsTestCase.assertNotNull(emps);
        this.resetSQL();
        em.getTransaction().begin();
        IEmployee e2 = this.createEmployee();
        e2.setDept(d);
        e2.setEmpName("Joe");
        emps.add(e2);
        emps.remove(e2);
        em.getTransaction().commit();
        this.assertNoneSQLAnyOrder("INSERT INTO DC_DEP_EMP .*");
        this.assertNoneSQLAnyOrder("INSERT INTO DC_EMPLOYEE .*");
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*", "SELECT .* DC_DEPARTMENT .*");
        this.resetSQL();
        em.getTransaction().begin();
        IEmployee e3 = this.createEmployee();
        e3.setDept(d);
        e3.setEmpName("Rhonda");
        emps.add(e3);
        IEmployee e4 = this.createEmployee();
        e4.setDept(d);
        e4.setEmpName("Maria");
        emps.add(e4);
        emps.remove(e3);
        em.getTransaction().commit();
        this.assertAnySQLAnyOrder("INSERT INTO DC_DEP_EMP .*");
        this.assertAnySQLAnyOrder("INSERT INTO DC_EMPLOYEE .*");
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*", "SELECT .* DC_DEPARTMENT .*");
        this.resetSQL();
        DelayedProxyCollectionsTestCase.assertTrue((boolean)emps.contains(e));
        DelayedProxyCollectionsTestCase.assertFalse((boolean)emps.contains(e2));
        DelayedProxyCollectionsTestCase.assertFalse((boolean)emps.contains(e3));
        DelayedProxyCollectionsTestCase.assertTrue((boolean)emps.contains(e4));
        this.assertAnySQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        this.resetSQL();
        DelayedProxyCollectionsTestCase.assertEquals((int)2, (int)emps.size());
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        em.close();
    }

    public void testEagerCollection() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        IDepartment d = this.createDepartment();
        Collection<Product> products = this.createProducts();
        Product p = this.createProduct();
        products.add(p);
        Product p2 = this.createProduct();
        products.add(p2);
        d.setProducts(products);
        em.getTransaction().begin();
        em.persist((Object)d);
        em.getTransaction().commit();
        this.resetSQL();
        em.clear();
        d = this.findDepartment((EntityManager)em, d.getId());
        this.assertAnySQLAnyOrder("SELECT .* DC_DEP_PRD .*");
        this.resetSQL();
        products = d.getProducts();
        DelayedProxyCollectionsTestCase.assertTrue((boolean)(products instanceof DelayedProxy));
        ProxyCollection pxycoll = (ProxyCollection)products;
        DelayedProxyCollectionsTestCase.assertFalse((boolean)pxycoll.getOwner().isDelayed(pxycoll.getOwnerField()));
        Product p3 = this.getProduct(products, 0);
        DelayedProxyCollectionsTestCase.assertTrue((boolean)products.contains(p3));
        DelayedProxyCollectionsTestCase.assertEquals((int)2, (int)products.size());
        this.assertNoneSQLAnyOrder("SELECT .* DC_DEPARTMENT .*", "SELECT .* DC_DEP_PRD .*");
        em.close();
    }

    public void testOrderedCollection() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        IDepartment d = this.createDepartment();
        Location l = this.createLocation();
        Collection<Location> locs = this.createLocations();
        locs.add(l);
        d.setLocations(locs);
        em.getTransaction().begin();
        em.persist((Object)d);
        em.getTransaction().commit();
        em.clear();
        d = this.findDepartment((EntityManager)em, d.getId());
        this.assertNoneSQLAnyOrder("SELECT .* DC_DEP_LOC .*");
        this.resetSQL();
        Collection<Location> locations = d.getLocations();
        this.assertAnySQLAnyOrder("SELECT .* DC_DEP_LOC .*");
        this.resetSQL();
        DelayedProxyCollectionsTestCase.assertTrue((boolean)(locations instanceof DelayedProxy));
        ProxyCollection pxycoll = (ProxyCollection)locations;
        DelayedProxyCollectionsTestCase.assertFalse((boolean)pxycoll.getOwner().isDelayed(pxycoll.getOwnerField()));
        DelayedProxyCollectionsTestCase.assertEquals((int)1, (int)locations.size());
        this.assertNoneSQLAnyOrder("SELECT .* DC_DEPARTMENT .*", "SELECT .* DC_DEP_LOC .*");
        em.close();
    }

    public void testSerialization() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        IDepartment d = this.createDepartment();
        IEmployee e = this.createEmployee();
        e.setDept(d);
        e.setEmpName("John");
        Collection<IEmployee> emps = this.createEmployees();
        emps.add(e);
        d.setEmployees(emps);
        em.getTransaction().begin();
        em.persist((Object)d);
        em.getTransaction().commit();
        em.clear();
        this.resetSQL();
        d = this.findDepartment((EntityManager)em, d.getId());
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        DelayedProxyCollectionsTestCase.assertNotNull((Object)d);
        emps = d.getEmployees();
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        DelayedProxyCollectionsTestCase.assertTrue((boolean)(emps instanceof DelayedProxy));
        DelayedProxy dep = (DelayedProxy)emps;
        dep.setDirectAccess(true);
        DelayedProxyCollectionsTestCase.assertEquals((int)0, (int)emps.size());
        dep.setDirectAccess(false);
        DelayedProxyCollectionsTestCase.assertNotNull(emps);
        this.resetSQL();
        em.getTransaction().begin();
        IEmployee e2 = this.createEmployee();
        e2.setDept(d);
        e2.setEmpName("Joe");
        emps.add(e2);
        em.getTransaction().commit();
        this.assertAnySQLAnyOrder("INSERT INTO DC_DEP_EMP .*");
        this.assertAnySQLAnyOrder("INSERT INTO DC_EMPLOYEE .*");
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*", "SELECT .* DC_DEPARTMENT .*");
        this.resetSQL();
        try {
            IDepartment d2 = DelayedProxyCollectionsTestCase.roundtrip(d);
            this.assertAnySQLAnyOrder("SELECT .* DC_EMPLOYEE .*", "SELECT .* DC_DEP_EMP .*");
            emps = d2.getEmployees();
            DelayedProxyCollectionsTestCase.assertTrue((boolean)emps.contains(e));
            DelayedProxyCollectionsTestCase.assertTrue((boolean)emps.contains(e2));
            DelayedProxyCollectionsTestCase.assertEquals((int)2, (int)emps.size());
        }
        catch (Exception ex) {
            DelayedProxyCollectionsTestCase.fail((String)ex.getMessage());
        }
        em.close();
    }

    public void testLazyEmbeddableCollection() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        IDepartment d = this.createDepartment();
        Collection<Certification> certs = this.createCertifications();
        certs.add(this.createCertification());
        certs.add(this.createCertification());
        d.setCertifications(certs);
        em.getTransaction().begin();
        em.persist((Object)d);
        em.getTransaction().commit();
        this.resetSQL();
        em.clear();
        d = this.findDepartment((EntityManager)em, d.getId());
        this.assertNoneSQLAnyOrder("SELECT .* DC_DEP_CERT .*");
        this.resetSQL();
        certs = d.getCertifications();
        this.assertNoneSQLAnyOrder("SELECT .* DC_DEP_CERT .*");
        DelayedProxyCollectionsTestCase.assertTrue((boolean)(certs instanceof DelayedProxy));
        DelayedProxyCollectionsTestCase.assertEquals((int)2, (int)certs.size());
        this.assertAnySQLAnyOrder("SELECT .* DC_DEP_CERT .*");
        em.close();
    }

    public void testEagerEmbeddableCollection() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        IDepartment d = this.createDepartment();
        Collection<Award> awards = this.createAwards();
        awards.add(this.createAward());
        awards.add(this.createAward());
        awards.add(this.createAward());
        d.setAwards(awards);
        em.getTransaction().begin();
        em.persist((Object)d);
        em.getTransaction().commit();
        this.resetSQL();
        em.clear();
        d = this.findDepartment((EntityManager)em, d.getId());
        this.assertAnySQLAnyOrder("SELECT .* DC_DEP_AWD .*");
        this.resetSQL();
        awards = d.getAwards();
        ProxyCollection pxycoll = (ProxyCollection)awards;
        DelayedProxyCollectionsTestCase.assertFalse((boolean)pxycoll.getOwner().isDelayed(pxycoll.getOwnerField()));
        this.assertNoneSQLAnyOrder("SELECT .* DC_DEP_AWD .*");
        DelayedProxyCollectionsTestCase.assertTrue((boolean)(awards instanceof DelayedProxy));
        DelayedProxyCollectionsTestCase.assertEquals((int)3, (int)awards.size());
        this.assertNoneSQLAnyOrder("SELECT .* DC_DEP_AWD .*");
        em.close();
    }

    public void testPostDetach() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        IDepartment d = this.createDepartment();
        IEmployee e = this.createEmployee();
        e.setDept(d);
        e.setEmpName("John");
        Collection<IEmployee> emps = this.createEmployees();
        emps.add(e);
        d.setEmployees(emps);
        em.getTransaction().begin();
        em.persist((Object)d);
        em.getTransaction().commit();
        this.resetSQL();
        em.clear();
        d = this.findDepartment((EntityManager)em, d.getId());
        emps = d.getEmployees();
        em.close();
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        DelayedProxyCollectionsTestCase.assertTrue((boolean)(emps instanceof DelayedProxy));
        DelayedProxy dep = (DelayedProxy)emps;
        dep.setDirectAccess(true);
        DelayedProxyCollectionsTestCase.assertEquals((int)0, (int)emps.size());
        dep.setDirectAccess(false);
        DelayedProxyCollectionsTestCase.assertNotNull(emps);
        this.resetSQL();
        DelayedProxyCollectionsTestCase.assertTrue((boolean)emps.contains(e));
        e = this.getEmployee(emps, 0);
        this.assertAnySQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        this.resetSQL();
        DelayedProxyCollectionsTestCase.assertEquals((int)1, (int)emps.size());
        DelayedProxyCollectionsTestCase.assertTrue((boolean)(e instanceof PersistenceCapable));
        PersistenceCapable pc = (PersistenceCapable)e;
        DelayedProxyCollectionsTestCase.assertTrue((boolean)(pc.pcGetStateManager() instanceof DetachedStateManager));
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        IEmployee e2 = this.createEmployee();
        e2.setDept(d);
        emps.add(e2);
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.merge((Object)d);
        em.getTransaction().commit();
        emps = d.getEmployees();
        this.assertAnySQLAnyOrder("INSERT INTO DC_DEP_EMP .*");
        this.assertAnySQLAnyOrder("INSERT INTO DC_EMPLOYEE .*");
        DelayedProxyCollectionsTestCase.assertEquals((int)2, (int)emps.size());
        em.close();
        emps.remove(e);
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.merge((Object)d);
        em.getTransaction().commit();
        emps = d.getEmployees();
        this.assertAnySQLAnyOrder("DELETE FROM DC_DEP_EMP .*");
        DelayedProxyCollectionsTestCase.assertEquals((int)1, (int)emps.size());
        em.close();
    }

    public void testEmbeddableRelationship() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        IUserIdentity ui = this.createUserIdentity();
        IMember m = this.createMember("Member 1");
        ui.setMember(m);
        Collection<IAccount> accounts = this.createAccounts();
        IAccount checking = this.createAccount("Checking", ui);
        accounts.add(checking);
        IAccount savings = this.createAccount("Savings", ui);
        accounts.add(savings);
        em.getTransaction().begin();
        em.persist((Object)ui);
        em.persist((Object)checking);
        em.persist((Object)savings);
        em.getTransaction().commit();
        em.clear();
        ui = this.findUserIdentity((EntityManager)em, ui.getId());
        m = ui.getMember();
        this.resetSQL();
        accounts = m.getAccounts();
        ProxyCollection pxycoll = (ProxyCollection)accounts;
        DelayedProxyCollectionsTestCase.assertTrue((boolean)pxycoll.getOwner().isDelayed(pxycoll.getOwnerField()));
        this.assertNoneSQLAnyOrder("SELECT .* DC_ACCOUNT .*");
        DelayedProxyCollectionsTestCase.assertTrue((boolean)(accounts instanceof DelayedProxy));
        int count = 0;
        for (IAccount a : accounts) {
            ++count;
        }
        DelayedProxyCollectionsTestCase.assertEquals((int)2, (int)count);
        this.assertAnySQLAnyOrder("SELECT .* DC_ACCOUNT .*");
        em.close();
    }

    public void testProxyMethods() {
        Method[] methods;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        IDepartment d = this.createDepartment();
        Collection<IEmployee> emps = this.createEmployees();
        for (int i = 0; i < 50; ++i) {
            IEmployee e = this.createEmployee();
            e.setDept(d);
            e.setEmpName("Employee: " + i);
            emps.add(e);
        }
        d.setEmployees(emps);
        em.getTransaction().begin();
        em.persist((Object)d);
        em.getTransaction().commit();
        em.clear();
        this.resetSQL();
        Class<?> collType = emps.getClass();
        for (Method m : methods = collType.getMethods()) {
            if (this.excludeMethod(m)) continue;
            this.buildAndInvoke(m, (EntityManager)em, d.getId(), emps);
        }
        em.close();
    }

    private void buildAndInvoke(Method m, EntityManager em, int id, Collection<IEmployee> emps) {
        em.clear();
        this.resetSQL();
        IDepartment d = this.findDepartment(em, id);
        Collection<IEmployee> emps2 = d.getEmployees();
        DelayedProxyCollectionsTestCase.assertTrue((boolean)(emps2 instanceof DelayedProxy));
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        try {
            m.invoke(emps2, this.buildArgs(m, emps));
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (_delayMethods.contains(DelayedProxyCollectionsTestCase.stringMethodName(m))) {
            this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        } else {
            this.assertAnySQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        }
    }

    private Object[] buildArgs(Method m, Collection<?> emps) {
        Class<?>[] parmTypes = m.getParameterTypes();
        if (parmTypes == null) {
            return new Object[0];
        }
        int intNum = 0;
        int objNum = 0;
        Object[] parms = new Object[parmTypes.length];
        for (int i = 0; i < parmTypes.length; ++i) {
            Class<?> parmType = parmTypes[i];
            if (parmTypes[i].equals(Integer.TYPE)) {
                parms[i] = intNum;
                ++intNum;
                continue;
            }
            if (parmTypes[i].equals(Boolean.TYPE)) {
                parms[i] = true;
                continue;
            }
            if (parmTypes[i].equals(Object.class)) {
                parms[i] = emps.toArray()[objNum];
                ++objNum;
                continue;
            }
            if (!parmTypes[i].isAssignableFrom(Collection.class)) continue;
            parms[i] = emps;
        }
        return parms;
    }

    private boolean excludeMethod(Method m) {
        if (_ignoreInterfaces.contains(m.getDeclaringClass())) {
            return true;
        }
        return _ignoreMethods.contains(DelayedProxyCollectionsTestCase.stringMethodName(m));
    }

    static {
        _delayMethods = new HashSet<String>();
        _delayMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("add", new Class[]{Object.class}));
        _delayMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("remove", new Class[]{Object.class}));
        _delayMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("removeAll", new Class[]{Collection.class}));
        _delayMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("addAll", new Class[]{Collection.class}));
        _delayMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("offer", new Class[]{Object.class}));
        _delayMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("addElement", new Class[]{Object.class}));
        _delayMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("removeElement", new Class[]{Object.class}));
        _ignoreMethods = new HashSet<String>();
        _ignoreMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("trimToSize", null));
        _ignoreMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("ensureCapacity", new Class[]{Integer.TYPE}));
        _ignoreMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("comparator", null));
        _ignoreMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("wait", new Class[]{Long.TYPE}));
        _ignoreMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("wait", null));
        _ignoreMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("wait", new Class[]{Long.TYPE, Integer.TYPE}));
        _ignoreMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("getClass", null));
        _ignoreMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("notify", null));
        _ignoreMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("notifyAll", null));
        _ignoreInterfaces = new HashSet();
        _ignoreInterfaces.add(DelayedProxy.class);
        _ignoreInterfaces.add(Proxy.class);
        _ignoreInterfaces.add(ProxyCollection.class);
        _ignoreMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("spliterator", null));
        _ignoreMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("stream", null));
        _ignoreMethods.add(DelayedProxyCollectionsTestCase.stringMethodName("parallelStream", null));
        _ignoreMethods.add("removeIf:java.util.function.Predicate");
        _ignoreMethods.add("forEach:java.util.function.Consumer");
        _ignoreMethods.add("replaceAll:java.util.function.UnaryOperator");
        _ignoreMethods.add("sort:java.util.Comparator");
    }
}

