/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.query.BaseQueryTest;
import org.apache.openjpa.persistence.query.common.apps.Entity1;
import org.apache.openjpa.persistence.query.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.query.common.apps.RuntimeTest2;

public class TestEJBDeleteUpdateImpl
extends BaseQueryTest {
    RuntimeTest1 runt1;
    RuntimeTest2 runt2;
    Entity1 ent;

    public TestEJBDeleteUpdateImpl(String test) {
        super(test);
    }

    public void setUp() {
        this.deleteAll(RuntimeTest1.class);
        this.deleteAll(RuntimeTest2.class);
        this.deleteAll(Entity1.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        this.runt1 = new RuntimeTest1(1);
        this.runt1.setStringField("runt1");
        this.runt1.setSelfOneOne(new RuntimeTest1(2));
        this.runt2 = new RuntimeTest2(3);
        this.runt2.setStringField("runt2");
        this.ent = new Entity1(23L, "UPDATEST", 100);
        em.persist((Object)this.runt1);
        em.persist((Object)this.runt2);
        em.persist((Object)this.ent);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testUpdate1() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        RuntimeTest1 ret = (RuntimeTest1)em.find(RuntimeTest1.class, em.getObjectId((Object)this.runt1));
        TestEJBDeleteUpdateImpl.assertNotNull((Object)ret);
        TestEJBDeleteUpdateImpl.assertEquals((String)"runt1", (String)ret.getStringField());
        TestEJBDeleteUpdateImpl.assertNotNull((Object)ret.getSelfOneOne());
        String ejbqlUpdate = "UPDATE RuntimeTest1 x SET x.stringField = :strngfld WHERE x.stringField = :stdfield";
        int updatedEntities = em.createQuery(ejbqlUpdate).setParameter("strngfld", (Object)"runner13").setParameter("stdfield", (Object)"runt1").executeUpdate();
        TestEJBDeleteUpdateImpl.assertEquals((int)1, (int)updatedEntities);
        this.endTx((EntityManager)em);
        RuntimeTest1 ret2 = (RuntimeTest1)em.find(RuntimeTest1.class, em.getObjectId((Object)this.runt1));
        em.refresh((Object)ret2);
        TestEJBDeleteUpdateImpl.assertNotNull((Object)ret2);
        TestEJBDeleteUpdateImpl.assertEquals((String)"runner13", (String)ret2.getStringField());
        this.endEm((EntityManager)em);
    }

    public void testUpdate2() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        RuntimeTest1 run = (RuntimeTest1)em.find(RuntimeTest1.class, em.getObjectId((Object)this.runt1));
        TestEJBDeleteUpdateImpl.assertNotNull((Object)run);
        TestEJBDeleteUpdateImpl.assertEquals((String)"runt1", (String)run.getStringField());
        TestEJBDeleteUpdateImpl.assertNotNull((Object)run.getSelfOneOne());
        String ejbqlUpdate = "UPDATE RuntimeTest1 x SET x.stringField = :strngfld WHERE x.stringField = :field";
        int upEntities = em.createQuery(ejbqlUpdate).setParameter("strngfld", (Object)"upd").setParameter("field", (Object)"runt1").executeUpdate();
        TestEJBDeleteUpdateImpl.assertEquals((int)1, (int)upEntities);
        this.endTx((EntityManager)em);
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        RuntimeTest1 inst = (RuntimeTest1)em.find(RuntimeTest1.class, em.getObjectId((Object)this.runt1));
        em.refresh((Object)inst);
        TestEJBDeleteUpdateImpl.assertNotNull((Object)inst);
        TestEJBDeleteUpdateImpl.assertEquals((String)"upd", (String)inst.getStringField());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testDelete1() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        RuntimeTest1 run = (RuntimeTest1)em.find(RuntimeTest1.class, em.getObjectId((Object)this.runt1));
        TestEJBDeleteUpdateImpl.assertNotNull((Object)run);
        TestEJBDeleteUpdateImpl.assertEquals((String)"runt1", (String)run.getStringField());
        TestEJBDeleteUpdateImpl.assertNotNull((Object)run.getSelfOneOne());
        String ejbdelUpdate = "DELETE  FROM RuntimeTest1 s WHERE s.stringField = :strngfld";
        int delEntity = em.createQuery(ejbdelUpdate).setParameter("strngfld", (Object)"runt1").executeUpdate();
        TestEJBDeleteUpdateImpl.assertEquals((int)1, (int)delEntity);
        RuntimeTest1 del = (RuntimeTest1)em.find(RuntimeTest1.class, em.getObjectId((Object)this.runt1));
        TestEJBDeleteUpdateImpl.assertNull((Object)del);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testDelete2() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        RuntimeTest1 run = (RuntimeTest1)em.find(RuntimeTest1.class, em.getObjectId((Object)this.runt1));
        TestEJBDeleteUpdateImpl.assertNotNull((Object)run);
        TestEJBDeleteUpdateImpl.assertEquals((String)"runt1", (String)run.getStringField());
        TestEJBDeleteUpdateImpl.assertNotNull((Object)run.getSelfOneOne());
        String ejbdelUpdate = "DELETE  FROM RuntimeTest1 r WHERE r.stringField = ?1";
        OpenJPAQuery query = em.createQuery(ejbdelUpdate);
        query.setParameter(1, (Object)"runt1");
        int ok = query.executeUpdate();
        TestEJBDeleteUpdateImpl.assertEquals((int)1, (int)ok);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testUpdate3() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        Entity1 ent = (Entity1)em.find(Entity1.class, (Object)23);
        TestEJBDeleteUpdateImpl.assertNotNull((Object)ent);
        TestEJBDeleteUpdateImpl.assertEquals((String)"UPDATEST", (String)ent.getStringField());
        int upd = em.createQuery("UPDATE Entity1 e SET e.stringField = 'UPDATEFAILED' WHERE e.pk = 23").executeUpdate();
        TestEJBDeleteUpdateImpl.assertEquals((int)1, (int)upd);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }
}

